/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.EnumSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.Result;
import org.unitarou.swt.ComboStyle;
import org.unitarou.yukinoshita.view.jface.ann.Editor;
import org.unitarou.yukinoshita.view.jface.ann.EnumEditor;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

class ResultEditor
extends Editor {
    private Composite frame_;
    private final EnumEditor<Result.Archetype> enumCombo_;
    private Spinner scoreEditor_;
    private final ScoreModifyListener scoreModifyListener_ = new ScoreModifyListener();
    private final ComboModifyListener comboModifyListener_ = new ComboModifyListener();
    private boolean enableScore_;
    private Result result_;

    ResultEditor() {
        EnumSet<Result.Archetype> enumSet = EnumSet.allOf(Result.Archetype.class);
        enumSet.remove(Result.Archetype.OTHER);
        this.enumCombo_ = EnumEditor.createEnum(EnumSet.of(ComboStyle.PERMIT_NO_CHOICE), enumSet);
        this.enumCombo_.addModifyListener(this.comboModifyListener_);
        this.enableScore_ = false;
        this.result_ = new Result(Result.Archetype.OTHER);
    }

    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(SwtFactory.createInnerGrid(1, true));
        Combo combo = this.enumCombo_.createContents(this.frame_);
        combo.setLayoutData(new GridData(4, 4, true, true));
        this.scoreEditor_ = new Spinner(this.frame_, 2048);
        this.scoreEditor_.addModifyListener(this.scoreModifyListener_);
        this.scoreEditor_.setEnabled(this.enableScore_);
        this.scoreEditor_.setDigits(1);
        this.scoreEditor_.setSelection(0);
        this.scoreEditor_.setMinimum(0);
        this.scoreEditor_.setMaximum(9999);
        this.scoreEditor_.setIncrement(5);
        this.scoreEditor_.setPageIncrement(10);
        this.scoreEditor_.setLayoutData(new GridData(4, 4, true, true));
        return this.frame_;
    }

    public Control getControl() {
        return this.frame_;
    }

    public void close() {
    }

    void setProperty(Property property) {
        if (property == null) {
            this.result_ = new Result(Result.Archetype.OTHER);
            this.enumCombo_.select(null);
            this.scoreEditor_.setSelection(0);
            return;
        }
        String string = property.getString();
        this.result_ = Result.parse(string);
        if (Result.Archetype.OTHER.equals(this.result_.getArchetype())) {
            this.enumCombo_.setText(this.result_.getValue());
        } else {
            this.enumCombo_.select(this.result_.getArchetype());
        }
        this.scoreEditor_.setSelection((int)(this.result_.getScore() * 10.0));
    }

    void setEditable(boolean bl) {
        if (this.enumCombo_.getControl() == null) {
            return;
        }
        this.enumCombo_.getControl().setEnabled(bl);
        this.scoreEditor_.setEnabled(bl && this.enableScore_);
    }

    String getString() {
        Result.Archetype archetype = this.enumCombo_.getSelected();
        if (Result.Archetype.SCORED.contains(archetype)) {
            return archetype.typeName() + String.valueOf((double)this.scoreEditor_.getSelection() / 10.0);
        }
        if (archetype == null) {
            return this.enumCombo_.getText();
        }
        return archetype.typeName();
    }

    private void updateScoreEditorEnabled() {
        Result.Archetype archetype = this.enumCombo_.getSelected();
        if (Result.Archetype.SCORED.contains(archetype)) {
            this.enableScore_ = true;
        } else {
            this.enableScore_ = false;
            this.scoreEditor_.setSelection(0);
        }
        this.scoreEditor_.setEnabled(this.enumCombo_.getControl().getEnabled() && this.enableScore_);
    }

    private class ScoreModifyListener
    implements ModifyListener {
        private ScoreModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            int n = (int)(ResultEditor.this.result_.getScore() * 10.0);
            if (ResultEditor.this.scoreEditor_.getSelection() != n) {
                ResultEditor.this.fireModifyText(ResultEditor.this.enumCombo_.getControl());
            }
        }
    }

    private class ComboModifyListener
    implements ModifyListener {
        private ComboModifyListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            ResultEditor.this.updateScoreEditorEnabled();
            ResultEditor.this.fireModifyText(ResultEditor.this.enumCombo_.getControl());
        }
    }
}

