/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.FontResource;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.Runtimes;
import org.unitarou.ml.Message;
import org.unitarou.swt.Swts;

public class AboutDialog {
    private static final Message NT_ABOUT_YUKINOSHITA = new Message(AboutDialog.class, "ntAboutYukinoshita");
    private static final Message LB_YUKI_VERSION = new Message(AboutDialog.class, "lbYukiVersion");
    private static final Message LB_YUKI_UPDATE = new Message(AboutDialog.class, "lbYukiUpdate");
    private static final Message LB_SWT_VERSION = new Message(AboutDialog.class, "lbSwtVersion");
    private static final Message LB_AVAILABLE_MEMORY = new Message(AboutDialog.class, "lbAvailableMemory");
    private static final ImageResource BANNER = new ImageResource(AboutDialog.class, "banner.png");
    private static final FontResource FONT_VERSION = new FontResource("Helvetica", 10, 1);
    private final List<Status> statusList_ = new ArrayList<Status>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        this.setStatus();
        Shell shell = new Shell(Display.getCurrent().getActiveShell(), 67680);
        try {
            this.createShell(shell);
            shell.open();
            while (!shell.isDisposed()) {
                shell.getDisplay().sleep();
                shell.getDisplay().readAndDispatch();
            }
        }
        finally {
            Swts.disposeQuietly(shell);
        }
    }

    private void setStatus() {
        this.statusList_.clear();
        this.statusList_.add(new Status(LB_YUKI_VERSION.get(), "2.2.3"));
        this.statusList_.add(new Status(LB_YUKI_UPDATE.get(), "2007/07"));
        this.statusList_.add(new Status(LB_SWT_VERSION.get(), String.valueOf(SWT.getVersion())));
        this.statusList_.add(new Status(LB_AVAILABLE_MEMORY.get(), String.valueOf(Runtimes.byteToMegabyte(Runtimes.availableMemory())) + "MB [" + String.valueOf(Runtimes.byteToMegabyte(Runtime.getRuntime().totalMemory())) + "MB used]"));
    }

    private void createShell(Shell shell) {
        shell.setText(NT_ABOUT_YUKINOSHITA.get());
        Label label = new Label(shell, 0);
        label.setImage(BANNER.get());
        label.setBounds(label.getImage().getBounds());
        label.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                AboutDialog.this.paintLabel(paintEvent.gc);
            }
        });
        shell.pack();
        this.setLocation(shell);
    }

    private void setLocation(Shell shell) {
        Point point = shell.getParent().getSize();
        Point point2 = shell.getParent().getLocation();
        Point point3 = shell.getSize();
        Point point4 = new Point((point.x - point3.x) / 2 + point2.x, (point.y - point3.y) / 2 + point2.y);
        Rectangle rectangle = Display.getCurrent().getBounds();
        point4.x = Math.min(Math.max(point4.x, 0), rectangle.width - point3.x);
        point4.y = Math.min(Math.max(point4.y, 0), rectangle.height - point3.y);
        shell.setLocation(point4);
    }

    private void paintLabel(GC gC) {
        gC.setFont(FONT_VERSION.get());
        Point point = new Point(0, 0);
        for (Status object : this.statusList_) {
            object.labelSize_ = gC.stringExtent(object.label_);
            point.x = Math.max(point.x, ((Status)object).labelSize_.x);
            point.y = Math.max(point.y, ((Status)object).labelSize_.y);
        }
        int n = 80;
        for (Status status : this.statusList_) {
            gC.drawString(status.label_, 5 + point.x - ((Status)status).labelSize_.x, n, true);
            gC.drawString(status.value_, 5 + point.x + 4, n, true);
            n += point.y;
        }
    }

    private static class Status {
        private final String label_;
        private final String value_;
        private Point labelSize_;

        private Status(String string, String string2) {
            this.label_ = string;
            this.value_ = string2;
        }
    }
}

