/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.unitarou.io.Ios;
import org.unitarou.jface.FileFolderListener;
import org.unitarou.jface.FilesTableViewer;
import org.unitarou.jface.FolderListener;
import org.unitarou.jface.FolderTreeViewer;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.swt.USashForm;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.view.jface.board.ol.BasicOutlinePanel;
import org.unitarou.yukinoshita.view.jface.board.ol.CollectionsOutlinePanel;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileChooser;
import org.unitarou.yukinoshita.view.jface.dlg.NamedFileFilter;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

public class ExplorerLikeFileChooser
extends Dialog
implements IgoFileChooser {
    public static final ContextValue<File[]> IGNORE_DRIVES;
    private static final Log log_s_;
    private static final IntContextValue DLG_WIDTH;
    private static final IntContextValue DLG_HEIGHT;
    private static final IntContextValue FOLDER_WIDTH;
    private static final IntContextValue BOARD_WIDTH;
    private static final ContextValue<File> ROOT_DIR;
    private static final Message CLB_FILENAME;
    private static final Message CLB_FILETYPE;
    private static final Message CLB_OPEN;
    private static final Message CLB_SAVE;
    private static final Message LB_CANCEL;
    private static final int OPEN_ID = 1024;
    private static final int SAVE_ID = 1024;
    private static final int CANCEL_ID = 1;
    private static final String DELIMITER = "\"";
    private static File lastFolder_s_;
    private final IgoFileChooser.Style style_;
    private Composite frame_;
    private final FolderTreeViewer folderTreeViewer_;
    private final FilesTableViewer filesTableViewer_;
    private final CollectionsOutlinePanel<BasicOutlinePanel> collectionOutlinePanel_;
    private Text txFilename_;
    private Combo coFilter_;
    private NamedFileFilter[] fileFilters_;
    private File[] files_;

    public ExplorerLikeFileChooser(Shell shell, IgoFileChooser.Style style) {
        super(shell);
        ArgumentChecker.throwIfNull((Object)shell, (Object)style);
        this.setShellStyle(65584);
        CurrentContext currentContext = Yukinoshita.context(null);
        this.style_ = style;
        this.folderTreeViewer_ = new FolderTreeViewer();
        this.folderTreeViewer_.setIgnoreDrives(currentContext.getAttribute(IGNORE_DRIVES));
        this.folderTreeViewer_.addListener(new FolderTreeListener());
        this.filesTableViewer_ = new FilesTableViewer(67586);
        this.filesTableViewer_.addListener(new FileListListener());
        this.collectionOutlinePanel_ = new CollectionsOutlinePanel<BasicOutlinePanel>(BasicOutlinePanel.factory(), 1);
        this.txFilename_ = null;
        this.coFilter_ = null;
        this.fileFilters_ = new NamedFileFilter[0];
        this.files_ = new File[0];
        this.create();
    }

    public void create() {
        super.create();
        this.getShell().setData("widgetKey", ExplorerLikeFileChooser.class.getName());
    }

    protected Control createDialogArea(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = (Composite)super.createDialogArea(composite);
        GridData gridData = (GridData)this.frame_.getLayoutData();
        CurrentContext currentContext = Yukinoshita.context(null);
        gridData.widthHint = currentContext.getInteger(DLG_WIDTH);
        gridData.heightHint = currentContext.getInteger(DLG_HEIGHT);
        USashForm uSashForm = SwtFactory.createUSashForm(this.frame_, 256);
        gridData = new GridData(4, 4, true, true);
        uSashForm.setLayoutData(gridData);
        this.folderTreeViewer_.createContents(uSashForm);
        Composite composite2 = new Composite(uSashForm, 0);
        composite2.setLayout(new GridLayout(2, false));
        USashForm uSashForm2 = SwtFactory.createUSashForm(composite2, 256);
        gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        uSashForm2.setLayoutData(gridData);
        this.filesTableViewer_.createContents(uSashForm2);
        this.collectionOutlinePanel_.createContents(uSashForm2);
        uSashForm2.setWeights(new int[]{1, -currentContext.getInteger(BOARD_WIDTH)});
        uSashForm2.setDragMinimums(new int[]{5, BOARD_WIDTH.minInt()});
        this.createFilenameText(composite2);
        this.createFiletypeCombo(composite2);
        uSashForm.setWeights(new int[]{-currentContext.getInteger(FOLDER_WIDTH), 1});
        this.folderTreeViewer_.setRoot(currentContext.getAttribute(ROOT_DIR));
        if (lastFolder_s_ != null) {
            this.folderTreeViewer_.setSelected(lastFolder_s_);
            this.filesTableViewer_.setFolder(lastFolder_s_);
        }
        return this.frame_;
    }

    private void createFilenameText(Composite composite) {
        assert (composite != null);
        Label label = new Label(composite, 0);
        label.setText(CLB_FILENAME.get());
        label.setLayoutData(new GridData(131072, 128, false, false));
        this.txFilename_ = new Text(composite, 2048);
        this.txFilename_.setLayoutData(new GridData(4, 128, true, false));
        this.txFilename_.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ExplorerLikeFileChooser.this.updateFiles();
            }
        });
    }

    private void createFiletypeCombo(Composite composite) {
        assert (composite != null);
        Label label = new Label(composite, 0);
        label.setText(CLB_FILETYPE.get());
        label.setLayoutData(new GridData(131072, 128, false, false));
        this.coFilter_ = new Combo(composite, 8);
        this.coFilter_.setLayoutData(new GridData(4, 128, true, false));
        this.coFilter_.addSelectionListener(new CoFilterListener());
        this.updateFilter();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        if (this.style_.equals((Object)IgoFileChooser.Style.SAVE_FILE)) {
            this.createButton(composite, 1024, CLB_SAVE.get(), true);
        } else {
            this.createButton(composite, 1024, CLB_OPEN.get(), true);
        }
        this.createButton(composite, 1, LB_CANCEL.get(), false);
    }

    protected void buttonPressed(int n) {
        lastFolder_s_ = this.filesTableViewer_.getFolder();
        CurrentContext currentContext = Yukinoshita.context(null);
        Point point = this.frame_.getSize();
        currentContext.setInteger(DLG_WIDTH.id(), point.x);
        currentContext.setInteger(DLG_HEIGHT.id(), point.y);
        currentContext.setInteger(FOLDER_WIDTH.id(), this.folderTreeViewer_.getControl().getSize().x);
        currentContext.setInteger(BOARD_WIDTH.id(), this.collectionOutlinePanel_.getControl().getSize().x);
        File file = this.folderTreeViewer_.getRoot();
        if (file != null) {
            currentContext.setAttribute(ROOT_DIR, file);
        }
        this.setReturnCode(n);
        if (n == 1) {
            this.close();
            return;
        }
        this.updateFiles();
        this.close();
    }

    private void updateFiles() {
        File file = this.filesTableViewer_.getFolder();
        ArrayList<File> arrayList = new ArrayList<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.txFilename_.getText(), DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken().trim();
            if (string.length() == 0) continue;
            File file2 = new File(file, string);
            if (!this.style_.equals((Object)IgoFileChooser.Style.SAVE_FILE) && !Ios.isNormalFile(file2)) continue;
            arrayList.add(new File(file, string));
        }
        this.files_ = arrayList.toArray(new File[arrayList.size()]);
        int n = this.style_.equals((Object)IgoFileChooser.Style.SAVE_FILE) ? 1024 : 1024;
        this.getButton(n).setEnabled(this.files_.length != 0);
    }

    public boolean chooseFile() {
        CurrentContext currentContext = Yukinoshita.context(null);
        this.folderTreeViewer_.setIgnoreDrives(currentContext.getAttribute(IGNORE_DRIVES));
        return this.open() != 1 && this.files_.length != 0;
    }

    public File getFolder() {
        return this.filesTableViewer_.getFolder();
    }

    public File getFile() {
        return this.files_.length != 0 ? this.files_[0] : null;
    }

    public File[] getFiles() {
        if (this.getReturnCode() == 1) {
            return new File[0];
        }
        File[] fileArray = new File[this.files_.length];
        System.arraycopy(this.files_, 0, fileArray, 0, fileArray.length);
        return fileArray;
    }

    public void setFile(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        this.files_ = new File[1];
        this.files_[0] = file;
    }

    public void setFileName(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.txFilename_.setText(string);
    }

    public void setFolder(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!Ios.isNormalDirectory(file)) {
            log_s_.info("Invalid directory is assigned(ignore this): " + file);
            return;
        }
        this.folderTreeViewer_.setSelected(file);
        this.filesTableViewer_.setFolder(file);
    }

    public void setFilter(NamedFileFilter[] namedFileFilterArray) {
        this.fileFilters_ = new NamedFileFilter[namedFileFilterArray.length];
        System.arraycopy(namedFileFilterArray, 0, this.fileFilters_, 0, this.fileFilters_.length);
        if (this.coFilter_ != null) {
            this.updateFilter();
        }
    }

    private void updateFilter() {
        this.coFilter_.removeAll();
        for (NamedFileFilter namedFileFilter : this.fileFilters_) {
            this.coFilter_.add(namedFileFilter.displayName());
        }
        if (this.fileFilters_.length != 0) {
            this.coFilter_.select(0);
            this.filesTableViewer_.setFileFilter(this.fileFilters_[0]);
        }
    }

    public Shell getParent() {
        return null;
    }

    public IgoFileChooser.Style getStyle() {
        return this.style_;
    }

    public String getText() {
        return this.getShell().getText();
    }

    public void setText(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.getShell().setText(string);
    }

    static /* synthetic */ File[] access$802(ExplorerLikeFileChooser explorerLikeFileChooser, File[] fileArray) {
        explorerLikeFileChooser.files_ = fileArray;
        return fileArray;
    }

    static {
        File[] fileArray = SystemUtils.IS_OS_WINDOWS ? new File[]{new File("A:\\"), new File("B:\\")} : new File[]{};
        IGNORE_DRIVES = new ContextValue<File[]>(ExplorerLikeFileChooser.class, "ignoreDrives", fileArray);
        log_s_ = LogFactory.getLog(ExplorerLikeFileChooser.class);
        DLG_WIDTH = new IntContextValue(ExplorerLikeFileChooser.class, "dlgWidth", 200, 640, 1000);
        DLG_HEIGHT = new IntContextValue(ExplorerLikeFileChooser.class, "dlgHeight", 100, 400, 1000);
        FOLDER_WIDTH = new IntContextValue(ExplorerLikeFileChooser.class, "folderWidth", 100, 200, 1000);
        BOARD_WIDTH = new IntContextValue(ExplorerLikeFileChooser.class, "boardWidth", 100, 200, 1000);
        ROOT_DIR = new ContextValue<File>(ExplorerLikeFileChooser.class, "rootDir", new File(FilenameUtils.getPrefix(Ios.getCurrentDirectory().getAbsolutePath())));
        CLB_FILENAME = new Message(ExplorerLikeFileChooser.class, "clbFilename");
        CLB_FILETYPE = new Message(ExplorerLikeFileChooser.class, "clbFiletype");
        CLB_OPEN = new Message(ExplorerLikeFileChooser.class, "clbOpen");
        CLB_SAVE = new Message(ExplorerLikeFileChooser.class, "clbSave");
        LB_CANCEL = new Message(ExplorerLikeFileChooser.class, "lbCancel");
        lastFolder_s_ = null;
    }

    private class CoFilterListener
    extends SelectionAdapter {
        private CoFilterListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = ExplorerLikeFileChooser.this.coFilter_.getSelectionIndex();
            if (n != -1) {
                ExplorerLikeFileChooser.this.filesTableViewer_.setFileFilter(ExplorerLikeFileChooser.this.fileFilters_[n]);
            }
        }
    }

    private class FileListListener
    implements FileFolderListener {
        private FileListListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void filesFocused(File[] fileArray) {
            ArgumentChecker.throwIfNull((Object)fileArray);
            ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
            for (File file : fileArray) {
                if (!file.isFile() || !file.canRead() || file.isHidden()) continue;
                arrayList.add(file);
            }
            File[] fileArray2 = arrayList.toArray(new File[arrayList.size()]);
            try {
                ExplorerLikeFileChooser.this.frame_.setCursor(ExplorerLikeFileChooser.this.frame_.getDisplay().getSystemCursor(1));
                ExplorerLikeFileChooser.this.collectionOutlinePanel_.setFiles(fileArray2);
            }
            finally {
                ExplorerLikeFileChooser.this.frame_.setCursor(null);
            }
            switch (fileArray2.length) {
                case 0: {
                    ExplorerLikeFileChooser.this.txFilename_.setText("");
                    break;
                }
                case 1: {
                    ExplorerLikeFileChooser.this.txFilename_.setText(fileArray2[0].getName());
                    break;
                }
                default: {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (File file : fileArray2) {
                        stringBuilder.append(ExplorerLikeFileChooser.DELIMITER).append(file.getName()).append(ExplorerLikeFileChooser.DELIMITER).append(" ");
                    }
                    ExplorerLikeFileChooser.this.txFilename_.setText(stringBuilder.toString());
                }
            }
        }

        public void filesDoubleClicked(File file) {
            ArgumentChecker.throwIfNull((Object)file);
            ExplorerLikeFileChooser.access$802(ExplorerLikeFileChooser.this, new File[]{file});
            ExplorerLikeFileChooser.this.close();
        }

        public void folderChanged(File file) {
            ExplorerLikeFileChooser.this.folderTreeViewer_.setSelected(file);
        }
    }

    private class FolderTreeListener
    implements FolderListener {
        private FolderTreeListener() {
        }

        public void folderChanged(File file) {
            ExplorerLikeFileChooser.this.filesTableViewer_.setFolder(file);
        }
    }
}

