/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Strings;
import org.unitarou.lang.UEnum;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.yukinoshita.view.jface.gi.GiEmpty;
import org.unitarou.yukinoshita.view.jface.gi.GiEnum;
import org.unitarou.yukinoshita.view.jface.gi.GiFormula;
import org.unitarou.yukinoshita.view.jface.gi.GiLabelFormula;
import org.unitarou.yukinoshita.view.jface.gi.GiTextFormula;

public final class GiItem {
    private static final Log logger_s_ = LogFactory.getLog(GiItem.class);
    private static final Messages messages_s_ = Messages.createByPackage(GiItem.class);
    private String labelText_;
    private String expression_;
    private final Map<SgfId, String> emptyMap_;
    private final Map<SgfId, List<GiEnum>> enumMap_;
    private GiFormula[] giFormulae_;

    public static String convert(String string, Properties properties) {
        if (string.startsWith("%")) {
            String string2 = string.substring(1);
            String string3 = properties.getProperty(string2);
            if (string3 == null) {
                logger_s_.warn("Cannot find the key = " + string2);
                return "";
            }
            return string3;
        }
        return string;
    }

    public GiItem() {
        this.labelText_ = "";
        this.expression_ = "";
        this.emptyMap_ = new TreeMap<SgfId, String>();
        this.enumMap_ = new TreeMap<SgfId, List<GiEnum>>();
        this.giFormulae_ = new GiFormula[0];
    }

    public GiItem(String string, String string2) {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        this.emptyMap_ = new TreeMap<SgfId, String>();
        this.enumMap_ = new TreeMap<SgfId, List<GiEnum>>();
        this.giFormulae_ = new GiFormula[0];
        this.labelText_ = string;
        this.expression_ = string2;
    }

    public void setLabel(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.labelText_ = string;
    }

    public CharSequence getText() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.labelText_);
        for (GiFormula giFormula : this.giFormulae_) {
            stringBuilder.append(giFormula.getText());
        }
        return stringBuilder;
    }

    public void setExpression(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.expression_ = string;
    }

    public void addEmpty(GiEmpty giEmpty) {
        ArgumentChecker.throwIfNull((Object)giEmpty);
        this.emptyMap_.put(giEmpty.getSgfId(), giEmpty.getValue());
    }

    public void addEnum(GiEnum giEnum) {
        ArgumentChecker.throwIfNull((Object)giEnum);
        List<GiEnum> list = this.enumMap_.get(giEnum.getSgfId());
        if (list == null) {
            list = new ArrayList<GiEnum>();
            this.enumMap_.put(giEnum.getSgfId(), list);
        }
        list.add(giEnum);
    }

    public void setup() {
        ArrayList<GiFormula> arrayList = new ArrayList<GiFormula>();
        StringBuilder stringBuilder = new StringBuilder(this.expression_.length());
        int n = 65535;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.expression_);
        int n2 = stringCharacterIterator.first();
        while (n2 != 65535) {
            if (!Strings.isUppercaseRomanAlphabet((char)n2)) {
                if (n != 65535) {
                    stringBuilder.append((char)n);
                    n = 65535;
                }
                stringBuilder.append((char)n2);
            } else {
                StringBuilder stringBuilder2 = new StringBuilder(2);
                if (n != 65535) {
                    stringBuilder2.append((char)n);
                }
                stringBuilder2.append((char)n2);
                SgfId sgfId = UEnum.find(SgfId.class, stringBuilder2.toString());
                if (sgfId == null || !PropertyType.GAME_INFO.equals(sgfId.propertyType())) {
                    if (n != 65535) {
                        stringBuilder.append((char)n);
                    }
                    n = n2;
                } else {
                    List<GiEnum> list;
                    if (stringBuilder.length() != 0) {
                        arrayList.add(new GiLabelFormula(stringBuilder.toString()));
                        stringBuilder.delete(0, stringBuilder.length());
                    }
                    GiTextFormula giTextFormula = new GiTextFormula(sgfId);
                    String string = this.emptyMap_.get(sgfId);
                    if (string != null) {
                        giTextFormula.setEmpty(string);
                    }
                    if ((list = this.enumMap_.get(sgfId)) != null) {
                        for (GiEnum giEnum : list) {
                            String string2 = giEnum.getValue();
                            if (string2.startsWith("%")) {
                                String string3 = string2.substring(1);
                                string2 = messages_s_.get(string3);
                                giEnum.setValue(string2);
                            }
                            giTextFormula.addEnum(giEnum);
                        }
                    }
                    arrayList.add(giTextFormula);
                    n = 65535;
                }
            }
            n2 = stringCharacterIterator.next();
        }
        if (stringBuilder.length() != 0) {
            arrayList.add(new GiLabelFormula(stringBuilder.toString()));
        }
        this.giFormulae_ = arrayList.toArray(new GiFormula[arrayList.size()]);
    }

    public void currentChanged(Node node) {
        ArgumentChecker.throwIfNull((Object)node);
        for (int i = 0; i < this.giFormulae_.length; ++i) {
            this.giFormulae_[i].currentChanged(node);
        }
    }

    public void setLocalizedLabel(Properties properties) {
        ArgumentChecker.throwIfNull((Object)properties);
        this.labelText_ = GiItem.convert(this.labelText_, properties);
        for (int i = 0; i < this.giFormulae_.length; ++i) {
            this.giFormulae_[i].setLabel(properties);
        }
        for (SgfId sgfId : this.emptyMap_.keySet()) {
            String string = this.emptyMap_.get(sgfId);
            this.emptyMap_.put(sgfId, GiItem.convert(string, properties));
        }
    }
}

