/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Objects;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.GameChangeCommand;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.rgtlp.RootGameTreeLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameChooserPanel
implements YukinoshitaPanel {
    private static final Message LB_GAME = new Message(GameChooserPanel.class, "lbGame");
    private static final Message LB_EDIT = new Message(GameChooserPanel.class, "lbEdit");
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private CollectionProxy collectionProxy_ = null;
    private final ArrayList<Integer> indexList_ = new ArrayList();
    private Composite frame_;
    private Combo gameCombo_ = null;
    private Label label_ = null;
    private Button checkButton_ = null;
    private final Adapter adapter_ = new Adapter();

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        this.frame_.setLayout(gridLayout);
        Control control = this.createLabel(this.frame_);
        control.setLayoutData(new GridData(4, 1024, true, false));
        control = this.createCombo(this.frame_);
        control.setLayoutData(new GridData(4, 128, true, false));
        control = this.createEditCheckButton(this.frame_);
        control.setLayoutData(new GridData(4, 128, true, false));
        return this.frame_;
    }

    @Override
    public void close() {
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    private Control createLabel(Composite composite) {
        this.label_ = new Label(composite, 16384);
        this.label_.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent traverseEvent) {
                GameChooserPanel.this.gameCombo_.setFocus();
            }
        });
        return this.label_;
    }

    private Combo createCombo(Composite composite) {
        this.gameCombo_ = new Combo(composite, 12);
        this.gameCombo_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GameChooserPanel.this.fireGameChangeEvent();
            }
        });
        Swts.defeatMouseWheel(this.gameCombo_);
        this.gameCombo_.setVisibleItemCount(10);
        return this.gameCombo_;
    }

    private Control createEditCheckButton(Composite composite) {
        this.checkButton_ = SwtFactory.createCheckButton(composite, 0);
        this.checkButton_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GameChooserPanel.this.fireEditModeChageEvent(GameChooserPanel.this.checkButton_.getSelection());
            }
        });
        return this.checkButton_;
    }

    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_ = eventBroker;
        this.eventBroker_.addView(this);
    }

    private void fireGameChangeEvent() {
        GameChangeCommand gameChangeCommand = new GameChangeCommand(this.indexList_.get(this.gameCombo_.getSelectionIndex()));
        this.eventBroker_.executeCommand(gameChangeCommand);
    }

    private void fireEditModeChageEvent(boolean bl) {
        this.eventBroker_.executeCommand(new ChangeEditModeCommand(bl));
    }

    private int getComboItemIndex() {
        int n = this.collectionProxy_.getActiveIndex();
        int n2 = 0;
        for (int i = 0; i < this.indexList_.size(); ++i) {
            if (n != this.indexList_.get(i)) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements MouseWheelMonitor,
    EventBrokerMonitor,
    ControllerStatusMonitor,
    CollectionMonitor,
    GameMonitor,
    GameInfoNodeMonitor,
    NodeMonitor {
        private Adapter() {
        }

        @Override
        public boolean mouseWheelRolled(Point point, int n) {
            if (!Swts.isMouseOn(GameChooserPanel.this.gameCombo_)) {
                return false;
            }
            n = Objects.preventOverRange(n, -1, 1);
            int n2 = GameChooserPanel.this.gameCombo_.getSelectionIndex();
            if ((n2 = Objects.preventOverRange(n2 + n, 0, GameChooserPanel.this.gameCombo_.getItemCount() - 1)) != GameChooserPanel.this.gameCombo_.getSelectionIndex()) {
                GameChooserPanel.this.gameCombo_.select(n2);
                GameChooserPanel.this.fireGameChangeEvent();
            }
            return true;
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            GameChooserPanel.this.eventBroker_.removeView(GameChooserPanel.this);
            GameChooserPanel.this.eventBroker_ = eventBroker;
            GameChooserPanel.this.eventBroker_.addView(GameChooserPanel.this);
        }

        @Override
        public void setEditMode(boolean bl) {
            GameChooserPanel.this.checkButton_.setSelection(bl);
        }

        @Override
        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        @Override
        public void update(CollectionProxy collectionProxy) {
            ArgumentChecker.throwIfNull((Object)collectionProxy);
            GameChooserPanel.this.collectionProxy_ = collectionProxy;
            GameChooserPanel.this.indexList_.clear();
            GameChooserPanel.this.indexList_.ensureCapacity(GameChooserPanel.this.collectionProxy_.size());
            for (int i = 0; i < GameChooserPanel.this.collectionProxy_.size(); ++i) {
                GameChooserPanel.this.indexList_.add(i);
            }
            this.updateGameComboImpl();
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
            ArgumentChecker.throwIfNull(list);
            GameChooserPanel.this.indexList_.clear();
            GameChooserPanel.this.indexList_.ensureCapacity(list.size());
            GameChooserPanel.this.indexList_.addAll(list);
            this.updateGameComboImpl();
        }

        private void updateGameComboImpl() {
            RootGameTreeLabelProvider rootGameTreeLabelProvider = this.getLabelProvider();
            Collection collection = GameChooserPanel.this.collectionProxy_.getCollection();
            RootGameTree rootGameTree = collection.get(0);
            if (rootGameTree.getGameType() == GameType.DRILL) {
                this.updateGameComboInDrill(rootGameTreeLabelProvider, rootGameTree);
                return;
            }
            int n = GameChooserPanel.this.collectionProxy_.getActiveIndex();
            if (!GameChooserPanel.this.indexList_.contains(n)) {
                throw new IllegalStateException();
            }
            int n2 = 0;
            ArrayList<String> arrayList = new ArrayList<String>(GameChooserPanel.this.indexList_.size());
            for (Integer n3 : GameChooserPanel.this.indexList_) {
                int n4 = n3;
                if (n4 == n) {
                    n2 = arrayList.size();
                }
                arrayList.add(this.makeRgtLabel(rootGameTreeLabelProvider, n4, collection.get(n4)));
            }
            GameChooserPanel.this.gameCombo_.setEnabled(true);
            GameChooserPanel.this.checkButton_.setEnabled(true);
            GameChooserPanel.this.gameCombo_.setItems(arrayList.toArray(new String[arrayList.size()]));
            GameChooserPanel.this.gameCombo_.select(n2);
        }

        private void updateGameComboInDrill(RootGameTreeLabelProvider rootGameTreeLabelProvider, RootGameTree rootGameTree) {
            String[] stringArray = new String[GameChooserPanel.this.collectionProxy_.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = rootGameTreeLabelProvider.getLabel(rootGameTree);
            }
            GameChooserPanel.this.gameCombo_.setEnabled(false);
            String[] stringArray2 = BasicFinder.findData(rootGameTree.getSequence(), SgfId.INPUT_FILES);
            GameChooserPanel.this.checkButton_.setEnabled(stringArray2 != null && 0 < stringArray2.length);
            GameChooserPanel.this.gameCombo_.setItems(stringArray);
            if (0 < stringArray.length) {
                GameChooserPanel.this.gameCombo_.select(GameChooserPanel.this.collectionProxy_.getActiveIndex());
            }
        }

        @Override
        public void update(RgtProxy rgtProxy) {
            ArgumentChecker.throwIfNull((Object)rgtProxy);
            String string = rgtProxy.getGameType().displayName();
            GameChooserPanel.this.checkButton_.setText(LB_EDIT.get((Object)string));
            GameChooserPanel.this.label_.setText(LB_GAME.get((Object)string));
            int n = GameChooserPanel.this.collectionProxy_.getActiveIndex();
            int n2 = GameChooserPanel.this.getComboItemIndex();
            RootGameTree rootGameTree = rgtProxy.getRootGameTree();
            RootGameTreeLabelProvider rootGameTreeLabelProvider = this.getLabelProvider();
            GameChooserPanel.this.gameCombo_.setItem(n2, this.makeRgtLabel(rootGameTreeLabelProvider, n, rootGameTree));
            GameChooserPanel.this.gameCombo_.select(n2);
            GameChooserPanel.this.label_.getParent().layout(true, true);
        }

        @Override
        public void gameInfoChanged(NodeView nodeView) {
            RootGameTreeLabelProvider rootGameTreeLabelProvider = this.getLabelProvider();
            Collection collection = GameChooserPanel.this.collectionProxy_.getCollection();
            String[] stringArray = new String[collection.size()];
            if (collection.get(0).getGameType().equals(GameType.DRILL)) {
                if (GameChooserPanel.this.collectionProxy_.getActiveIndex() != 0) {
                    return;
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = rootGameTreeLabelProvider.getLabel(collection.get(0));
                }
                GameChooserPanel.this.gameCombo_.setEnabled(false);
            } else {
                int n = GameChooserPanel.this.collectionProxy_.getActiveIndex();
                int n2 = GameChooserPanel.this.getComboItemIndex();
                GameChooserPanel.this.gameCombo_.setItem(n2, this.makeRgtLabel(rootGameTreeLabelProvider, n, GameChooserPanel.this.collectionProxy_.getActive().getRootGameTree()));
            }
            if (0 < stringArray.length) {
                GameChooserPanel.this.gameCombo_.select(GameChooserPanel.this.collectionProxy_.getActiveIndex());
            }
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            Property property = nodeView.getProperty(SgfId.INPUT_FILES);
            GameChooserPanel.this.checkButton_.setEnabled(!nodeView.getRootView().getGameType().equals(GameType.DRILL) || property != null && property.getValues().length != 0);
        }

        private String makeRgtLabel(RootGameTreeLabelProvider rootGameTreeLabelProvider, int n, RootGameTree rootGameTree) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(n + 1).append(':');
            stringBuilder.append(rootGameTreeLabelProvider.getLabel(rootGameTree));
            return stringBuilder.toString();
        }

        private RootGameTreeLabelProvider getLabelProvider() {
            Collection collection = GameChooserPanel.this.collectionProxy_.getCollection();
            return Yukinoshita.context(collection).getProvider(RootGameTreeLabelProvider.class);
        }
    }
}

