/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.pa;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Set;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.unitarou.io.Ios;
import org.unitarou.jface.FontResource;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.util.filter.AbstractCollectionFilter;
import org.unitarou.sgf.util.filter.SieveBySgfIdFilter;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.board.DigestIgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.pa.Answer;
import org.unitarou.yukinoshita.view.jface.pa.AnswerCombo;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolveStatusPanel
implements YukinoshitaPanel {
    private static final ImageResource QUESTION = new ImageResource(SolveStatusPanel.class, "problem00.png");
    private static final ImageResource CORRECT = new ImageResource(SolveStatusPanel.class, "problem01.png");
    private static final ImageResource QUASI_CORRECT = new ImageResource(SolveStatusPanel.class, "problem02.png");
    private static final ImageResource WRONG = new ImageResource(SolveStatusPanel.class, "problem03.png");
    private static final Message LB_RESULT = new Message(SolveStatusPanel.class, "lbResult");
    private static final Message NT_SOLVE = new Message(SolveStatusPanel.class, "ntSolve");
    private static final Message NT_CONTINUE = new Message(SolveStatusPanel.class, "ntContinue");
    private static final Message NT_FINISH = new Message(SolveStatusPanel.class, "ntFinish");
    private static final FontResource FNT_MESSAGE = new FontResource(16, 1);
    private Reference<RootGameTree> regRgt_ = new WeakReference<Object>(null);
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private final Adapter adapter_ = new Adapter();
    private Composite frame_ = null;
    private StackLayout stackLayout_ = null;
    private Composite problemFrame_ = null;
    private Button insertDbButton_ = null;
    private Label imageLabel_ = null;
    private Label lbMessage_;
    private Composite answerFrame_ = null;
    private final AnswerCombo answerCombo_ = new AnswerCombo();
    private final DigestIgoBoardPanel answerBoardPanel_ = new DigestIgoBoardPanel(true, true);

    @Override
    public void close() {
        Ios.closeQuietly(this.answerBoardPanel_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = new Composite(composite, 0);
        this.stackLayout_ = new StackLayout();
        this.frame_.setLayout(this.stackLayout_);
        this.stackLayout_.topControl = this.getProblemFrame();
        return this.frame_;
    }

    private Composite getProblemFrame() {
        if (this.problemFrame_ != null) {
            return this.problemFrame_;
        }
        if (this.frame_ == null) {
            return null;
        }
        this.problemFrame_ = new Composite(this.frame_, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        this.problemFrame_.setLayout(gridLayout);
        this.insertDbButton_ = new Button(this.problemFrame_, 0x800020);
        this.insertDbButton_.setText(Context.SAVE_PROBLEM_RESULT.displayName());
        this.insertDbButton_.setSelection(Yukinoshita.context(null).getAttribute(Context.SAVE_PROBLEM_RESULT));
        GridData gridData = new GridData(4, 1024, true, false);
        this.insertDbButton_.setLayoutData(gridData);
        this.insertDbButton_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Yukinoshita.context(null).setAttribute(Context.SAVE_PROBLEM_RESULT, SolveStatusPanel.this.insertDbButton_.getSelection());
            }
        });
        this.imageLabel_ = new Label(this.problemFrame_, 0);
        this.imageLabel_.setImage(QUESTION.get());
        gridData = new GridData(0x1000000, 1024, true, true);
        this.imageLabel_.setLayoutData(gridData);
        this.lbMessage_ = new Label(this.problemFrame_, 0x1000000);
        this.lbMessage_.setFont(FNT_MESSAGE.get());
        this.lbMessage_.setText(NT_SOLVE.get());
        gridData = new GridData(4, 128, true, true);
        this.lbMessage_.setLayoutData(gridData);
        return this.problemFrame_;
    }

    private Composite getAnswerFrame() {
        if (this.answerFrame_ != null) {
            return this.answerFrame_;
        }
        if (this.frame_ == null) {
            return null;
        }
        this.answerFrame_ = new Composite(this.frame_, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        this.answerFrame_.setLayout(gridLayout);
        Label label = new Label(this.answerFrame_, 131072);
        label.setText(LB_RESULT.get());
        label.setLayoutData(new GridData(131072, 0x1000000, false, false));
        Control control = this.answerCombo_.createContents(this.answerFrame_);
        control.setLayoutData(new GridData(4, 0x1000000, true, false));
        Combo combo = this.answerCombo_.getCombo();
        combo.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                SolveStatusPanel.this.showAnswer();
            }
        });
        combo.setEnabled(true);
        control = this.answerBoardPanel_.createContents(this.answerFrame_);
        control.setLayoutData(new GridData(4, 4, true, true, 2, 1));
        return this.answerFrame_;
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    private void showAnswer() {
        Object object;
        Object object2;
        RootGameTree rootGameTree = new RootGameTree();
        Sequence sequence = rootGameTree.getSequence();
        GameTree gameTree = this.regRgt_.get();
        Answer answer = this.answerCombo_.getAnswer();
        if (answer == null) {
            object2 = gameTree.getSequence().iterator();
            while (object2.hasNext() && !((Node)(object = (Node)object2.next())).contains(PropertyType.MOVE)) {
                sequence.addLast((Node)object);
            }
        } else {
            object2 = answer.getTracks();
            int n = 0;
            while (gameTree != null) {
                sequence.addAll(gameTree.getSequence());
                GameTree[] gameTreeArray = gameTree.getChildren();
                if (gameTreeArray.length == 0 || ((Object)object2).length <= n) {
                    gameTree = null;
                    continue;
                }
                gameTree = gameTreeArray[(Integer)object2[n]];
                ++n;
            }
        }
        object2 = new SieveBySgfIdFilter(SgfId.WHITE, SgfId.BLACK, SgfId.ADD_BLACK, SgfId.ADD_WHITE, SgfId.ADD_EMPTY, SgfId.VIEW, SgfId.SIZE);
        object = new Collection();
        ((Collection)object).addLast(rootGameTree);
        object = ((AbstractCollectionFilter)object2).filter((Collection)object);
        this.answerBoardPanel_.updateImage(((Collection)object).get(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements EventBrokerMonitor,
    GameMonitor,
    ControllerStatusMonitor,
    ProblemStatusMonitor,
    ContextMonitor {
        private HandlerPhase currentPhase_ = HandlerPhase.SOLVE;
        private ProblemStatus currentStatus_;

        private Adapter() {
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            SolveStatusPanel.this.eventBroker_.removeView(SolveStatusPanel.this);
            SolveStatusPanel.this.eventBroker_ = eventBroker;
            SolveStatusPanel.this.eventBroker_.addView(SolveStatusPanel.this);
        }

        @Override
        public void update(RgtProxy rgtProxy) {
            ArgumentChecker.throwIfNull((Object)rgtProxy);
            SolveStatusPanel.this.regRgt_ = new WeakReference<RootGameTree>(rgtProxy.getRootGameTree());
        }

        @Override
        public void setEditMode(boolean bl) {
        }

        @Override
        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            this.currentPhase_ = handlerPhase;
            if (SolveStatusPanel.this.frame_ == null) {
                return;
            }
            if (handlerPhase.equals(HandlerPhase.SOLVE)) {
                this.updateStatusImpl(QUESTION);
                this.currentStatus_ = ProblemStatus.SOLVE;
                ((SolveStatusPanel)SolveStatusPanel.this).stackLayout_.topControl = SolveStatusPanel.this.getProblemFrame();
                SolveStatusPanel.this.frame_.layout();
            } else if (handlerPhase.equals(HandlerPhase.ANSWER)) {
                ((SolveStatusPanel)SolveStatusPanel.this).stackLayout_.topControl = SolveStatusPanel.this.getAnswerFrame();
                RootGameTree rootGameTree = (RootGameTree)SolveStatusPanel.this.regRgt_.get();
                if (rootGameTree != null) {
                    SolveStatusPanel.this.answerCombo_.update(rootGameTree);
                }
                SolveStatusPanel.this.answerCombo_.getCombo().select(0);
                SolveStatusPanel.this.answerCombo_.getCombo().forceFocus();
                SolveStatusPanel.this.showAnswer();
                SolveStatusPanel.this.frame_.layout();
            }
            this.updateMessage();
        }

        @Override
        public void update(ProblemStatus problemStatus) {
            ArgumentChecker.throwIfNull((Object)problemStatus);
            this.currentStatus_ = problemStatus;
            switch (problemStatus) {
                case SOLVE: {
                    this.updateStatusImpl(QUESTION);
                    break;
                }
                case CORRECT: {
                    this.updateStatusImpl(CORRECT);
                    break;
                }
                case ONE_STEP_SHORT: {
                    this.updateStatusImpl(QUASI_CORRECT);
                    break;
                }
                case MISTAKE: {
                    this.updateStatusImpl(WRONG);
                    break;
                }
            }
            this.updateMessage();
        }

        private void updateStatusImpl(ImageResource imageResource) {
            if (SolveStatusPanel.this.imageLabel_ != null) {
                SolveStatusPanel.this.imageLabel_.setImage(imageResource.get());
            }
        }

        private void updateMessage() {
            String string = "";
            if (HandlerPhase.SOLVE_END.equals(this.currentPhase_)) {
                string = NT_FINISH.get();
            } else if (HandlerPhase.SOLVE.equals(this.currentPhase_)) {
                switch (this.currentStatus_) {
                    case SOLVE: {
                        string = NT_SOLVE.get();
                        break;
                    }
                    case CORRECT: 
                    case ONE_STEP_SHORT: 
                    case MISTAKE: {
                        string = NT_CONTINUE.get();
                        break;
                    }
                    default: {
                        string = "";
                    }
                }
            }
            SolveStatusPanel.this.lbMessage_.setText(string);
            SolveStatusPanel.this.lbMessage_.getParent().layout();
        }

        @Override
        public void attributeChanged(Set<String> set) {
            if (SolveStatusPanel.this.insertDbButton_ == null) {
                return;
            }
            if (set.contains(Context.SAVE_PROBLEM_RESULT.id())) {
                SolveStatusPanel.this.insertDbButton_.setSelection(Yukinoshita.context(null).getAttribute(Context.SAVE_PROBLEM_RESULT));
            }
        }
    }
}

