/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.provider.nlp;

import org.unitarou.ml.Message;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.util.Situation;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.provider.nlp.Ver1NodeLabelProvider;

public class Ver2NodeLabelProvider
extends Ver1NodeLabelProvider {
    private static final Message LB_DISPLAY_NAME = new Message(Ver2NodeLabelProvider.class, "lbDisplayName");
    private static final Message LB_SITUATION_WIN = new Message(Ver2NodeLabelProvider.class, "lbSituationWin");
    private static final Message LB_SITUATION_DRAW = new Message(Ver2NodeLabelProvider.class, "lbSituationDraw");

    public String getLabel(NodeView nodeView) {
        StringBuilder stringBuilder = new StringBuilder(super.getLabel(nodeView));
        Situation situation = nodeView.getSituation();
        if (!situation.isEmpty()) {
            SgfColor sgfColor = situation.winner();
            if (sgfColor == null) {
                stringBuilder.append(LB_SITUATION_DRAW.get());
            } else {
                stringBuilder.append(LB_SITUATION_WIN.get(sgfColor.displayName(), situation.score()));
            }
        }
        return stringBuilder.toString();
    }

    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }
}

