/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.ResourceRegistry;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ColorRegistry
extends ResourceRegistry {
    protected Display display;
    private List staleColors = new ArrayList();
    private Map stringToColor = new HashMap(7);
    private Map stringToRGB = new HashMap(7);
    protected Runnable displayRunnable = new Runnable(){

        public void run() {
            ColorRegistry.this.clearCaches();
        }
    };

    public ColorRegistry() {
        this(Display.getCurrent(), true);
    }

    public ColorRegistry(Display display) {
        this(display, true);
    }

    public ColorRegistry(Display display, boolean cleanOnDisplayDisposal) {
        Assert.isNotNull(display);
        this.display = display;
        if (cleanOnDisplayDisposal) {
            this.hookDisplayDispose();
        }
    }

    private Color createColor(RGB rgb) {
        return new Color(this.display, rgb);
    }

    private void disposeColors(Iterator iterator) {
        while (iterator.hasNext()) {
            Object next = iterator.next();
            ((Color)next).dispose();
        }
    }

    public Color get(String symbolicName) {
        Assert.isNotNull(symbolicName);
        Object result = this.stringToColor.get(symbolicName);
        if (result != null) {
            return (Color)result;
        }
        Color color = null;
        result = this.stringToRGB.get(symbolicName);
        if (result == null) {
            return null;
        }
        color = this.createColor((RGB)result);
        this.stringToColor.put(symbolicName, color);
        return color;
    }

    public Set getKeySet() {
        return Collections.unmodifiableSet(this.stringToRGB.keySet());
    }

    public RGB getRGB(String symbolicName) {
        Assert.isNotNull(symbolicName);
        return (RGB)this.stringToRGB.get(symbolicName);
    }

    public ColorDescriptor getColorDescriptor(String symbolicName) {
        return ColorDescriptor.createFrom(this.getRGB(symbolicName));
    }

    protected void clearCaches() {
        this.disposeColors(this.stringToColor.values().iterator());
        this.disposeColors(this.staleColors.iterator());
        this.stringToColor.clear();
        this.staleColors.clear();
    }

    public boolean hasValueFor(String colorKey) {
        return this.stringToRGB.containsKey(colorKey);
    }

    private void hookDisplayDispose() {
        this.display.disposeExec(this.displayRunnable);
    }

    public void put(String symbolicName, RGB colorData) {
        this.put(symbolicName, colorData, true);
    }

    private void put(String symbolicName, RGB colorData, boolean update) {
        Assert.isNotNull(symbolicName);
        Assert.isNotNull(colorData);
        RGB existing = (RGB)this.stringToRGB.get(symbolicName);
        if (colorData.equals(existing)) {
            return;
        }
        Color oldColor = (Color)this.stringToColor.remove(symbolicName);
        this.stringToRGB.put(symbolicName, colorData);
        if (update) {
            this.fireMappingChanged(symbolicName, existing, colorData);
        }
        if (oldColor != null) {
            this.staleColors.add(oldColor);
        }
    }
}

