/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.io.FileSnapshot;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Exceptions;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.parser.CollectionEncodingException;
import org.unitarou.sgf.parser.SgfFormatter;
import org.unitarou.sgf.parser.SgfLog;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserOption;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.filter.BasicFilter;
import org.unitarou.util.FilterException;
import org.unitarou.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionRepository {
    private static final CollectionRepository instance_s_ = new CollectionRepository();
    private static final Log log_s_ = LogFactory.getLog(CollectionRepository.class);
    private static final Message NT_CANT_READ_FILE = new Message(CollectionRepository.class, "ntCantReadFile");
    private static final Message NT_BAD_TYPE_FOR_DRILL = new Message(SgfParser.class, "ntBadTypeForDrill");
    private static final Message NT_FILE_NOT_FOUND_IN_DRILL = new Message(SgfParser.class, "ntFileNotFoundInDrill");
    private static final Message NT_FILE_IS_NOT_PROBLEM = new Message(SgfParser.class, "ntFileIsNotProblem");
    private final Map<File, Reference<Collection>> fileCacheMap_ = new HashMap<File, Reference<Collection>>();
    private int mapPutCounter_ = 0;
    private final Random random_ = new Random();

    public static CollectionRepository instance() {
        return instance_s_;
    }

    private CollectionRepository() {
    }

    public Collection load(File file, boolean bl) {
        return this.load(file, EnumSet.noneOf(SgfParserOption.class), bl);
    }

    public Collection load(File file, EnumSet<SgfParserOption> enumSet, boolean bl) {
        ArgumentChecker.throwIfNull((Object)file, enumSet);
        StopWatch stopWatch = new StopWatch();
        try {
            Collection collection;
            Reference<Collection> reference = this.fileCacheMap_.get(file);
            Collection collection2 = collection = reference != null ? reference.get() : null;
            if (collection == null || !this.isSameContents(collection.getFileSnapshot(), file)) {
                SgfParser sgfParser = new SgfParser();
                sgfParser.setOptions(enumSet);
                Collection collection3 = sgfParser.parse(file);
                if (bl) {
                    this.cacheCollection(file, collection3);
                }
                log_s_.trace(stopWatch.stopSecond("Loaded ", file));
                return collection3;
            }
            log_s_.trace(stopWatch.stopSecond("Cache ", file));
            return new Collection(collection);
        }
        catch (SgfParserException sgfParserException) {
            SgfLog sgfLog = new SgfLog();
            sgfLog.info(0, NT_CANT_READ_FILE.get(file.getAbsoluteFile(), Exceptions.getRootMessage(sgfParserException)), "");
            log_s_.debug("Instracted unreadable file:" + file.getAbsolutePath(), sgfParserException);
            return new Collection();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.fileCacheMap_.clear();
            System.gc();
            throw outOfMemoryError;
        }
    }

    private void cacheCollection(File file, Collection collection) {
        this.fileCacheMap_.put(file, new SoftReference<Collection>(new Collection(collection)));
        ++this.mapPutCounter_;
        if (this.mapPutCounter_ % 50 != 49) {
            return;
        }
        int n = 0;
        Iterator<Map.Entry<File, Reference<Collection>>> iterator = this.fileCacheMap_.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<File, Reference<Collection>> entry = iterator.next();
            if (entry.getValue().get() != null) continue;
            iterator.remove();
            ++n;
        }
        if (n != 0) {
            log_s_.debug(n + " cache was lost by GC");
        }
    }

    private boolean isSameContents(FileSnapshot fileSnapshot, File file) {
        if (fileSnapshot == null || file == null) {
            return false;
        }
        return fileSnapshot.equals(new FileSnapshot(file));
    }

    public void loadProblem(Collection collection) {
        Object object;
        int n;
        RootGameTree rootGameTree;
        String[] stringArray;
        ArgumentChecker.throwIfNull((Object)collection);
        if (collection.size() < 1 || !collection.get(0).getGameType().equals(GameType.DRILL) || collection.getFile() == null) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        SgfLog sgfLog = collection.getParserLog();
        File file = collection.getFile();
        if (1 < collection.size()) {
            while (collection.size() < 1) {
                collection.remove(collection.size() - 1);
            }
            collection.setFile(null);
            sgfLog.warn(1, NT_BAD_TYPE_FOR_DRILL.get(), "");
        }
        stringArray = (stringArray = BasicFinder.findData((rootGameTree = collection.get(0)).getSequence(), SgfId.INPUT_FILES)) == null ? new String[]{} : stringArray;
        String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES);
        ProblemProperties problemProperties = ProblemProperties.parsePpQuietly(string);
        String[] stringArray2 = stringArray;
        int n2 = stringArray2.length;
        for (n = 0; n < n2; ++n) {
            object = stringArray2[n];
            object = Sgfs.unescapeIfForRead((String)object);
            File file2 = new File(file.getParent(), (String)object);
            if (!file2.exists() || !file2.isFile()) {
                sgfLog.warn(1, NT_FILE_NOT_FOUND_IN_DRILL.get(), file2.getPath());
                continue;
            }
            this.appendProblem(collection, file2, problemProperties);
        }
        if (problemProperties.contains(ProblemProperties.Flag.SHUFFLE)) {
            int n3 = collection.size() - 1;
            for (n2 = 1; n2 < n3; ++n2) {
                n = this.random_.nextInt(n3) + 1;
                object = collection.remove(n);
                collection.addLast((RootGameTree)object);
            }
        }
        log_s_.trace(stopWatch.stopSecond(""));
    }

    private void appendProblem(Collection collection, File file, ProblemProperties problemProperties) {
        Collection collection2 = this.load(file, true);
        SgfLog sgfLog = collection2.getParserLog();
        for (int i = 0; i < collection2.size(); ++i) {
            RootGameTree rootGameTree = collection2.get(i);
            if (!rootGameTree.getGameType().equals(GameType.PROBLEM)) {
                sgfLog.info(0, NT_FILE_IS_NOT_PROBLEM.get(), String.valueOf(i + 1));
                continue;
            }
            try {
                if (problemProperties.contains(ProblemProperties.Flag.MIRROR_ROTATE)) {
                    BasicFilter.mirrorRotate(rootGameTree, this.random_.nextInt(8));
                }
                collection.addLast(rootGameTree);
                continue;
            }
            catch (FilterException filterException) {
                filterException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Collection collection, File file, SgfFormatter sgfFormatter) throws IOException {
        FileOutputStream fileOutputStream = null;
        ByteBuffer byteBuffer = null;
        int n = -1;
        do {
            try {
                byteBuffer = sgfFormatter.format(collection);
                n = -1;
            }
            catch (CollectionEncodingException collectionEncodingException) {
                if (collectionEncodingException.getRgtIndex() <= n || collectionEncodingException.getNewCharset() == null) {
                    throw new CharacterCodingException();
                }
                n = collectionEncodingException.getRgtIndex();
                RootGameTree rootGameTree = collection.get(collectionEncodingException.getRgtIndex());
                rootGameTree.setCharset(new SgfCharset(collectionEncodingException.getNewCharset()));
            }
        } while (n != -1);
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.getChannel().write(byteBuffer);
            fileOutputStream.flush();
            this.fileCacheMap_.remove(file);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(fileOutputStream);
    }
}

