/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileFormat implements TypedString<FileFormat>,
NameDisplayable
{
    VERSION_1(1),
    VERSION_2(2),
    VERSION_3(3),
    VERSION_4(4);

    private static Log log_s_;
    private static final Pattern condition_s_;
    private static final int POS = 0;
    private final String string_;

    public static FileFormat parse(String string) throws TypeParseException {
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        String string2 = matcher.group(0);
        for (FileFormat fileFormat : FileFormat.values()) {
            if (!fileFormat.string_.equals(string2)) continue;
            return fileFormat;
        }
        log_s_.info("Unknown FileFormat: " + string2 + ". Use FF[4] instead");
        return VERSION_4;
    }

    private FileFormat(int n2) {
        this.string_ = String.valueOf(n2);
    }

    @Override
    public String getString() {
        return this.string_;
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return SgfId.FILE_FORMAT.equals(sgfId);
    }

    public String toString() {
        return this.displayName();
    }

    @Override
    public String displayName() {
        Messages messages = Messages.createByPackage(this.getClass());
        return messages.get(Messages.createKey(this.getClass(), this.string_));
    }

    static {
        log_s_ = LogFactory.getLog(FileFormat.class);
        condition_s_ = Pattern.compile("1|2|3|4");
    }
}

