/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.context;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Classes;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Message;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.CurrentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextValue<T>
implements NameDisplayable {
    private static final Log log_s_ = LogFactory.getLog(ContextValue.class);
    private final String id_;
    private final Class<?> clazz_;
    private final Message messageResource_;
    private final T defaultValue_;

    public ContextValue(Class<?> clazz, String string, T t) {
        this(clazz, string, t, t.getClass());
    }

    public ContextValue(Class<?> clazz, String string, T t, Class<?> clazz2) {
        ArgumentChecker.throwIfNull(clazz, (Object)string, t);
        this.clazz_ = clazz;
        this.messageResource_ = new Message(clazz, string);
        this.id_ = Classes.packageName(clazz) + '.' + this.messageResource_.getKey();
        this.defaultValue_ = t;
        Context context = Yukinoshita.context();
        CurrentContext currentContext = context.getCurrent(null);
        context.setDefault(this);
        Object object = currentContext.getAttribute(this.id_);
        if (object != null && !clazz2.isAssignableFrom(object.getClass())) {
            log_s_.warn("Root context value is bad type.  ID=" + this.id_ + ", value: " + this.defaultValue_.getClass() + " <> " + object.getClass());
            currentContext.setAttribute(this);
        }
    }

    public String id() {
        return this.id_;
    }

    public Class<?> getContextClass() {
        return this.clazz_;
    }

    public T defaultValue() {
        return this.defaultValue_;
    }

    @Override
    public String displayName() {
        return this.messageResource_.get();
    }
}

