/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.CollectionEvent;
import org.unitarou.sgf.CollectionListener;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.model.RgtProxy;

public class CollectionProxy {
    private static final Log logger_s_ = LogFactory.getLog(CollectionProxy.class);
    private final Collection collection_;
    private final CollectionListener listener_;
    private final List<RgtProxy> games_;
    private int activeRgtIndex_;
    private boolean isRgtEdited_;

    public CollectionProxy(Collection collection, boolean bl) {
        int n;
        ArgumentChecker.throwIfNull((Object)collection);
        this.collection_ = collection;
        this.listener_ = new CollectionListenerImpl();
        this.collection_.addListener(this.listener_);
        this.games_ = new ArrayList<RgtProxy>(this.collection_.size());
        for (n = 0; n < this.collection_.size(); ++n) {
            this.games_.add(null);
        }
        this.activeRgtIndex_ = 0;
        if (bl) {
            for (n = 0; n < this.collection_.size(); ++n) {
                this.initializeGame(n, true);
            }
        }
        this.isRgtEdited_ = false;
    }

    public void dispose() {
        this.games_.clear();
        this.collection_.removeListener(this.listener_);
        for (RootGameTree rootGameTree : this.collection_) {
            Yukinoshita.context(rootGameTree).clearCurrent();
        }
        Yukinoshita.context(this.collection_).clearCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.games_.isEmpty()) {
                logger_s_.warn(this + " is not disposed.");
                this.dispose();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setActive(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IllegalArgumentException("Parameter gameIndex is out of bounds. Game size is " + this.collection_.size() + ". Parameter gameIndex is " + n);
        }
        this.activeRgtIndex_ = n;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public int getActiveIndex() {
        return this.activeRgtIndex_;
    }

    public RgtProxy getActive() {
        return this.get(this.activeRgtIndex_);
    }

    private RgtProxy initializeGame(int n, boolean bl) {
        RootGameTree rootGameTree = this.collection_.get(n);
        RgtProxy rgtProxy = new RgtProxy(rootGameTree, bl);
        this.games_.set(n, rgtProxy);
        return rgtProxy;
    }

    public boolean isRgtEdited() {
        return this.isRgtEdited_;
    }

    public boolean[] getChangedFlags() {
        boolean[] blArray = new boolean[this.collection_.size()];
        for (int i = 0; i < blArray.length; ++i) {
            RgtProxy rgtProxy = this.games_.get(i);
            blArray[i] = rgtProxy != null && rgtProxy.isChanged();
        }
        return blArray;
    }

    public void clearChangedFlags() {
        for (RgtProxy rgtProxy : this.games_) {
            if (rgtProxy == null) continue;
            rgtProxy.clearChanged();
        }
        this.isRgtEdited_ = false;
    }

    public int size() {
        return this.collection_.size();
    }

    public RgtProxy createGame(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        this.collection_.addLast(rootGameTree);
        RgtProxy rgtProxy = this.initializeGame(this.collection_.size() - 1, true);
        return rgtProxy;
    }

    public boolean isDrill() {
        return this.get(0).getGameType().equals(GameType.DRILL);
    }

    private RgtProxy get(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IllegalArgumentException("Bad index:" + n);
        }
        RgtProxy rgtProxy = this.games_.get(n);
        if (rgtProxy == null) {
            rgtProxy = this.initializeGame(n, false);
        }
        return rgtProxy;
    }

    public void remove(int n) {
        if (n < 0 || this.collection_.size() <= n) {
            throw new IllegalArgumentException("Bad index:" + n);
        }
        this.collection_.remove(n);
        this.isRgtEdited_ = true;
    }

    public void swap(int n, int n2) {
        if (n < 0 || this.collection_.size() <= n || n2 < 0 || this.collection_.size() <= n2) {
            throw new IllegalArgumentException("Parameter is out of range. index1:" + n + ", index2:" + n2);
        }
        if (n == n2) {
            return;
        }
        this.collection_.swap(n, n2);
        RgtProxy rgtProxy = this.games_.get(n);
        this.games_.set(n, this.games_.get(n2));
        this.games_.set(n2, rgtProxy);
        if (this.activeRgtIndex_ == n) {
            this.activeRgtIndex_ = n2;
        } else if (this.activeRgtIndex_ == n2) {
            this.activeRgtIndex_ = n;
        }
        this.isRgtEdited_ = true;
    }

    private class CollectionListenerImpl
    implements CollectionListener {
        private CollectionListenerImpl() {
        }

        public void rootGameTreeAppended(CollectionEvent collectionEvent) {
            CollectionProxy.this.games_.add(null);
        }

        public void rootGameTreeRemoved(CollectionEvent collectionEvent) {
            RootGameTree rootGameTree = collectionEvent.getRootGameTree();
            for (int i = 0; i < CollectionProxy.this.games_.size(); ++i) {
                RgtProxy rgtProxy = (RgtProxy)CollectionProxy.this.games_.get(i);
                if (rgtProxy == null || rgtProxy.getRootGameTree() != rootGameTree) continue;
                CollectionProxy.this.games_.remove(i);
                break;
            }
            if (CollectionProxy.this.activeRgtIndex_ == CollectionProxy.this.collection_.size()) {
                CollectionProxy.this.activeRgtIndex_ = CollectionProxy.this.collection_.size() - 1;
            }
        }
    }
}

