/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sql.CheckerResult;
import org.unitarou.sql.CheckerResultType;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.db.Database;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.GameIndex;
import org.unitarou.yukinoshita.model.db.GameRecord;
import org.unitarou.yukinoshita.model.db.GameTerm;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.Score;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.model.db.TermFrequency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NullDatabase
implements Database {
    @Override
    public boolean deleteAllFileIndices() throws DatabaseException {
        return false;
    }

    NullDatabase() {
    }

    @Override
    public void setup() {
    }

    @Override
    public Exception getExceptionAtSetup() {
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public boolean updateDatabase() {
        return true;
    }

    @Override
    public CheckerResult selfCheck() {
        return new CheckerResult("", CheckerResultType.MATCH);
    }

    @Override
    public void create() throws DatabaseException {
    }

    @Override
    public Master selectMaster(RootGameTree rootGameTree) throws DatabaseException {
        return null;
    }

    @Override
    public Master insertMaster(RootGameTree rootGameTree) throws DatabaseException {
        return new Master(rootGameTree);
    }

    public FileIndex selectFileIndex(File file) throws DatabaseException {
        return null;
    }

    @Override
    public void refreshFileIndex(List<Collection> list) throws DatabaseException {
    }

    @Override
    public boolean deleteFileIndex(int n) throws DatabaseException {
        return false;
    }

    @Override
    public int deleteNotFoundFileIndex() throws DatabaseException {
        return 0;
    }

    @Override
    public Score insertScore(RootGameTree rootGameTree, ProblemStatus problemStatus, ProblemProperties problemProperties, int n) throws DatabaseException {
        ArgumentChecker.throwIfNull((Object)rootGameTree, (Object)problemStatus);
        GameType gameType = rootGameTree.getGameType();
        if (gameType != GameType.PROBLEM || problemStatus.getId() == 0) {
            throw new IllegalArgumentException();
        }
        return new Score(rootGameTree);
    }

    @Override
    public Score[] selectScores(RootGameTree rootGameTree) throws DatabaseException {
        return new Score[0];
    }

    @Override
    public List<SearchedFile> search(SearchFileCondition searchFileCondition) {
        return Collections.emptyList();
    }

    @Override
    public List<Term> search(GameIndex gameIndex) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public List<TermFrequency> searchTermFrequency(SgfId sgfId, GameType gameType) {
        return Collections.emptyList();
    }

    @Override
    public DatabaseStatistics selectStatistics() throws DatabaseException {
        return new DatabaseStatistics();
    }

    @Override
    public Master selectMaster(int n) throws DatabaseException {
        return null;
    }

    @Override
    public FileIndex selectFileIndex(int n) {
        return null;
    }

    @Override
    public List<GameTerm> selectGameTerm(GameType gameType, SgfId sgfId) throws DatabaseException {
        return Collections.emptyList();
    }

    @Override
    public List<GameRecord> selectGameScore(String string, String string2) {
        return Collections.emptyList();
    }
}

