/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.io.File;
import java.io.FilenameFilter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Server;
import org.hsqldb.ServerConfiguration;
import org.hsqldb.persist.HsqlProperties;
import org.unitarou.ml.Message;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.db.Database;
import org.unitarou.yukinoshita.model.db.DatabaseException;
import org.unitarou.yukinoshita.model.db.hsql.FileIndexTable;
import org.unitarou.yukinoshita.model.db.hsql.GameIndexTable;
import org.unitarou.yukinoshita.model.db.hsql.GameTermMapTable;
import org.unitarou.yukinoshita.model.db.hsql.HsqlDatabase;
import org.unitarou.yukinoshita.model.db.hsql.MasterTable;
import org.unitarou.yukinoshita.model.db.hsql.ScoreTable;
import org.unitarou.yukinoshita.model.db.hsql.TermTable;

class DbServerHandler {
    private static final Log log_s_ = LogFactory.getLog(DbServerHandler.class);
    private static final DbServerHandler instance_s_ = new DbServerHandler();
    private static final Message MSG_DB_ALREADY_USED = new Message(DbServerHandler.class, "msgDbAlreadyUsed");
    private static final String URL_LOCAL_PREFIX = "jdbc:hsqldb:file:";
    private static final String SERVER_FILE_PREFIX = "./db/yukinoshita";
    private boolean isStandalone_;
    private Server server_ = null;
    private String dbFileName_;
    private Exception exception_;
    private String connectionUrl_ = null;
    private Connection connection_ = null;

    static DbServerHandler instance() {
        return instance_s_;
    }

    private DbServerHandler() {
    }

    Connection setup(String string) {
        try {
            this.connectionUrl_ = string;
            this.setupImpl();
        }
        catch (SQLException sQLException) {
            this.handleSqlExceptionInSetup(sQLException, string);
        }
        return this.connection_;
    }

    private void setupImpl() throws SQLException {
        DbUtils.closeQuietly(this.connection_);
        this.connection_ = null;
        this.isStandalone_ = this.connectionUrl_.startsWith(URL_LOCAL_PREFIX);
        this.dbFileName_ = this.isStandalone_ ? this.connectionUrl_.substring(URL_LOCAL_PREFIX.length()) : SERVER_FILE_PREFIX;
        try {
            this.connection_ = DriverManager.getConnection(this.connectionUrl_);
            this.exception_ = null;
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != -80) {
                throw sQLException;
            }
            this.startServer();
            this.connection_ = DriverManager.getConnection(this.connectionUrl_);
            this.exception_ = null;
        }
    }

    private void startServer() {
        if (this.server_ != null) {
            this.server_.start();
            return;
        }
        this.server_ = new Server();
        HsqlProperties hsqlProperties = new HsqlProperties();
        hsqlProperties.setProperty("server.port", 9001);
        hsqlProperties.setProperty("server.no_system_exit", true);
        hsqlProperties.setProperty("server.database.0", "file:./db/yukinoshita;shutdown=true");
        hsqlProperties.setProperty("server.dbname.0", "yukinoshita");
        this.dbFileName_ = SERVER_FILE_PREFIX;
        ServerConfiguration.translateDefaultDatabaseProperty(hsqlProperties);
        ServerConfiguration.translateDefaultNoSystemExitProperty(hsqlProperties);
        this.server_.setProperties(hsqlProperties);
        this.server_.start();
    }

    private void handleSqlExceptionInSetup(SQLException sQLException, String string) {
        if (this.lostsScriptFile(sQLException)) {
            this.shutdownDb();
            this.rebuildDb();
        } else if (this.isDbBroken(sQLException)) {
            this.rebuildDb();
        } else if (this.isLocalDbOccupied(sQLException) || this.isServerDbOccupied(sQLException)) {
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.WARNING, Database.NT_CANT_START_DB.get(), MSG_DB_ALREADY_USED.get());
            this.exception_ = null;
            this.connection_ = null;
        } else if (this.isBadUrl(sQLException)) {
            this.exception_ = new DatabaseException(Database.MSG_BAD_CONNECTION_URL.get((Object)string), sQLException);
            this.connection_ = null;
        } else {
            this.exception_ = sQLException;
            this.connection_ = null;
        }
    }

    private void shutdownDb() {
        if (this.isStandalone_) {
            DatabaseManager.closeDatabases(-1);
            this.connection_ = null;
        } else if (this.server_ != null) {
            this.server_.signalCloseAllServerConnections();
            this.server_.shutdown();
            this.server_ = null;
            DatabaseManager.closeDatabases(-1);
            DatabaseManager.getTimer().shutDown();
            this.connection_ = null;
        }
    }

    private boolean lostsScriptFile(SQLException sQLException) {
        return "S1000".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -37;
    }

    private boolean isDbBroken(SQLException sQLException) {
        return "S1000".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -78;
    }

    private void rebuildDb() {
        Application application = Yukinoshita.application();
        boolean bl = application.openMessageDialog(Application.MessageLevel.CONFIRM, Database.NT_CANT_START_DB.get(), Database.MSG_REBUILD_DB.get());
        if (!bl) {
            application.openMessageDialog(Application.MessageLevel.INFORMATION, Database.NT_CANT_START_DB.get(), Database.MSG_DB_CANNOT_BE_USED.get());
            return;
        }
        try {
            this.deleteAllDbFiles();
            this.setupImpl();
            this.create();
        }
        catch (Exception exception) {
            this.exception_ = exception;
            this.connection_ = null;
        }
    }

    private boolean isLocalDbOccupied(SQLException sQLException) {
        return "08001".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -1;
    }

    private boolean isServerDbOccupied(SQLException sQLException) {
        return "08000".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -80;
    }

    private boolean isBadUrl(SQLException sQLException) {
        return "S1000".equals(sQLException.getSQLState()) && sQLException.getErrorCode() == -29 || sQLException.getSQLState() == null && sQLException.getErrorCode() == 0;
    }

    private void deleteAllDbFiles() {
        File[] fileArray;
        final File file = new File(this.dbFileName_);
        File file2 = file.getParentFile();
        for (File file3 : fileArray = file2.listFiles(new FilenameFilter(){

            public boolean accept(File file2, String string) {
                String string2 = FilenameUtils.getBaseName(string);
                return string2.equals(file.getName());
            }
        })) {
            if (!file3.delete()) continue;
            log_s_.info("DELETE: " + file3.getAbsolutePath());
        }
    }

    Exception getException() {
        return this.exception_;
    }

    void create() throws DatabaseException {
        if (this.connection_ == null) {
            return;
        }
        try {
            ScoreTable.instance().create(this.connection_);
            GameIndexTable.instance().create(this.connection_);
            FileIndexTable.instance().create(this.connection_);
            MasterTable.instance().create(this.connection_);
            TermTable.instance().create(this.connection_);
            GameTermMapTable.instance().create(this.connection_);
            ScoreTable.instance().addConstraint(this.connection_);
            GameIndexTable.instance().addConstraint(this.connection_);
            FileIndexTable.instance().addConstraint(this.connection_);
            MasterTable.instance().addConstraint(this.connection_);
            TermTable.instance().addConstraint(this.connection_);
            GameTermMapTable.instance().addConstraint(this.connection_);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.connection_ == null) {
            return;
        }
        try {
            if (!this.isStandalone_) {
                return;
            }
            QueryRunner queryRunner = new QueryRunner();
            CurrentContext currentContext = Yukinoshita.context(null);
            if (100 < currentContext.getInteger(HsqlDatabase.DELETE_RECORDS)) {
                queryRunner.update(this.connection_, "SHUTDOWN COMPACT");
                currentContext.setInteger(HsqlDatabase.DELETE_RECORDS.id(), 0);
                log_s_.info("SHUTDOWN COMPACT is executed.");
            } else {
                queryRunner.update(this.connection_, "SHUTDOWN");
            }
        }
        catch (SQLException sQLException) {
            log_s_.info("close failure in dispose(): " + sQLException.getLocalizedMessage());
        }
        finally {
            DbUtils.closeQuietly(this.connection_);
            this.connection_ = null;
        }
    }
}

