/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.db.hsql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sql.UQueryRunner;
import org.unitarou.yukinoshita.model.db.GameRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameRecordView {
    private static final String SQL = "select m.file_id, m.file_order, t.sgf_id, t.term, g.date, s.width, s.height, s.fingerprint from  (((select m.file_id, m.file_order from term t    inner join game_term_map m on m.term_id = t.term_id and t.sgf_id = 'PW' and t.term = ?   ) intersect    (select file_id, file_order from term t    inner join game_term_map m on m.term_id = t.term_id and t.sgf_id = 'PB' and t.term = ?   )  ) union (    (select m.file_id, m.file_order from term t    inner join game_term_map m on m.term_id = t.term_id and t.sgf_id = 'PB' and t.term = ?   ) intersect    (select file_id, file_order from term t     inner join game_term_map m on m.term_id = t.term_id and t.sgf_id = 'PW' and t.term = ?   ) )) h  inner join game_term_map m on m.file_id = h.file_id and m.file_order = h.file_order  inner join term t on t.term_id = m.term_id and t.sgf_id in ('RE', 'PB', 'PW', 'DT')  inner join game_index g on g.file_id = m.file_id and g.file_order = m.file_order and g.game_type = 1  inner join master s on g.master_id = s.master_id ";

    static List<GameRecord> select(Connection connection, String string, String string2) throws SQLException {
        ArgumentChecker.throwIfNull((Object)string, (Object)string2);
        UQueryRunner uQueryRunner = new UQueryRunner();
        List<SqlBean> list = uQueryRunner.query(connection, SQL, SqlBean.class, string, string2, string, string2);
        HashMap<String, GameRecord> hashMap = new HashMap<String, GameRecord>();
        for (SqlBean sqlBean : list) {
            SgfId sgfId;
            GameRecord gameRecord = (GameRecord)hashMap.get(sqlBean.getGamePkString());
            if (gameRecord == null) {
                gameRecord = new GameRecord();
                gameRecord.setFileId(sqlBean.getFileId());
                gameRecord.setFileOrder(sqlBean.getFileOrder());
                gameRecord.setDate(sqlBean.getDate());
                gameRecord.setWidth(sqlBean.getWidth());
                gameRecord.setHeight(sqlBean.getHeight());
                gameRecord.setFingerprint(sqlBean.getFingerprint());
                gameRecord.setGameType(GameType.GAME.getIntValue());
                hashMap.put(sqlBean.getGamePkString(), gameRecord);
            }
            if (SgfId.PLAYER_BLACK.equals(sgfId = SgfId.find(sqlBean.getSgfId()))) {
                gameRecord.setPlayerBlack(sqlBean.getTerm());
                continue;
            }
            if (SgfId.PLAYER_WHITE.equals(sgfId)) {
                gameRecord.setPlayerWhite(sqlBean.getTerm());
                continue;
            }
            if (SgfId.RESULT.equals(sgfId)) {
                gameRecord.setResult(sqlBean.getTerm());
                continue;
            }
            if (!SgfId.DATE.equals(sgfId)) continue;
            gameRecord.setDate(sqlBean.getTerm());
        }
        ArrayList arrayList = new ArrayList(hashMap.values());
        Collections.sort(arrayList, new Comparator<GameRecord>(){

            @Override
            public int compare(GameRecord gameRecord, GameRecord gameRecord2) {
                return Objects.compateIncludeNull(gameRecord.getDate(), gameRecord2.getDate());
            }
        });
        return arrayList;
    }

    public static class SqlBean {
        private int fileId_;
        private int fileOrder_;
        private String sgfId_;
        private String term_;
        private String date_;
        private int width_;
        private int height_;
        private byte[] fingerprint_;

        public String getDate() {
            return this.date_;
        }

        public void setDate(String string) {
            this.date_ = string;
        }

        public int getFileId() {
            return this.fileId_;
        }

        public void setFileId(int n) {
            this.fileId_ = n;
        }

        public int getFileOrder() {
            return this.fileOrder_;
        }

        public void setFileOrder(int n) {
            this.fileOrder_ = n;
        }

        public byte[] getFingerprint() {
            return this.fingerprint_;
        }

        public void setFingerprint(byte[] byArray) {
            this.fingerprint_ = byArray;
        }

        public int getHeight() {
            return this.height_;
        }

        public void setHeight(int n) {
            this.height_ = n;
        }

        public String getSgfId() {
            return this.sgfId_;
        }

        public void setSgfId(String string) {
            this.sgfId_ = string;
        }

        public String getTerm() {
            return this.term_;
        }

        public void setTerm(String string) {
            this.term_ = string;
        }

        public int getWidth() {
            return this.width_;
        }

        public void setWidth(int n) {
            this.width_ = n;
        }

        public String getGamePkString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.fileId_).append('_').append(this.fileOrder_);
            return stringBuilder.toString();
        }
    }
}

