/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.cmd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.StopWatch;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.ProblemStatus;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.ViewCommand;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.CommandDriverMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeListMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.monitor.ProblemStatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractViewCommand
implements ViewCommand {
    private static final Log log_s_ = LogFactory.getLog(AbstractViewCommand.class);
    private final ParameterImpl parameter_ = new ParameterImpl();

    @Override
    public final ViewCommand.Parameter getParameter() {
        return this.parameter_;
    }

    protected final CollectionProxy getCollectionProxy() {
        return this.parameter_.collectionController_.getCollectionProxy();
    }

    protected final EventBroker getEventBroker() {
        return this.parameter_.collectionController_.getEventBroker();
    }

    protected final RgtProxy getActiveRgtProxy() {
        CollectionProxy collectionProxy = this.parameter_.collectionController_.getCollectionProxy();
        return collectionProxy.getActive();
    }

    protected final <T> List<T> getListeners(Class<T> clazz) {
        return this.getEventBroker().getListeners(clazz);
    }

    protected final Boolean isEditMode() {
        return this.parameter_.isEditMode_;
    }

    protected final void fireCollectionMonitorUpdate() {
        this.throwIfNotSetup();
        CollectionProxy collectionProxy = this.parameter_.collectionController_.getCollectionProxy();
        EventBroker eventBroker = this.getEventBroker();
        GameType gameType = collectionProxy.getActive().getGameType();
        eventBroker.connect(gameType, this.parameter_.isEditMode_);
        for (CollectionMonitor collectionMonitor : this.getListeners(CollectionMonitor.class)) {
            collectionMonitor.update(collectionProxy);
        }
    }

    protected final void fireGameViewerUpdate() {
        this.throwIfNotSetup();
        CollectionProxy collectionProxy = this.parameter_.collectionController_.getCollectionProxy();
        ViewerUtils.setupDriiRootDirectory(collectionProxy.getCollection());
        RgtProxy rgtProxy = collectionProxy.getActive();
        for (GameMonitor gameMonitor : this.getListeners(GameMonitor.class)) {
            gameMonitor.update(rgtProxy);
        }
    }

    protected final void fireGameInfoNodeUpdate() {
        this.throwIfNotSetup();
        RgtProxy rgtProxy = this.getActiveRgtProxy();
        int n = rgtProxy.findNodeView(PropertyType.GAME_INFO);
        if (n < 0) {
            n = 0;
        }
        NodeView nodeView = rgtProxy.getNodeList().getNodeView(n);
        this.fireGameInfoNodeUpdate(nodeView);
    }

    protected final void fireGameInfoNodeUpdate(NodeView nodeView) {
        this.throwIfNotSetup();
        for (GameInfoNodeMonitor gameInfoNodeMonitor : this.getListeners(GameInfoNodeMonitor.class)) {
            gameInfoNodeMonitor.gameInfoChanged(nodeView);
        }
    }

    protected final void fireNodeListUpdate() {
        this.throwIfNotSetup();
        RgtProxy rgtProxy = this.getActiveRgtProxy();
        NodeList nodeList = rgtProxy.getNodeList();
        int n = rgtProxy.getCurrentNodeIndex();
        int n2 = nodeList.size();
        int n3 = 0;
        NodeView[] nodeViewArray = new NodeView[n2 - n];
        for (int i = n; i < n2; ++i) {
            nodeViewArray[n3] = nodeList.getNodeView(i);
            ++n3;
        }
        for (NodeListMonitor nodeListMonitor : this.getListeners(NodeListMonitor.class)) {
            nodeListMonitor.update(nodeViewArray);
        }
    }

    protected final void fireNodeViewerUpdate() {
        this.fireNodeViewerUpdate(0);
    }

    protected final void fireNodeViewerUpdate(int n) {
        this.throwIfNotSetup();
        StopWatch stopWatch = new StopWatch();
        RgtProxy rgtProxy = this.getActiveRgtProxy();
        int n2 = rgtProxy.getCurrentNodeIndex() + n;
        if (n2 < 0 || rgtProxy.getNodeList().size() <= n2) {
            n2 = rgtProxy.getCurrentNodeIndex();
            log_s_.warn("Bad index, index=" + n2 + ", delta=" + n);
        }
        NodeView nodeView = rgtProxy.getNodeList().getNodeView(n2);
        for (NodeMonitor nodeMonitor : this.getListeners(NodeMonitor.class)) {
            nodeMonitor.currentChanged(nodeView);
            if (!log_s_.isTraceEnabled()) continue;
            log_s_.trace(stopWatch.lapSecond() + " secs for " + nodeMonitor);
        }
        if (log_s_.isTraceEnabled()) {
            log_s_.trace(stopWatch.stopSecond() + " secs for fireNodeViewerUpdate");
        }
    }

    protected final void fireHandlerPhaseChange(HandlerPhase handlerPhase) {
        ArgumentChecker.throwIfNull((Object)handlerPhase);
        if (handlerPhase.equals(HandlerPhase.SOLVE)) {
            RgtProxy rgtProxy = this.getActiveRgtProxy();
            Set<String> object = rgtProxy.startSolvingProblem();
            this.fireNodeViewerUpdate();
            Yukinoshita.context().fireAttributeChanged(object);
        }
        for (ControllerStatusMonitor controllerStatusMonitor : this.getListeners(ControllerStatusMonitor.class)) {
            controllerStatusMonitor.changeHandlerPhase(handlerPhase);
        }
    }

    protected final void fireProblemStatusUpdate(ProblemStatus problemStatus) {
        ArgumentChecker.throwIfNull((Object)problemStatus);
        for (ProblemStatusMonitor problemStatusMonitor : this.getListeners(ProblemStatusMonitor.class)) {
            problemStatusMonitor.update(problemStatus);
        }
    }

    protected void fireCommandDriverExecuted(CommandDriver.Status status) {
        ArgumentChecker.throwIfNull((Object)status);
        for (CommandDriverMonitor commandDriverMonitor : this.getListeners(CommandDriverMonitor.class)) {
            commandDriverMonitor.commandExecuted(status);
        }
    }

    protected final void throwIfNotSetup() {
        if (this.parameter_.collectionController_ == null || this.parameter_.isEditMode_ == null) {
            throw new IllegalStateException("Bad state, CollectionProxy and EventBroker must be set before method invocationcollectionController_=" + this.parameter_.collectionController_ + ", isEditMode_=" + this.parameter_.isEditMode_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterImpl
    implements ViewCommand.Parameter {
        private CollectionController collectionController_;
        private Boolean isEditMode_;
        private HandlerPhase currentStatus_;
        private final List<Integer> indexFilter_ = new ArrayList<Integer>();

        private ParameterImpl() {
        }

        @Override
        public CollectionController getCollectionController() {
            return this.collectionController_;
        }

        @Override
        public Boolean isEditMode() {
            return this.isEditMode_;
        }

        @Override
        public HandlerPhase getCurrentStatus() {
            return this.currentStatus_;
        }

        @Override
        public List<Integer> getIndexFilter() {
            return Collections.unmodifiableList(this.indexFilter_);
        }

        @Override
        public void set(CollectionController collectionController) {
            ArgumentChecker.throwIfNull((Object)collectionController);
            this.collectionController_ = collectionController;
        }

        @Override
        public void setEditMode(boolean bl) {
            this.isEditMode_ = bl;
        }

        @Override
        public void setCurrentStatus(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            this.currentStatus_ = handlerPhase;
        }

        @Override
        public void setIndexFilter(List<Integer> list) {
            ArgumentChecker.throwIfNull(list);
            this.indexFilter_.clear();
            this.indexFilter_.addAll(list);
        }
    }
}

