/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.type.GameType;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeGameCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractRootGameTreeAction
extends AbstractAction
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(AbstractRootGameTreeAction.class);
    private Reference<CollectionController> refGfc_ = new WeakReference<Object>(null);
    private final Adapter adapter_ = new Adapter();

    public AbstractRootGameTreeAction(WindowController windowController) {
        super(windowController);
        windowController.addListener(this.adapter_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    protected final CollectionController getGameFrameController() {
        return this.refGfc_.get();
    }

    protected EnumSet<SelectTargetFileDialog.Type> getTypes() {
        EnumSet<SelectTargetFileDialog.Type> enumSet = EnumSet.of(SelectTargetFileDialog.Type.PERMITS_NEW_FILE);
        CollectionController collectionController = this.getGameFrameController();
        if (collectionController == null) {
            return enumSet;
        }
        GameType gameType = collectionController.getCollectionProxy().getActive().getGameType();
        switch (gameType) {
            case GAME: {
                enumSet.add(SelectTargetFileDialog.Type.PERMITS_GAME);
                return enumSet;
            }
            case PROBLEM: {
                enumSet.add(SelectTargetFileDialog.Type.PERMITS_PROBLEM);
                return enumSet;
            }
        }
        log_s_.warn("Unsupported game type (Maybe BUG). TYPE:" + gameType.name());
        return EnumSet.noneOf(SelectTargetFileDialog.Type.class);
    }

    protected boolean isRunnable(CollectionController collectionController) {
        if (collectionController == null || !collectionController.isEditMode()) {
            return false;
        }
        Collection collection = collectionController.getCollection();
        if (collection.size() < 2) {
            return false;
        }
        return !GameType.DRILL.equals(collection.get(0).getGameType());
    }

    protected void notifyCollectionViewer(CollectionController collectionController) {
        CollectionProxy collectionProxy = collectionController.getCollectionProxy();
        for (CollectionMonitor collectionMonitor : collectionController.getEventBroker().getListeners(CollectionMonitor.class)) {
            collectionMonitor.update(collectionProxy);
        }
    }

    protected void changeForLastGame(CollectionController collectionController) {
        ChangeGameCommand changeGameCommand = new ChangeGameCommand(collectionController.getCollectionProxy().size() - 1);
        collectionController.getEventBroker().executeCommand(changeGameCommand);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements WindowControllerListener,
    ControllerStatusMonitor,
    CollectionMonitor,
    GameMonitor {
        private Adapter() {
        }

        @Override
        public void changeActive(CollectionController collectionController) {
            CollectionController collectionController2 = (CollectionController)AbstractRootGameTreeAction.this.refGfc_.get();
            if (collectionController2 != null) {
                collectionController2.getEventBroker().removeView(AbstractRootGameTreeAction.this);
            }
            if (collectionController != null) {
                collectionController.getEventBroker().addView(AbstractRootGameTreeAction.this);
            }
            AbstractRootGameTreeAction.this.refGfc_ = new WeakReference<CollectionController>(collectionController);
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(collectionController));
        }

        @Override
        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }

        @Override
        public void setEditMode(boolean bl) {
            CollectionController collectionController = (CollectionController)AbstractRootGameTreeAction.this.refGfc_.get();
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(collectionController));
        }

        @Override
        public void update(CollectionProxy collectionProxy) {
            CollectionController collectionController = (CollectionController)AbstractRootGameTreeAction.this.refGfc_.get();
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(collectionController));
        }

        @Override
        public void changeIndexFilter(List<Integer> list) {
        }

        @Override
        public void update(RgtProxy rgtProxy) {
            CollectionController collectionController = (CollectionController)AbstractRootGameTreeAction.this.refGfc_.get();
            AbstractRootGameTreeAction.this.setEnabled(AbstractRootGameTreeAction.this.isRunnable(collectionController));
        }
    }
}

