/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitarou.sgf.type.GameType;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.AbstractRootGameTreeAction;

public class DownRootGameTreeAction
extends AbstractRootGameTreeAction {
    private static final Log log_s_ = LogFactory.getLog(DownRootGameTreeAction.class);

    public DownRootGameTreeAction(WindowController windowController) {
        super(windowController);
    }

    public void run() {
        CollectionController collectionController = this.controller_.getActive();
        CollectionProxy collectionProxy = collectionController.getCollectionProxy();
        int n = collectionProxy.getActiveIndex();
        if (n == collectionProxy.size() + 1) {
            log_s_.warn("Can't swap because of max index, ignore this action.");
            return;
        }
        collectionProxy.swap(n, n + 1);
        collectionProxy.setActive(n + 1);
        this.notifyCollectionViewer(collectionController);
    }

    protected boolean isRunnable(CollectionController collectionController) {
        if (collectionController == null || !collectionController.isEditMode()) {
            return false;
        }
        CollectionProxy collectionProxy = collectionController.getCollectionProxy();
        if (collectionProxy.size() == 1 || collectionProxy.getActiveIndex() == collectionProxy.size() - 1) {
            return false;
        }
        return !GameType.DRILL.equals(collectionProxy.getCollection().get(0).getGameType());
    }
}

