/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.unitarou.jface.UTitleAreaDialog;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.type.SgfApplication;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.RootGameTreeFactory;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeGameCommand;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;
import org.unitarou.yukinoshita.view.monitor.CollectionMonitor;

public class NewProblemFileAction
extends Action {
    private static final Message NT_DLG_TITLE = new Message(NewProblemFileAction.class, "ntDlgTitle");
    private static final Message MSG_INSTRACTION = new Message(NewProblemFileAction.class, "msgInstraction");
    private static final Message CLB_NAME = new Message(NewProblemFileAction.class, "clbName");
    private final SgfSize sgfSize_;
    private final SgfColor playerToPlay_;
    private WindowController controller_;

    public static void execute(WindowController windowController, RootGameTree rootGameTree) {
        Object object;
        rootGameTree.setApplication(SgfApplication.create("Yukinoshita", "2.2.4"));
        CollectionController collectionController = null;
        if (windowController.getGameFrameControllers().length != 0) {
            object = new SelectTargetFileDialog(Display.getCurrent().getActiveShell(), EnumSet.of(SelectTargetFileDialog.Type.PERMITS_NEW_FILE, SelectTargetFileDialog.Type.PERMITS_PROBLEM));
            ((UTitleAreaDialog)object).setShellTitle(NT_DLG_TITLE.get());
            ((UTitleAreaDialog)object).setTitle(MSG_INSTRACTION.get());
            int n = ((Window)object).open();
            if (n == 1) {
                return;
            }
            collectionController = ((SelectTargetFileDialog)object).getTarget();
        }
        if (collectionController == null) {
            object = new Collection();
            ((Collection)object).addLast(rootGameTree);
            windowController.register((Collection)object, BasicMessages.LB_NEW_FILE.get(), false, 0);
            EventBroker eventBroker = windowController.getActive().getEventBroker();
            eventBroker.executeCommand(new ChangeEditModeCommand(true));
            eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SETUP));
            return;
        }
        object = collectionController.getCollectionProxy();
        ((CollectionProxy)object).createGame(rootGameTree);
        for (CollectionMonitor collectionMonitor : collectionController.getEventBroker().getListeners(CollectionMonitor.class)) {
            collectionMonitor.update((CollectionProxy)object);
        }
        EventBroker eventBroker = collectionController.getEventBroker();
        eventBroker.executeCommand(new ChangeGameCommand(((CollectionProxy)object).size() - 1));
        eventBroker.executeCommand(new ChangeEditModeCommand(true));
        eventBroker.executeCommand(new ChangeHandlerPhaseCommand(HandlerPhase.SETUP));
    }

    public NewProblemFileAction(SgfSize sgfSize, SgfColor sgfColor) {
        ArgumentChecker.throwIfNull((Object)sgfSize, (Object)sgfColor);
        this.sgfSize_ = sgfSize;
        this.playerToPlay_ = sgfColor;
        this.controller_ = null;
        this.setText(CLB_NAME.get((Object)this.playerToPlay_.displayName()));
    }

    public NewProblemFileAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        this.controller_ = windowController;
        return this;
    }

    public void run() {
        RootGameTree rootGameTree = RootGameTreeFactory.createProblem(this.sgfSize_, this.playerToPlay_);
        NewProblemFileAction.execute(this.controller_, rootGameTree);
    }
}

