/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.RemoveCurrentNode;
import org.unitarou.yukinoshita.model.cmd.RemoveLastNode;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.nlp.NodeViewLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveNodeAction
extends Action
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(RemoveNodeAction.class);
    private static final Message CLB_NAME = new Message(RemoveNodeAction.class, "clbName");
    private final Adapter adapter_ = new Adapter();
    private WindowController controller_ = null;

    public RemoveNodeAction() {
        this.setCommandName("");
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    private void setCommandName(String string) {
        String string2 = string.trim();
        if (string2.length() != 0) {
            string2 = '(' + string2 + ')';
        }
        this.setText(CLB_NAME.get((Object)string2));
    }

    public RemoveNodeAction setController(WindowController windowController) {
        ArgumentChecker.throwIfNull((Object)windowController);
        if (this.controller_ != null) {
            this.controller_.removeListener(this.adapter_);
        }
        this.controller_ = windowController;
        this.controller_.addListener(this.adapter_);
        return this;
    }

    @Override
    public void run() {
        CollectionController collectionController = this.controller_.getActive();
        NodeList nodeList = collectionController.getCollectionProxy().getActive().getNodeList();
        if (nodeList.getLastNodeView() == nodeList.getCurrentNodeView()) {
            collectionController.getEventBroker().executeCommand(new RemoveLastNode());
        } else {
            collectionController.getEventBroker().executeCommand(new RemoveCurrentNode());
        }
    }

    private class Adapter
    implements ControllerStatusMonitor,
    NodeMonitor,
    WindowControllerListener {
        private Reference<CollectionController> refGfc_ = new WeakReference<Object>(null);

        private Adapter() {
        }

        public void currentChanged(NodeView nodeView) {
            CollectionController collectionController = this.refGfc_.get();
            if (collectionController == null) {
                log_s_.warn("Lost CollectionController (BUG)");
                return;
            }
            ArgumentChecker.throwIfNull((Object)nodeView);
            RemoveNodeAction.this.setCommandName(NodeViewLabelProvider.CONTEXT.defaultValue().getLabel(nodeView));
            RemoveNodeAction.this.setEnabled(this.isValidState(collectionController));
        }

        public void changeActive(CollectionController collectionController) {
            CollectionController collectionController2 = this.refGfc_.get();
            if (collectionController2 != null) {
                collectionController2.getEventBroker().removeView(RemoveNodeAction.this);
            }
            this.refGfc_ = new WeakReference<CollectionController>(collectionController);
            CollectionController collectionController3 = this.refGfc_.get();
            if (collectionController3 != null) {
                collectionController.getEventBroker().addView(RemoveNodeAction.this);
            }
            if (!this.isValidState(collectionController3)) {
                RemoveNodeAction.this.setEnabled(false);
                RemoveNodeAction.this.setCommandName("");
                return;
            }
            RemoveNodeAction.this.setEnabled(true);
        }

        private boolean isValidState(CollectionController collectionController) {
            if (collectionController == null) {
                return false;
            }
            NodeList nodeList = collectionController.getCollectionProxy().getActive().getNodeList();
            if (nodeList.size() <= 1) {
                return false;
            }
            if (nodeList.getCurrentNodeView() == nodeList.getNodeView(0)) {
                return false;
            }
            return collectionController.isEditMode();
        }

        public void setEditMode(boolean bl) {
            RemoveNodeAction.this.setEnabled(bl);
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

