/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.util.EnumSet;
import org.eclipse.swt.widgets.Display;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.model.CollectionProxy;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeEditModeCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractRootGameTreeAction;
import org.unitarou.yukinoshita.view.jface.dlg.RootGameTreeChooser;
import org.unitarou.yukinoshita.view.jface.dlg.SelectTargetFileDialog;

public class SalvageFromTrashCanAction
extends AbstractRootGameTreeAction {
    private static final Message NT_SALVAGE_DLG_TITLE = new Message(SalvageFromTrashCanAction.class, "ntSalvageDlgTitle");
    private static final Message MSG_SALVAGE_INSTRACTION = new Message(SalvageFromTrashCanAction.class, "msgSalvageInstraction");
    private static final Message NT_MOVE_DLG_TITLE = new Message(SalvageFromTrashCanAction.class, "ntMoveDlgTitle");
    private static final Message MSG_MOVE_INSTRACTION = new Message(SalvageFromTrashCanAction.class, "msgMoveInstraction");

    public SalvageFromTrashCanAction(WindowController windowController) {
        super(windowController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Collection collection = FileManager.instance().getTrashCan();
        RootGameTreeChooser rootGameTreeChooser = new RootGameTreeChooser(Display.getCurrent().getActiveShell(), collection, RootGameTreeChooser.Style.SINGLE);
        rootGameTreeChooser.setShellTitle(NT_SALVAGE_DLG_TITLE.get());
        rootGameTreeChooser.setTitle(MSG_SALVAGE_INSTRACTION.get());
        if (1 == rootGameTreeChooser.open()) {
            return;
        }
        RootGameTree[] rootGameTreeArray = rootGameTreeChooser.getSelected();
        if (0 == rootGameTreeArray.length) {
            return;
        }
        RootGameTree rootGameTree = rootGameTreeArray[0];
        EnumSet<SelectTargetFileDialog.Type> enumSet = this.getTypes();
        SelectTargetFileDialog selectTargetFileDialog = new SelectTargetFileDialog(Display.getCurrent().getActiveShell(), enumSet);
        String string = rootGameTree.getGameType().displayName();
        selectTargetFileDialog.setShellTitle(NT_MOVE_DLG_TITLE.get((Object)string));
        selectTargetFileDialog.setTitle(MSG_MOVE_INSTRACTION.get((Object)string));
        if (selectTargetFileDialog.open() == 1) {
            return;
        }
        CollectionController collectionController = selectTargetFileDialog.getTarget();
        boolean bl = false;
        try {
            if (collectionController == null) {
                Collection collection2 = new Collection();
                collection2.addLast(rootGameTree);
                this.controller_.register(collection2, BasicMessages.LB_NEW_FILE.get(), true, 0);
                this.controller_.getActive().getEventBroker().executeCommand(new ChangeEditModeCommand(true));
                bl = true;
                return;
            }
            CollectionProxy collectionProxy = collectionController.getCollectionProxy();
            collectionProxy.createGame(rootGameTree);
            this.notifyCollectionViewer(collectionController);
            this.changeForLastGame(collectionController);
            bl = true;
        }
        finally {
            if (bl) {
                for (int i = 0; i < collection.size(); ++i) {
                    if (!rootGameTree.equals(collection.get(i))) continue;
                    FileManager.instance().pickUp(i);
                    break;
                }
            }
        }
    }

    protected boolean isRunnable(CollectionController collectionController) {
        return true;
    }
}

