/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.BasicMessages;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.None;
import org.unitarou.sgf.type.SgfDouble;
import org.unitarou.sgf.util.provider.plp.BasicPropertyLabelProvider;
import org.unitarou.sgf.util.provider.plp.PropertyLabelProvider;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetMoveValueAction
extends AbstractAction
implements Adaptable {
    private static final Set<Property> exclusives_s_;
    private static final Message LB_ADD;
    private static final Message LB_REMOVE;
    private static final Message CLB_NO_VALUE;
    private final Adapter adapter_ = new Adapter();
    private final Property property_;
    private PropertyLabelProvider provider_;
    private final Property[] exclusives_;
    private GameType gameType_;
    private boolean isAddMode_;

    public SetMoveValueAction(WindowController windowController, Property property) {
        super(windowController);
        this.property_ = property == null ? null : new Property(property);
        this.provider_ = new BasicPropertyLabelProvider();
        this.gameType_ = GameType.GAME;
        HashSet<Property> hashSet = new HashSet<Property>(exclusives_s_);
        if (this.property_ == null) {
            this.isAddMode_ = false;
        } else {
            this.isAddMode_ = true;
            if (!hashSet.remove(this.property_)) {
                hashSet.clear();
            } else if (this.property_.sgfId().valueType().equals((Object)ValueType.DOUBLE)) {
                hashSet.remove(this.property_.sgfId().makeProperty(SgfDouble.EMPHASIZED));
                hashSet.remove(this.property_.sgfId().makeProperty(SgfDouble.NORMAL));
            }
        }
        this.exclusives_ = hashSet.toArray(new Property[hashSet.size()]);
        this.updateText();
        this.setEnabled(false);
        this.controller_.addListener(this.adapter_);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void run() {
        UpdateProperty updateProperty = this.isAddMode_ || this.property_ == null ? new UpdateProperty(this.exclusives_, this.property_, null) : new UpdateProperty(new Property[]{this.property_}, null, null);
        this.controller_.getActive().getEventBroker().executeCommand(updateProperty);
    }

    private void updateText() {
        if (this.property_ == null) {
            this.setText(CLB_NO_VALUE.get());
            return;
        }
        this.setText(this.isAddMode_ ? LB_ADD.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)) : LB_REMOVE.get(this.property_.toSgf(), this.provider_.getLabel(this.gameType_, this.property_)));
    }

    static {
        ArrayList<Property> arrayList = new ArrayList<Property>(8);
        arrayList.add(SgfId.TESUJI.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.TESUJI.makeProperty(SgfDouble.NORMAL));
        arrayList.add(SgfId.BAD_MOVE.makeProperty(SgfDouble.EMPHASIZED));
        arrayList.add(SgfId.BAD_MOVE.makeProperty(SgfDouble.NORMAL));
        arrayList.add(SgfId.INTERESTING.makeProperty(None.INSTANCE));
        arrayList.add(SgfId.DOUBTFUL.makeProperty(None.INSTANCE));
        exclusives_s_ = Collections.unmodifiableSet(new HashSet(arrayList));
        LB_ADD = new Message(SetMoveValueAction.class, "lbAdd");
        LB_REMOVE = new Message(SetMoveValueAction.class, "lbRemove");
        CLB_NO_VALUE = new Message(SetMoveValueAction.class, "clbNoValue");
    }

    private class Adapter
    implements GameMonitor,
    NodeMonitor,
    ControllerStatusMonitor,
    WindowControllerListener {
        private Reference<CollectionController> refGfc_ = new WeakReference<Object>(null);
        private boolean hasMove_ = false;

        private Adapter() {
        }

        public void changeActive(CollectionController collectionController) {
            CollectionController collectionController2 = this.refGfc_.get();
            if (collectionController2 != null) {
                collectionController2.getEventBroker().removeView(SetMoveValueAction.this);
            }
            this.refGfc_ = new WeakReference<CollectionController>(collectionController);
            if (collectionController != null) {
                collectionController.getEventBroker().addView(SetMoveValueAction.this);
                SetMoveValueAction.this.gameType_ = collectionController.getCollectionProxy().getActive().getGameType();
            }
            this.update();
        }

        public void update(RgtProxy rgtProxy) {
            ArgumentChecker.throwIfNull((Object)rgtProxy);
            SetMoveValueAction.this.gameType_ = rgtProxy.getGameType();
            this.update();
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            this.hasMove_ = nodeView.containsPropertyType(PropertyType.MOVE);
            boolean bl = false;
            if (SetMoveValueAction.this.property_ == null) {
                SetMoveValueAction.this.isAddMode_ = false;
                for (Property property : SetMoveValueAction.this.exclusives_) {
                    if (null == nodeView.getProperty(property.sgfId())) continue;
                    bl = true;
                    break;
                }
                SetMoveValueAction.this.setEnabled(this.hasMove_ && bl);
                return;
            }
            Property property = nodeView.getProperty(SetMoveValueAction.this.property_.sgfId());
            SetMoveValueAction.this.isAddMode_ = property == null || !property.getString().equals(SetMoveValueAction.this.property_.getString());
            this.update();
            if (!SetMoveValueAction.this.isEnabled()) {
                return;
            }
        }

        private void update() {
            EnumSet<GameType> enumSet = SetMoveValueAction.this.property_ == null ? EnumSet.of(SetMoveValueAction.this.gameType_) : SetMoveValueAction.this.property_.sgfId().gameTypes();
            CollectionController collectionController = this.refGfc_.get();
            SetMoveValueAction.this.setEnabled(this.hasMove_ && collectionController != null && collectionController.isEditMode() && enumSet.contains(SetMoveValueAction.this.gameType_));
            if (enumSet.contains(SetMoveValueAction.this.gameType_)) {
                SetMoveValueAction.this.updateText();
            } else {
                SetMoveValueAction.this.setText(BasicMessages.LB_NOT_IN_SERVICE.get());
            }
        }

        public void setEditMode(boolean bl) {
            CollectionController collectionController = this.refGfc_.get();
            this.currentChanged(collectionController.getCollectionProxy().getActive().getNodeList().getCurrentNodeView());
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
        }
    }
}

