/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.Fingerprint;
import org.unitarou.sgf.util.SgfRectangle;
import org.unitarou.sgf.util.Stone;
import org.unitarou.yukinoshita.view.jface.board.RuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.SimpleRuledLinePainter;
import org.unitarou.yukinoshita.view.jface.board.bp.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.bp.SimpleBoardPainter;
import org.unitarou.yukinoshita.view.jface.board.sp.SimpleStonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainterParameter;

public class FingerprintPainter {
    private BoardPainter boardPainter_ = new SimpleBoardPainter();
    private RuledLinePainter ruledLinePainter_ = new SimpleRuledLinePainter();
    private StonePainter stonePainter_ = new SimpleStonePainter();

    protected BoardPainter getBoardPainter() {
        return this.boardPainter_;
    }

    protected void setBoardPainter(BoardPainter boardPainter) {
        ArgumentChecker.throwIfNull((Object)boardPainter);
        this.boardPainter_ = boardPainter;
    }

    protected RuledLinePainter getRuledLinePainter() {
        return this.ruledLinePainter_;
    }

    protected void setRuledLinePainter(RuledLinePainter ruledLinePainter) {
        ArgumentChecker.throwIfNull((Object)ruledLinePainter);
        this.ruledLinePainter_ = ruledLinePainter;
    }

    protected StonePainter getStonePainter() {
        return this.stonePainter_;
    }

    protected void setStonePainter(StonePainter stonePainter) {
        ArgumentChecker.throwIfNull((Object)stonePainter);
        this.stonePainter_ = stonePainter;
    }

    public final void paint(GC gC, Rectangle rectangle, Fingerprint fingerprint) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle, (Object)fingerprint);
        this.doBeforePaint(gC, rectangle, fingerprint);
        SgfRectangle sgfRectangle = this.calcViewArea(fingerprint);
        int n = Math.min(rectangle.width / sgfRectangle.width(), rectangle.height / sgfRectangle.height());
        this.drawBackGround(gC, rectangle);
        if (n < 3) {
            return;
        }
        Point point = new Point(rectangle.x + (rectangle.width - n * sgfRectangle.width()) / 2, rectangle.y + (rectangle.height - n * sgfRectangle.height()) / 2);
        SgfPoint sgfPoint = sgfRectangle.getStart();
        SgfSize sgfSize = fingerprint.getSize();
        for (int i = sgfPoint.y(); i <= sgfRectangle.getEnd().y(); ++i) {
            for (int j = sgfPoint.x(); j <= sgfRectangle.getEnd().x(); ++j) {
                SgfPoint sgfPoint2 = SgfPoint.create(sgfSize, j, i);
                Rectangle rectangle2 = new Rectangle((j - 1) * n + point.x, (i - 1) * n + point.y, n, n);
                this.drawBlock(gC, rectangle2, fingerprint, sgfPoint2);
            }
        }
    }

    protected void doBeforePaint(GC gC, Rectangle rectangle, Fingerprint fingerprint) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle, (Object)fingerprint);
    }

    protected SgfRectangle calcViewArea(Fingerprint fingerprint) {
        int n;
        int n2;
        int n3;
        SgfSize sgfSize = fingerprint.getSize();
        SgfRectangle sgfRectangle = new SgfRectangle();
        sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, sgfSize.width(), sgfSize.height()));
        if (!GameType.PROBLEM.equals(fingerprint.getGameType())) {
            return sgfRectangle;
        }
        int n4 = n3 = sgfSize.width();
        while (n4 >= 2) {
            n2 = 0;
            for (n = 1; n <= sgfSize.height(); ++n) {
                if (null == fingerprint.getColor(n4, n)) continue;
                n2 = 1;
                break;
            }
            if (n2 != 0) break;
            n3 = n4--;
        }
        n2 = n4 = sgfSize.height();
        while (n2 >= 2) {
            n = 0;
            for (int i = 1; i <= sgfSize.width(); ++i) {
                if (null == fingerprint.getColor(i, n2)) continue;
                n = 1;
                break;
            }
            if (n != 0) break;
            n4 = n2--;
        }
        sgfRectangle.set(SgfPoint.create(sgfSize, 1, 1), SgfPoint.create(sgfSize, n3, n4));
        return sgfRectangle;
    }

    protected void drawBackGround(GC gC, Rectangle rectangle) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle);
        gC.setBackground(gC.getDevice().getSystemColor(22));
        gC.fillRectangle(rectangle);
    }

    protected void drawBlock(GC gC, Rectangle rectangle, Fingerprint fingerprint, SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull((Object)gC, (Object)rectangle, (Object)fingerprint, (Object)sgfPoint);
        this.boardPainter_.paint(gC, sgfPoint, rectangle);
        this.ruledLinePainter_.paint(gC, sgfPoint, rectangle);
        SgfColor sgfColor = fingerprint.getColor(sgfPoint.x(), sgfPoint.y());
        if (sgfColor == null) {
            return;
        }
        Stone stone = new Stone(sgfColor, sgfPoint, null);
        StonePainterParameter stonePainterParameter = new StonePainterParameter();
        stonePainterParameter.setSgfColor(stone.getColor());
        this.stonePainter_.paintStone(gC, rectangle, stonePainterParameter);
    }
}

