/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.PropertyType;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.NodeJumpCommand;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.CanvasHookedStateHandler;
import org.unitarou.yukinoshita.view.jface.board.eh.CountEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.LineEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.MarkupEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.MoveEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SelectEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.SetupEventDelegator;
import org.unitarou.yukinoshita.view.jface.board.eh.VariationEventDelegator;
import org.unitarou.yukinoshita.view.monitor.ControllerStatusMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorStateHandler
extends CanvasHookedStateHandler {
    private static final Log log_s_ = LogFactory.getLog(EditorStateHandler.class);
    private final Adapter adapter_;

    public EditorStateHandler(IgoBoardPanel igoBoardPanel) {
        super(igoBoardPanel);
        this.registerDelegator(HandlerPhase.SELECT, new SelectEventDelegator());
        this.registerDelegator(HandlerPhase.MOVE, new MoveEventDelegator());
        this.registerDelegator(HandlerPhase.VARIATION, new VariationEventDelegator());
        this.registerDelegator(HandlerPhase.SETUP, new SetupEventDelegator());
        this.registerDelegator(HandlerPhase.MARKUP, new MarkupEventDelegator());
        this.registerDelegator(HandlerPhase.LINE, new LineEventDelegator());
        this.registerDelegator(HandlerPhase.COUNT, new CountEventDelegator());
        this.setHandlerPhase(HandlerPhase.SELECT);
        this.adapter_ = new Adapter();
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        Object object = super.getAdapter(clazz);
        if (object != null) {
            return object;
        }
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    protected void keyPressed(KeyEvent keyEvent) {
        this.updateKey(keyEvent.keyCode | keyEvent.stateMask);
        super.keyPressed(keyEvent);
        this.updateBoard();
    }

    protected void updateKey(int n) {
        this.changeVariation(n);
        NodeList nodeList = this.getIgoBoardPanel().getNodeView().getNodeList();
        EventBroker eventBroker = this.getEventBroker();
        ViewerUtils.handleSelectNode(n, nodeList, eventBroker);
        switch (n) {
            case 0x1000002: {
                eventBroker.executeCommand(new NodeJumpCommand(1));
                break;
            }
            case 0x1000001: {
                eventBroker.executeCommand(new NodeJumpCommand(-1));
            }
        }
    }

    private void updateBoard() {
        EventDelegator eventDelegator = this.getEventDelegator();
        IgoBoardPanel igoBoardPanel = this.getIgoBoardPanel();
        BlockSituation blockSituation = eventDelegator.getBlockSituation(this.getIgoBoardPanel().getNodeView(), this.getBlockStatus(), this.getEventBroker(), this.getMouseEvent());
        igoBoardPanel.getCanvas().setCursor(blockSituation.getCursor());
        igoBoardPanel.paintInTransient(blockSituation.getTransientProperty());
    }

    @Override
    protected void mouseWheel(int n) {
        if (n != 0) {
            NodeJumpCommand nodeJumpCommand = new NodeJumpCommand(n);
            this.getEventBroker().executeCommand(nodeJumpCommand);
        }
    }

    private class Adapter
    implements ControllerStatusMonitor,
    NodeMonitor {
        private HandlerPhase currentHandlerPhase_;
        private NodeView currentNodeView_;

        private Adapter() {
        }

        public void setEditMode(boolean bl) {
        }

        public void changeHandlerPhase(HandlerPhase handlerPhase) {
            ArgumentChecker.throwIfNull((Object)handlerPhase);
            if (handlerPhase.equals(this.currentHandlerPhase_)) {
                return;
            }
            if (!EditorStateHandler.this.hasDelegator(handlerPhase)) {
                log_s_.warn("Unknown HandlerStatus, use " + HandlerPhase.SELECT + " insted. status=" + handlerPhase);
                handlerPhase = HandlerPhase.SELECT;
            }
            this.currentHandlerPhase_ = handlerPhase;
            EditorStateHandler.this.setHandlerPhase(handlerPhase);
            EditorStateHandler.this.getEventDelegator().resetStatus();
            MouseEvent mouseEvent = EditorStateHandler.this.getMouseEvent();
            BlockSituation blockSituation = EditorStateHandler.this.getEventDelegator().getBlockSituation(EditorStateHandler.this.getIgoBoardPanel().getNodeView(), EditorStateHandler.this.getBlockStatus(), EditorStateHandler.this.getEventBroker(), mouseEvent);
            EditorStateHandler.this.getIgoBoardPanel().getCanvas().setCursor(blockSituation.getCursor());
        }

        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (HandlerPhase.SELECT.equals(this.currentHandlerPhase_)) {
                return;
            }
            EventBroker eventBroker = EditorStateHandler.this.getEventBroker();
            HandlerPhase handlerPhase = this.currentHandlerPhase_;
            if ((this.currentNodeView_ == null || nodeView.equals(this.currentNodeView_)) && HandlerPhase.COUNT.equals(this.currentHandlerPhase_)) {
                handlerPhase = this.currentHandlerPhase_;
            } else if (HandlerPhase.MARKUP.equals(this.currentHandlerPhase_) || HandlerPhase.LINE.equals(this.currentHandlerPhase_)) {
                handlerPhase = this.currentHandlerPhase_;
            } else if (nodeView.containsPropertyType(PropertyType.SETUP)) {
                handlerPhase = HandlerPhase.SETUP;
            } else if (nodeView.containsPropertyType(PropertyType.MOVE) && nodeView.isLast()) {
                handlerPhase = HandlerPhase.MOVE;
            } else if (nodeView.containsPropertyType(PropertyType.MOVE) && !nodeView.isLast()) {
                handlerPhase = HandlerPhase.VARIATION;
            }
            this.currentNodeView_ = nodeView;
            if (!Objects.equalsIncludeNull(handlerPhase, this.currentHandlerPhase_)) {
                this.changeHandlerPhase(handlerPhase);
                eventBroker.executeCommand(new ChangeHandlerPhaseCommand(handlerPhase));
            }
            EditorStateHandler.this.updateBoard();
        }
    }
}

