/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.Fingerprints;
import org.unitarou.swt.Swts;
import org.unitarou.swt.UOwnerDrawTableProvider;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.model.db.Master;
import org.unitarou.yukinoshita.model.db.SearchFileCondition;
import org.unitarou.yukinoshita.model.db.SearchedFile;
import org.unitarou.yukinoshita.model.db.Term;
import org.unitarou.yukinoshita.view.jface.db.ColumnType;
import org.unitarou.yukinoshita.view.jface.db.FingerprintMatchingPainter;
import org.unitarou.yukinoshita.view.jface.db.TiSearchedFile;
import org.unitarou.yukinoshita.view.provider.rgtlp.RgtComposer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameThumbnailProvider
implements UOwnerDrawTableProvider<TiSearchedFile> {
    private static final Message LB_THUMBNAIL = new Message(GameThumbnailProvider.class, "lbThumbnail");
    private static final Message LB_SUMMARY = new Message(GameThumbnailProvider.class, "lbSummary");
    private static final Message LB_NUMBER = new Message(GameThumbnailProvider.class, "lbNumber");
    private static final Message LB_SIMILARITY = new Message(GameThumbnailProvider.class, "lbSimilarity");
    private static final Message FMT_TERM = new Message(GameThumbnailProvider.class, "fmtTerm");
    private static final int SUMMERY_PADDING = 2;
    private static final SgfId[] VIEW_GAME_IDS = new SgfId[]{SgfId.PLAYER_BLACK, SgfId.PLAYER_WHITE, SgfId.HANDICAP, SgfId.KOMI, SgfId.RESULT, SgfId.EVENT, SgfId.GAME_NAME};
    private static final SgfId[] VIEW_PROBLEM_IDS = new SgfId[]{SgfId.GAME_NAME, SgfId.RESULT, SgfId.BLACK_RANK, SgfId.TIMELIMIT, SgfId.SOURCE};
    private final int WIDTH;
    private final FingerprintMatchingPainter painter_ = new FingerprintMatchingPainter();
    private final Map<Integer, Reference<ImageData>> imageDataMap_ = new HashMap<Integer, Reference<ImageData>>();
    private SearchFileCondition condition_ = new SearchFileCondition();

    public GameThumbnailProvider() {
        this.WIDTH = 140;
    }

    @Override
    public int getColumnSize() {
        return 2;
    }

    @Override
    public boolean[] getSotableColums() {
        return new boolean[]{false, false};
    }

    @Override
    public void setup(TableColumn[] tableColumnArray) {
        tableColumnArray[0].setText(LB_THUMBNAIL.get());
        tableColumnArray[0].setMoveable(false);
        tableColumnArray[0].setWidth(this.WIDTH);
        tableColumnArray[1].setText(LB_SUMMARY.get());
        tableColumnArray[1].setMoveable(false);
    }

    @Override
    public int compareTo(TiSearchedFile tiSearchedFile, TiSearchedFile tiSearchedFile2, int n) {
        return 0;
    }

    @Override
    public void set(TableItem tableItem, TiSearchedFile tiSearchedFile) {
        int n = tableItem.getParent().indexOf(tableItem);
        tableItem.setText(1, this.makeSummary(n + 1, tiSearchedFile));
        if (tiSearchedFile.getWidth() == 0) {
            Master master = DatabaseManager.instance().selectMaster(tiSearchedFile.getMasterId());
            if (master == null) {
                tiSearchedFile.setWidth(19);
                tiSearchedFile.setHeight(19);
                tiSearchedFile.setFingerprint(Fingerprints.calcFingerprintArray(new RootGameTree()));
            } else {
                tiSearchedFile.setFingerprint(master.getFingerprint());
                tiSearchedFile.setWidth(master.getWidth());
                tiSearchedFile.setHeight(master.getHeight());
            }
        }
        tableItem.setData(tiSearchedFile);
    }

    private String makeSummary(int n, TiSearchedFile tiSearchedFile) {
        List<Term> list = tiSearchedFile.getTerm();
        if (list == null) {
            list = DatabaseManager.instance().select(tiSearchedFile.getGameIndex());
            tiSearchedFile.setTerm(list);
        }
        HashMap<String, CharSequence> hashMap = new HashMap<String, CharSequence>();
        for (Term object : tiSearchedFile.getTerm()) {
            hashMap.put(object.getSgfId(), object.getTerm());
        }
        if (tiSearchedFile.getGameType() == GameType.GAME.getIntValue()) {
            CharSequence charSequence = RgtComposer.compose((CharSequence)hashMap.get(SgfId.PLAYER_BLACK.id()), (CharSequence)hashMap.get(SgfId.BLACK_RANK.id()));
            hashMap.put(SgfId.PLAYER_BLACK.id(), charSequence);
            CharSequence charSequence2 = RgtComposer.compose((CharSequence)hashMap.get(SgfId.PLAYER_WHITE.id()), (CharSequence)hashMap.get(SgfId.WHITE_RANK.id()));
            hashMap.put(SgfId.PLAYER_WHITE.id(), charSequence2);
            return this.makeSummaryImpl(n, tiSearchedFile, hashMap, VIEW_GAME_IDS);
        }
        return this.makeSummaryImpl(n, tiSearchedFile, hashMap, VIEW_PROBLEM_IDS);
    }

    private String makeSummaryImpl(int n, TiSearchedFile tiSearchedFile, Map<String, CharSequence> map, SgfId[] sgfIdArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(LB_NUMBER.get((Object)n));
        if (0 <= tiSearchedFile.getSimilarity()) {
            stringBuilder.append(Strings.LINE_SEPARATOR).append(LB_SIMILARITY.get((Object)tiSearchedFile.getSimilarity()));
        }
        for (SgfId sgfId : sgfIdArray) {
            if (!map.containsKey(sgfId.id())) continue;
            stringBuilder.append(Strings.LINE_SEPARATOR).append(FMT_TERM.get(sgfId.displayName(), map.get(sgfId.id())));
        }
        if (tiSearchedFile.getMove() != 0) {
            stringBuilder.append(Strings.LINE_SEPARATOR).append(FMT_TERM.get(ColumnType.MOVES.toString(), tiSearchedFile.getMove()));
        }
        if (null != tiSearchedFile.getDate()) {
            stringBuilder.append(Strings.LINE_SEPARATOR).append(FMT_TERM.get(SgfId.DATE.displayName(), tiSearchedFile.getDate()));
        }
        stringBuilder.append(Strings.LINE_SEPARATOR).append(tiSearchedFile.getPath());
        return stringBuilder.toString();
    }

    @Override
    public Point measureItem(GC gC, Point point, TableItem tableItem, int n) {
        switch (n) {
            case 0: {
                return new Point(this.WIDTH, this.WIDTH);
            }
            case 1: {
                Point point2 = gC.textExtent(tableItem.getText(1));
                point2.x += 2;
                point2.y = Math.max(point2.y + 2, point.y);
                return point2;
            }
        }
        return point;
    }

    @Override
    public void paintItem(GC gC, Rectangle rectangle, TableItem tableItem, int n) {
        switch (n) {
            case 0: {
                this.paintBoard(gC, rectangle, tableItem);
                break;
            }
            case 1: {
                this.paintSummary(gC, rectangle, tableItem.getText(1));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintBoard(GC gC, Rectangle rectangle, TableItem tableItem) {
        Image image;
        ImageData imageData;
        SearchedFile searchedFile = (SearchedFile)tableItem.getData();
        Integer n = searchedFile.getMasterId();
        Reference<ImageData> reference = this.imageDataMap_.get(n);
        ImageData imageData2 = imageData = reference == null ? null : reference.get();
        if (imageData == null) {
            image = new Image(gC.getDevice(), this.WIDTH, this.WIDTH);
            GC gC2 = new GC(image);
            try {
                this.painter_.paint(gC2, new Rectangle(0, 0, this.WIDTH, this.WIDTH), searchedFile, this.condition_);
                imageData = image.getImageData();
                this.imageDataMap_.put(n, new SoftReference<ImageData>(imageData));
            }
            finally {
                Swts.disposeQuietly(gC2);
                Swts.disposeQuietly(image);
            }
        }
        image = new Image(gC.getDevice(), imageData);
        gC.drawImage(image, rectangle.x, rectangle.y);
        Swts.disposeQuietly(image);
    }

    private void paintSummary(GC gC, Rectangle rectangle, String string) {
        gC.drawText(string, rectangle.x + 2, rectangle.y + 2, false);
    }

    public void setFingerprintCondition(SearchFileCondition searchFileCondition) {
        ArgumentChecker.throwIfNull((Object)searchFileCondition);
        if (!this.condition_.equals(searchFileCondition)) {
            this.condition_ = searchFileCondition;
            this.imageDataMap_.clear();
        }
    }
}

