/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg;

import java.util.ArrayList;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.unitarou.jface.UTitleAreaDialog;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.yukinoshita.view.jface.board.ol.BasicOutlinePanel;
import org.unitarou.yukinoshita.view.jface.board.ol.CollectionsOutlinePanel;
import org.unitarou.yukinoshita.view.jface.board.ol.IgoOutlinePanel;

public class RootGameTreeChooser
extends UTitleAreaDialog {
    private final Collection collection_;
    private final Style style_;
    private final CollectionsOutlinePanel<BasicOutlinePanel> collectionsPanel_;
    private IgoOutlinePanel[] panels_;

    public RootGameTreeChooser(Shell shell, Collection collection, Style style) {
        super(shell);
        ArgumentChecker.throwIfNull((Object)collection, (Object)style);
        this.setShellStyle(32816);
        this.collection_ = collection;
        this.style_ = style;
        this.collectionsPanel_ = new CollectionsOutlinePanel<BasicOutlinePanel>(BasicOutlinePanel.factory(), 3);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        Button button = this.getButton(0);
        if (button == null) {
            throw new IllegalStateException("Can't find OK button.");
        }
        button.setEnabled(this.style_.equals((Object)Style.ANY));
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        Composite composite3 = new Composite(composite2, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 500;
        gridData.heightHint = 300;
        composite3.setLayoutData(gridData);
        composite3.setLayout(new FillLayout());
        this.collectionsPanel_.createContents(composite3);
        this.collectionsPanel_.set(new Collection[]{this.collection_});
        this.panels_ = this.collectionsPanel_.getPanels(new BasicOutlinePanel[0]);
        MouseListened mouseListened = new MouseListened();
        for (IgoOutlinePanel igoOutlinePanel : this.panels_) {
            igoOutlinePanel.getBoardControl().addMouseListener(mouseListened);
        }
        return composite2;
    }

    public RootGameTree[] getSelected() {
        ArrayList<RootGameTree> arrayList = new ArrayList<RootGameTree>(this.panels_.length);
        for (IgoOutlinePanel igoOutlinePanel : this.panels_) {
            if (!igoOutlinePanel.isFocused()) continue;
            arrayList.add(igoOutlinePanel.getRootGameTree());
        }
        return arrayList.toArray(new RootGameTree[arrayList.size()]);
    }

    private class MouseListened
    extends MouseAdapter {
        private MouseListened() {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            switch (RootGameTreeChooser.this.style_) {
                case SINGLE: {
                    for (IgoOutlinePanel igoOutlinePanel : RootGameTreeChooser.this.panels_) {
                        igoOutlinePanel.setFocus(igoOutlinePanel.getBoardControl().equals(mouseEvent.widget));
                    }
                    RootGameTreeChooser.this.getButton(0).setEnabled(true);
                    break;
                }
                case MULTI: {
                    int n = 0;
                    for (IgoOutlinePanel igoOutlinePanel : RootGameTreeChooser.this.panels_) {
                        if (igoOutlinePanel.getBoardControl().equals(mouseEvent.widget)) {
                            igoOutlinePanel.setFocus(!igoOutlinePanel.isFocused());
                        }
                        n += igoOutlinePanel.isFocused() ? 1 : 0;
                    }
                    RootGameTreeChooser.this.getButton(0).setEnabled(n != 0);
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        SINGLE,
        MULTI,
        ANY;

    }
}

