/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.dlg.fe;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.unitarou.cmd.CommandDriver;
import org.unitarou.jface.UActionContributionItem;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.swt.USashForm;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.StateHandler;
import org.unitarou.yukinoshita.events.WindowControllerListener;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.CollectionFrame;
import org.unitarou.yukinoshita.view.HandlerPhase;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.cmd.ChangeHandlerPhaseCommand;
import org.unitarou.yukinoshita.view.cmd.RedoCommand;
import org.unitarou.yukinoshita.view.cmd.UndoComamnd;
import org.unitarou.yukinoshita.view.jface.board.IgoBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.IgoGraphicalBoardPanel;
import org.unitarou.yukinoshita.view.jface.board.bp.BoardPainter;
import org.unitarou.yukinoshita.view.jface.board.bp.SimpleBoardPainter;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.board.sp.SimpleStonePainter;
import org.unitarou.yukinoshita.view.jface.board.sp.StonePainter;
import org.unitarou.yukinoshita.view.jface.db.FingerprintQuery;
import org.unitarou.yukinoshita.view.jface.db.MoveQuery;
import org.unitarou.yukinoshita.view.jface.dlg.fe.DimEventDelegator;
import org.unitarou.yukinoshita.view.jface.dlg.fe.FeGameMoveEventDelegator;
import org.unitarou.yukinoshita.view.jface.dlg.fe.FeGameSetupEventDelegator;
import org.unitarou.yukinoshita.view.jface.dlg.fe.FeProblemSetupEventDelegator;
import org.unitarou.yukinoshita.view.jface.dlg.fe.QueryBoardEditorStateHandler;
import org.unitarou.yukinoshita.view.jface.gm.HandlerStatusActions;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;
import org.unitarou.yukinoshita.view.monitor.CommandDriverDefaultMonitor;
import org.unitarou.yukinoshita.view.provider.blklp.BlockLabelProvider;
import org.unitarou.yukinoshita.view.provider.blklp.MoveNumberProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBoardEditorDialog
extends Dialog {
    private static final Message LB_BOARD_QUERY_MAKER = new Message(QueryBoardEditorDialog.class, "lbBoardQueryMaker");
    private static final Message LB_MANUAL = new Message(QueryBoardEditorDialog.class, "lbManual");
    private static final Message LB_SEARCH_POSITION = new Message(QueryBoardEditorDialog.class, "lbSearchPosition");
    private static final Message LB_SEARCH_MOVES = new Message(QueryBoardEditorDialog.class, "lbSearchMoves");
    private static final Message LB_SEARCH_TYPES = new Message(QueryBoardEditorDialog.class, "lbSearchTypes");
    private static final Message CLB_UNDO = new Message(QueryBoardEditorDialog.class, "clbUndo");
    private static final Message CLB_REDO = new Message(QueryBoardEditorDialog.class, "clbRedo");
    private static final Message CLB_COPY_TO_CLIPBOARD = new Message(QueryBoardEditorDialog.class, "clbCopyToClipBoard");
    private static final Message LB_OPERATION = new Message(QueryBoardEditorDialog.class, "lbOperation");
    private static final Message LB_SEARCH_OPTION = new Message(QueryBoardEditorDialog.class, "lbSearchOption");
    private static final Message LB_POSITION_SAME = new Message(QueryBoardEditorDialog.class, "lbPositionSame");
    private static final Message LB_POSITION_PENALTY = new Message(QueryBoardEditorDialog.class, "lbPositionPenalty");
    private static final Message MSG_POSITION_MANUAL = new Message(QueryBoardEditorDialog.class, "msgPositionManual");
    private static final Message LB_MOVE_HEAD = new Message(QueryBoardEditorDialog.class, "lbMoveHead");
    private static final Message LB_MOVE_SKIP = new Message(QueryBoardEditorDialog.class, "lbMoveSkip");
    private static final Message MSG_MOVE_MANUAL = new Message(QueryBoardEditorDialog.class, "msgMoveManual");
    private static final Log log_s_ = LogFactory.getLog(QueryBoardEditorDialog.class);
    private static final int IDX_MANUAL = 0;
    private Composite frame_;
    private final IgoBoardPanel igoBoardPanel_;
    private final ToolBarManager toolBarManager_;
    private ExpandBar expandBar_;
    private Text txManual_;
    private Button btUndo_;
    private Button btRedo_;
    private Button btCopyToClipboard_;
    private Label lbOptionScale_;
    private Scale scOption_;
    private CollectionController gfc_;
    private EventBroker eventBroker_;
    private final RootGameTree base_;
    private final Collection collection_;
    private final HandlerStatusActions handlerStatusActions_;
    private final List<QueryType> queryTypes_;
    private int idxQueryType_;
    private int scaleOption_;

    public QueryBoardEditorDialog(Collection collection, int n, int n2, Shell shell) {
        super(shell);
        this.setShellStyle(65584);
        ArgumentChecker.throwIfNull((Object)collection);
        this.collection_ = new Collection(collection);
        this.base_ = collection.get(n);
        this.igoBoardPanel_ = new IgoGraphicalBoardPanel();
        this.toolBarManager_ = new ToolBarManager(0x800000);
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.handlerStatusActions_ = new HandlerStatusActions();
        this.queryTypes_ = new ArrayList<QueryType>();
        this.queryTypes_.add(new PatternQueryType());
        if (GameType.GAME.equals(this.base_.getGameType())) {
            this.queryTypes_.add(new MoveQueryType());
        }
        this.idxQueryType_ = n;
        this.scaleOption_ = n2;
    }

    public int getIdxRootGameTree() {
        return this.idxQueryType_;
    }

    public Collection getCollection() {
        return this.collection_;
    }

    public FingerprintQuery makeFingerprintQuery() {
        FingerprintQuery fingerprintQuery = new FingerprintQuery();
        if (this.idxQueryType_ != 0) {
            fingerprintQuery.setEnabled(false);
        } else {
            fingerprintQuery.setCondition(this.collection_.get(this.idxQueryType_), new HashSet<SgfPoint>(this.getFilter()), this.scaleOption_);
            fingerprintQuery.setEnabled(true);
        }
        return fingerprintQuery;
    }

    public MoveQuery makeMoveQuery() {
        MoveQuery moveQuery = new MoveQuery();
        if (this.idxQueryType_ != 1) {
            moveQuery.setEnabled(false);
        } else {
            moveQuery.setQuery(this.collection_.get(this.idxQueryType_), this.scaleOption_);
            moveQuery.setEnabled(moveQuery.getLength() != 0);
        }
        return moveQuery;
    }

    public List<SgfPoint> getFilter() {
        RootGameTree rootGameTree = this.collection_.get(this.idxQueryType_);
        ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>(rootGameTree.getSize().all().size());
        arrayList.addAll(this.getSgfPoints(SgfId.DIM_POINTS));
        return arrayList;
    }

    private List<SgfPoint> getSgfPoints(SgfId sgfId) {
        ArrayList<SgfPoint> arrayList = new ArrayList<SgfPoint>();
        RootGameTree rootGameTree = this.collection_.get(this.idxQueryType_);
        List<Property> list = BasicFinder.findAll(rootGameTree, sgfId);
        for (Property property : list) {
            SgfPoint[] sgfPointArray;
            for (SgfPoint sgfPoint : sgfPointArray = SgfPoint.parse(rootGameTree.getSize(), property.getStrings())) {
                arrayList.add(sgfPoint);
            }
        }
        return arrayList;
    }

    @Override
    public int open() {
        int n = super.open();
        this.gfc_.dispose();
        return n;
    }

    @Override
    public void create() {
        super.create();
        CollectionFrameImpl collectionFrameImpl = new CollectionFrameImpl();
        this.gfc_ = new CollectionController(this.collection_, collectionFrameImpl, collectionFrameImpl, false, 0, true);
        this.changeActiveGame();
    }

    private void changeActiveGame() {
        if (this.gfc_ == null) {
            return;
        }
        this.gfc_.getCollectionProxy().setActive(this.idxQueryType_);
        this.setDrawingParameters();
        NodeView nodeView = this.gfc_.getCollectionProxy().getActive().getCurrentNodeView();
        this.igoBoardPanel_.update(nodeView);
    }

    private void setDrawingParameters() {
        CurrentContext currentContext = this.gfc_.getCollectionProxy().getActive().getContext();
        currentContext.setAttribute(BoardPainter.CONTEXT, new SimpleBoardPainter());
        currentContext.setAttribute(StonePainter.CONTEXT, new SimpleStonePainter());
        currentContext.setAttribute(BlockLabelProvider.CONTEXT, new MoveNumberProvider());
        this.igoBoardPanel_.setContext(currentContext);
    }

    @Override
    protected Point getInitialSize() {
        return new Point(800, 600);
    }

    @Override
    protected Control createDialogArea(Composite composite) {
        Shell shell = composite.getShell();
        shell.setText(LB_BOARD_QUERY_MAKER.get());
        this.frame_ = (Composite)super.createDialogArea(composite);
        USashForm uSashForm = SwtFactory.createUSashForm(this.frame_, 256);
        uSashForm.setLayoutData(new GridData(4, 4, true, true));
        USashForm uSashForm2 = SwtFactory.createUSashForm(uSashForm, 512);
        this.igoBoardPanel_.createContents(uSashForm2);
        this.toolBarManager_.createControl(uSashForm2);
        uSashForm2.setWeights(new int[]{440, -25});
        this.createControllerFrame(uSashForm);
        int[] nArray = new int[]{500, -300};
        uSashForm.setWeights(nArray);
        return this.frame_;
    }

    private void createControllerFrame(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout(SwtFactory.createInnerGrid(1, true));
        this.expandBar_ = new ExpandBar(composite2, 512);
        this.expandBar_.setLayoutData(new GridData(4, 4, true, true));
        this.expandBar_.setSpacing(8);
        this.createManualGroup(this.expandBar_);
        this.createQuetyTypeGroup(this.expandBar_);
        this.createOperationGroup(this.expandBar_);
        this.createOptionGroup(this.expandBar_);
        this.changeQueryType();
        this.updateScaleOptionRange();
        this.scOption_.setSelection(this.scaleOption_);
    }

    private Composite createManualGroup(ExpandBar expandBar) {
        Composite composite = new Composite(expandBar, 0);
        composite.setLayout(SwtFactory.createGrid(1, true));
        this.txManual_ = new Text(composite, 74);
        this.txManual_.setLayoutData(new GridData(16384, 128, true, true));
        this.txManual_.setBackground(this.txManual_.getDisplay().getSystemColor(25));
        ExpandItem expandItem = new ExpandItem(expandBar, 0);
        expandItem.setText(LB_MANUAL.get());
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        expandItem.setControl(composite);
        return composite;
    }

    private Composite createQuetyTypeGroup(ExpandBar expandBar) {
        Widget widget;
        Composite composite = new Composite(expandBar, 0);
        composite.setLayout(SwtFactory.createGrid(1, true));
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                QueryBoardEditorDialog.this.selectQueryTypeButton((Button)selectionEvent.widget);
            }
        };
        Button button = new Button(composite, 16);
        button.setText(LB_SEARCH_POSITION.get());
        button.setData(0);
        button.setSelection(this.idxQueryType_ == 0);
        button.addSelectionListener(selectionAdapter);
        if (GameType.GAME.equals(this.base_.getGameType())) {
            widget = new Button(composite, 16);
            ((Button)widget).setText(LB_SEARCH_MOVES.get());
            widget.setData(1);
            ((Button)widget).setSelection(this.idxQueryType_ == 1);
            ((Button)widget).addSelectionListener(selectionAdapter);
        }
        widget = new ExpandItem(expandBar, 0, 1);
        ((ExpandItem)widget).setText(LB_SEARCH_TYPES.get());
        ((ExpandItem)widget).setHeight(composite.computeSize((int)-1, (int)-1).y);
        ((ExpandItem)widget).setControl(composite);
        ((ExpandItem)widget).setExpanded(true);
        return composite;
    }

    private Composite createOperationGroup(ExpandBar expandBar) {
        Composite composite = new Composite(expandBar, 0);
        composite.setLayout(SwtFactory.createGrid(1, true));
        this.btUndo_ = new Button(composite, 8);
        this.btUndo_.setText(CLB_UNDO.get());
        this.btUndo_.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.btUndo_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                QueryBoardEditorDialog.this.gfc_.getEventBroker().executeCommand(new UndoComamnd());
            }
        });
        this.btUndo_.setEnabled(false);
        this.btRedo_ = new Button(composite, 8);
        this.btRedo_.setText(CLB_REDO.get());
        this.btRedo_.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.btRedo_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                QueryBoardEditorDialog.this.gfc_.getEventBroker().executeCommand(new RedoCommand());
            }
        });
        this.btRedo_.setEnabled(false);
        this.btCopyToClipboard_ = new Button(composite, 8);
        this.btCopyToClipboard_.setText(CLB_COPY_TO_CLIPBOARD.get());
        this.btCopyToClipboard_.setLayoutData(new GridData(16384, 0x1000000, false, false));
        this.btCopyToClipboard_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                TextTransfer textTransfer = TextTransfer.getInstance();
                String[] stringArray = QueryBoardEditorDialog.this.makeMoveQuery().getQuery();
                clipboard.setContents(new Object[]{stringArray[0]}, new Transfer[]{textTransfer});
            }
        });
        ExpandItem expandItem = new ExpandItem(expandBar, 0, 2);
        expandItem.setText(LB_OPERATION.get());
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        expandItem.setControl(composite);
        expandItem.setExpanded(true);
        return composite;
    }

    private Composite createOptionGroup(ExpandBar expandBar) {
        Composite composite = new Composite(expandBar, 0);
        composite.setLayout(SwtFactory.createGrid(1, true));
        this.lbOptionScale_ = new Label(composite, 131072);
        this.lbOptionScale_.setLayoutData(new GridData(16384, 0x1000000, true, false));
        this.scOption_ = new Scale(composite, 256);
        this.scOption_.setLayoutData(new GridData(4, 0x1000000, true, false));
        this.scOption_.setMinimum(0);
        this.scOption_.setMaximum(1);
        this.scOption_.setPageIncrement(1);
        this.scOption_.setSelection(0);
        this.scOption_.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                QueryBoardEditorDialog.this.scaleOption_ = QueryBoardEditorDialog.this.scOption_.getSelection();
                QueryBoardEditorDialog.this.updateScaleOptionLabel();
            }
        });
        ExpandItem expandItem = new ExpandItem(expandBar, 0, 2);
        expandItem.setText(LB_SEARCH_OPTION.get());
        expandItem.setHeight(composite.computeSize((int)-1, (int)-1).y);
        expandItem.setControl(composite);
        expandItem.setExpanded(true);
        return composite;
    }

    private void updateScaleOptionRange() {
        QueryType queryType = this.queryTypes_.get(this.idxQueryType_);
        int n = queryType.calcOptionScaleMax(this.collection_.get(this.idxQueryType_));
        this.scOption_.setMaximum(n);
        if (n < this.scOption_.getSelection()) {
            this.scOption_.setSelection(n);
        }
        this.updateScaleOptionLabel();
    }

    private void updateScaleOptionLabel() {
        this.lbOptionScale_.setText(this.queryTypes_.get(this.idxQueryType_).getScaleOptionLabel());
        this.lbOptionScale_.getParent().layout();
    }

    private void selectQueryTypeButton(Button button) {
        if (!button.getSelection()) {
            return;
        }
        this.idxQueryType_ = (Integer)button.getData();
        this.changeQueryType();
    }

    private void changeQueryType() {
        this.updateBtCopyToClipboard();
        this.updateScaleOptionRange();
        this.changeActiveGame();
        this.updateStateHandler();
        this.updateManual();
    }

    private void updateBtCopyToClipboard() {
        this.btCopyToClipboard_.setVisible(this.idxQueryType_ == 1);
        MoveQuery moveQuery = this.makeMoveQuery();
        if (moveQuery.isEnabled()) {
            String[] stringArray = this.makeMoveQuery().getQuery();
            this.btCopyToClipboard_.setEnabled(0 < stringArray.length && stringArray[0].length() != 0);
        } else {
            this.btCopyToClipboard_.setEnabled(false);
        }
    }

    private void updateStateHandler() {
        HandlerPhase handlerPhase = this.queryTypes_.get(this.idxQueryType_).updateEventBroker();
        this.eventBroker_.connect(this.base_.getGameType(), true);
        this.handlerStatusActions_.setEventBroker(this.eventBroker_);
        this.updateToolBar();
        this.eventBroker_.executeCommand(new ChangeHandlerPhaseCommand(handlerPhase));
    }

    private StateHandler makeGameMoveStateHandler() {
        LinkedHashMap<HandlerPhase, EventDelegator> linkedHashMap = new LinkedHashMap<HandlerPhase, EventDelegator>();
        linkedHashMap.put(HandlerPhase.MOVE, new FeGameMoveEventDelegator());
        return new QueryBoardEditorStateHandler(this.igoBoardPanel_, linkedHashMap);
    }

    private StateHandler makeGamePatternStateHandler() {
        LinkedHashMap<HandlerPhase, EventDelegator> linkedHashMap = new LinkedHashMap<HandlerPhase, EventDelegator>();
        linkedHashMap.put(HandlerPhase.SETUP, new FeGameSetupEventDelegator());
        linkedHashMap.put(HandlerPhase.MARKUP, new DimEventDelegator());
        return new QueryBoardEditorStateHandler(this.igoBoardPanel_, linkedHashMap);
    }

    private StateHandler makeProblemPatternStateHandler() {
        LinkedHashMap<HandlerPhase, EventDelegator> linkedHashMap = new LinkedHashMap<HandlerPhase, EventDelegator>();
        linkedHashMap.put(HandlerPhase.SETUP, new FeProblemSetupEventDelegator());
        linkedHashMap.put(HandlerPhase.MARKUP, new DimEventDelegator());
        return new QueryBoardEditorStateHandler(this.igoBoardPanel_, linkedHashMap);
    }

    private void updateManual() {
        this.txManual_.setText(this.queryTypes_.get(this.idxQueryType_).getManual());
        int n = this.txManual_.getLineCount() * this.txManual_.getLineHeight() + 16;
        ExpandItem expandItem = this.expandBar_.getItem(0);
        Composite composite = this.txManual_.getParent();
        expandItem.setHeight(composite.computeSize((int)-1, (int)n).y);
        this.expandBar_.layout();
    }

    private void updateToolBar() {
        Action[] actionArray;
        this.toolBarManager_.removeAll();
        for (Action action : actionArray = this.handlerStatusActions_.getActions()) {
            action.setEnabled(true);
            this.toolBarManager_.add(new UActionContributionItem(action));
        }
        this.toolBarManager_.update(false);
        this.toolBarManager_.getControl().getParent().layout();
        if (this.eventBroker_.getCurrentStateHander() == null) {
            return;
        }
        HandlerPhase handlerPhase = this.eventBroker_.getCurrentStateHander().getHandlerPhase();
        if (handlerPhase == null) {
            log_s_.warn("HandlerPhase is not found");
            return;
        }
        Action action = this.handlerStatusActions_.getAction(handlerPhase);
        if (action == null) {
            log_s_.warn("Unmapped HandlerPhase: " + handlerPhase);
            return;
        }
        action.setChecked(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CollectionFrameImpl
    extends CommandDriverDefaultMonitor
    implements WindowController,
    CollectionFrame,
    Adaptable {
        private CollectionFrameImpl() {
        }

        @Override
        public void register(Collection collection, String string, boolean bl, int n) {
        }

        @Override
        public CollectionController getActive() {
            return null;
        }

        @Override
        public boolean closeActive() {
            return false;
        }

        @Override
        public CollectionController[] getGameFrameControllers() {
            return new CollectionController[0];
        }

        @Override
        public void defaultLayout() {
        }

        @Override
        public void loadLayout() {
        }

        @Override
        public void saveLayout() {
        }

        @Override
        public void addListener(WindowControllerListener windowControllerListener) {
        }

        @Override
        public void removeListener(WindowControllerListener windowControllerListener) {
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            QueryBoardEditorDialog.this.eventBroker_.removeView(QueryBoardEditorDialog.this.igoBoardPanel_);
            QueryBoardEditorDialog.this.eventBroker_ = eventBroker;
            QueryBoardEditorDialog.this.eventBroker_.addView(QueryBoardEditorDialog.this.igoBoardPanel_);
            QueryBoardEditorDialog.this.eventBroker_.addView(this);
            QueryBoardEditorDialog.this.changeQueryType();
        }

        @Override
        public void close() {
        }

        @Override
        public Object getAdapter(Class<?> clazz) {
            if (clazz == null) {
                return null;
            }
            if (clazz.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        @Override
        public void commandExecuted(CommandDriver.Status status) {
            QueryBoardEditorDialog.this.btUndo_.setEnabled(status.isUndoable());
            QueryBoardEditorDialog.this.btRedo_.setEnabled(status.isRedoable());
            QueryBoardEditorDialog.this.updateBtCopyToClipboard();
            QueryBoardEditorDialog.this.updateScaleOptionRange();
            if (status.getExecutedCommand() instanceof NodeListCommand) {
                QueryBoardEditorDialog.this.gfc_.updateByRedoUndo(((NodeListCommand)status.getExecutedCommand()).getInfluence());
            }
        }
    }

    private class MoveQueryType
    implements QueryType {
        private MoveQueryType() {
        }

        public HandlerPhase updateEventBroker() {
            QueryBoardEditorDialog.this.eventBroker_.register(GameType.GAME, true, QueryBoardEditorDialog.this.makeGameMoveStateHandler());
            return HandlerPhase.MOVE;
        }

        public String getManual() {
            return MSG_MOVE_MANUAL.get();
        }

        public int calcOptionScaleMax(RootGameTree rootGameTree) {
            int n = 0;
            for (Node node : rootGameTree.getSequence()) {
                if (node.contains(SgfId.BLACK)) {
                    ++n;
                }
                if (!node.contains(SgfId.WHITE)) continue;
                ++n;
            }
            return n;
        }

        public String getScaleOptionLabel() {
            if (QueryBoardEditorDialog.this.scOption_.getSelection() == 0) {
                return LB_MOVE_HEAD.get();
            }
            return LB_MOVE_SKIP.get((Object)Integer.toString(QueryBoardEditorDialog.this.scOption_.getSelection()));
        }
    }

    private class PatternQueryType
    implements QueryType {
        private PatternQueryType() {
        }

        public HandlerPhase updateEventBroker() {
            QueryBoardEditorDialog.this.eventBroker_.register(GameType.GAME, true, QueryBoardEditorDialog.this.makeGamePatternStateHandler());
            QueryBoardEditorDialog.this.eventBroker_.register(GameType.PROBLEM, true, QueryBoardEditorDialog.this.makeProblemPatternStateHandler());
            return HandlerPhase.SETUP;
        }

        public String getManual() {
            return MSG_POSITION_MANUAL.get();
        }

        public int calcOptionScaleMax(RootGameTree rootGameTree) {
            List<SgfPoint> list = QueryBoardEditorDialog.this.getFilter();
            int n = (rootGameTree.getSize().all().size() - list.size()) * 2;
            return n;
        }

        public String getScaleOptionLabel() {
            if (QueryBoardEditorDialog.this.scOption_.getSelection() == 0) {
                return LB_POSITION_SAME.get();
            }
            return LB_POSITION_PENALTY.get((Object)Integer.toString(QueryBoardEditorDialog.this.scOption_.getSelection()));
        }
    }

    private static interface QueryType {
        public HandlerPhase updateEventBroker();

        public String getManual();

        public int calcOptionScaleMax(RootGameTree var1);

        public String getScaleOptionLabel();
    }
}

