/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ns;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Objects;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.model.cmd.SelectVariation;
import org.unitarou.yukinoshita.view.ViewerUtils;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.ns.MoveButton;
import org.unitarou.yukinoshita.view.jface.resource.NodeImage;
import org.unitarou.yukinoshita.view.monitor.ContextMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;
import org.unitarou.yukinoshita.view.monitor.NodeMonitor;
import org.unitarou.yukinoshita.view.provider.vlp.VariationLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariationSelectorPanel
implements YukinoshitaPanel {
    private static final Message LB_VARIATION = new Message(VariationSelectorPanel.class, "lbVariation");
    private static final Message LB_REGULAR_PATH = new Message(VariationSelectorPanel.class, "lbRegularPath");
    private static final Message LB_ANOTHER_PATH = new Message(VariationSelectorPanel.class, "lbAnotherPath");
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private NodeList nodeList_ = null;
    private Group selector_;
    private final ArrayList<MoveButton> variationButtons_ = new ArrayList();
    private CoordinatesLabelProvider coordinatesLabelProvider_ = Yukinoshita.context(null).getProvider(CoordinatesLabelProvider.class);
    private VariationLabelProvider variationLabelProvider_ = VariationLabelProvider.CONTEXT.defaultValue();
    private final Adapter adapter_ = new Adapter();
    private NodeView[] variations_ = new NodeView[0];

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        this.selector_ = new Group(composite, 16);
        this.selector_.setLayout(new RowLayout(512));
        this.selector_.setText(LB_VARIATION.get());
        GroupListener groupListener = new GroupListener();
        this.selector_.addKeyListener(groupListener);
        return this.selector_;
    }

    @Override
    public void close() {
    }

    @Override
    public Control getControl() {
        return this.selector_;
    }

    private void updateButtonArray(int n) {
        int n2;
        int n3;
        for (n3 = n2 = this.variationButtons_.size(); n3 < n; ++n3) {
            MoveButton moveButton = new MoveButton(this, n3, 0x800010);
            moveButton.createContents(this.selector_);
            this.variationButtons_.add(moveButton);
        }
        for (n3 = n; n3 < this.variationButtons_.size(); ++n3) {
            this.variationButtons_.get(n3).setVisible(false);
        }
    }

    private void setupMoveButton(int n, NodeView nodeView, boolean bl) {
        MoveButton moveButton = this.variationButtons_.get(n);
        moveButton.setSelection(bl);
        String string = this.makeMoveButtonPrefix();
        String string2 = this.makeMoveButtonPostfix(n, nodeView);
        ImageResource imageResource = this.makeMoveButtonImageResource(nodeView);
        moveButton.set(string, imageResource, string2);
        moveButton.setVisible(true);
    }

    private String makeMoveButtonPrefix() {
        String string = "";
        return string;
    }

    private String makeMoveButtonPostfix(int n, NodeView nodeView) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        try {
            Object object;
            Property property = nodeView.getProperty(SgfId.BLACK);
            if (property != null) {
                object = SgfPoint.parseMove(nodeView.getSize(), property.getString());
                string = this.coordinatesLabelProvider_.getMoveLabel((SgfPoint)object);
            }
            if ((property = nodeView.getProperty(SgfId.WHITE)) != null) {
                object = SgfPoint.parseMove(nodeView.getSize(), property.getString());
                string = this.coordinatesLabelProvider_.getMoveLabel((SgfPoint)object);
            }
            stringBuilder.append(string);
            stringBuilder.append(' ');
            object = this.variationLabelProvider_.getVariationLabel(n);
            stringBuilder.append(n == 0 ? LB_REGULAR_PATH.get(object) : LB_ANOTHER_PATH.get(object));
        }
        catch (TypeParseException typeParseException) {
            typeParseException.printStackTrace();
        }
        return stringBuilder.toString();
    }

    private ImageResource makeMoveButtonImageResource(NodeView nodeView) {
        ImageResource imageResource = NodeImage.VNONE;
        Property property = nodeView.getProperty(SgfId.BLACK);
        if (property != null) {
            imageResource = NodeImage.BLACK;
        }
        if ((property = nodeView.getProperty(SgfId.WHITE)) != null) {
            imageResource = NodeImage.WHITE;
        }
        return imageResource;
    }

    void variationChanged(MoveButton moveButton) {
        this.eventBroker_.executeCommand(new SelectVariation(moveButton.getIndex(), true));
    }

    static /* synthetic */ NodeView[] access$602(VariationSelectorPanel variationSelectorPanel, NodeView[] nodeViewArray) {
        variationSelectorPanel.variations_ = nodeViewArray;
        return nodeViewArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Adapter
    implements MouseWheelMonitor,
    GameMonitor,
    EventBrokerMonitor,
    NodeMonitor,
    ContextMonitor {
        private CurrentContext context_ = CurrentContext.nullContext;
        private int variationIndex_;

        private Adapter() {
        }

        @Override
        public boolean mouseWheelRolled(Point point, int n) {
            boolean bl = Swts.isMouseOn(VariationSelectorPanel.this.selector_);
            for (MoveButton moveButton : VariationSelectorPanel.this.variationButtons_) {
                bl |= Swts.isMouseOn(moveButton.getControl());
            }
            if (!bl) {
                return false;
            }
            if (VariationSelectorPanel.this.variations_.length == 0) {
                return true;
            }
            int n2 = this.variationIndex_;
            this.variationIndex_ = Objects.preventOverRange(this.variationIndex_ + n, 0, VariationSelectorPanel.this.variations_.length - 1);
            if (n2 == this.variationIndex_) {
                return true;
            }
            VariationSelectorPanel.this.eventBroker_.executeCommand(new SelectVariation(this.variationIndex_, true));
            return true;
        }

        @Override
        public void update(RgtProxy rgtProxy) {
            ArgumentChecker.throwIfNull((Object)rgtProxy);
            this.context_ = rgtProxy.getContext();
            VariationSelectorPanel.this.nodeList_ = rgtProxy.getNodeList();
        }

        @Override
        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            VariationSelectorPanel.this.eventBroker_.removeView(VariationSelectorPanel.this);
            VariationSelectorPanel.this.eventBroker_ = eventBroker;
            VariationSelectorPanel.this.eventBroker_.addView(VariationSelectorPanel.this);
        }

        @Override
        public void currentChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (VariationSelectorPanel.this.selector_ == null) {
                return;
            }
            VariationSelectorPanel.access$602(VariationSelectorPanel.this, nodeView.getVariations());
            this.variationIndex_ = nodeView.getSelectedVariationIndex();
            this.update();
            VariationSelectorPanel.this.selector_.layout();
        }

        private void update() {
            VariationSelectorPanel.this.updateButtonArray(VariationSelectorPanel.this.variations_.length);
            for (int i = 0; i < VariationSelectorPanel.this.variations_.length; ++i) {
                VariationSelectorPanel.this.setupMoveButton(i, VariationSelectorPanel.this.variations_[i], i == this.variationIndex_);
            }
        }

        @Override
        public void attributeChanged(Set<String> set) {
            CoordinatesLabelProvider coordinatesLabelProvider;
            ArgumentChecker.throwIfNull(set);
            if (VariationSelectorPanel.this.selector_ == null) {
                return;
            }
            boolean bl = false;
            if (set.contains(CoordinatesLabelProvider.class.getName()) && !(coordinatesLabelProvider = this.context_.getProvider(CoordinatesLabelProvider.class)).equals(VariationSelectorPanel.this.coordinatesLabelProvider_)) {
                VariationSelectorPanel.this.coordinatesLabelProvider_ = coordinatesLabelProvider;
                bl = true;
            }
            if (bl) {
                this.update();
                VariationSelectorPanel.this.selector_.layout();
            }
        }
    }

    private class GroupListener
    extends KeyAdapter {
        private GroupListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.keyCode | keyEvent.stateMask;
            if (ViewerUtils.toVariationIndex(n, VariationSelectorPanel.this.nodeList_.getCurrentNodeView(), VariationSelectorPanel.this.eventBroker_)) {
                return;
            }
            ViewerUtils.handleSelectNode(n, VariationSelectorPanel.this.nodeList_, VariationSelectorPanel.this.eventBroker_);
        }
    }
}

