/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeViewerFocusCellManager
extends SWTFocusCellManager {
    private static final CellNavigationStrategy TREE_NAVIGATE = new CellNavigationStrategy(){

        public void collapse(ColumnViewer viewer, ViewerCell cellToCollapse, Event event) {
            if (cellToCollapse != null) {
                ((TreeItem)cellToCollapse.getItem()).setExpanded(false);
            }
        }

        public void expand(ColumnViewer viewer, ViewerCell cellToExpand, Event event) {
            if (cellToExpand != null) {
                TreeViewer v = (TreeViewer)viewer;
                v.setExpandedState(v.getTreePathFromItem((Item)cellToExpand.getItem()), true);
            }
        }

        public boolean isCollapseEvent(ColumnViewer viewer, ViewerCell cellToCollapse, Event event) {
            return cellToCollapse != null && ((TreeItem)cellToCollapse.getItem()).getExpanded() && cellToCollapse.getColumnIndex() == 0 && event.keyCode == 0x1000003;
        }

        public boolean isExpandEvent(ColumnViewer viewer, ViewerCell cellToExpand, Event event) {
            return cellToExpand != null && ((TreeItem)cellToExpand.getItem()).getItemCount() > 0 && !((TreeItem)cellToExpand.getItem()).getExpanded() && cellToExpand.getColumnIndex() == 0 && event.keyCode == 0x1000004;
        }
    };

    public TreeViewerFocusCellManager(TreeViewer viewer, FocusCellHighlighter focusDrawingDelegate) {
        super(viewer, focusDrawingDelegate, TREE_NAVIGATE);
    }

    ViewerCell getInitialFocusCell() {
        Tree tree = (Tree)this.getViewer().getControl();
        if (tree.getItemCount() > 0) {
            return this.getViewer().getViewerRowFromItem(tree.getItem(0)).getCell(0);
        }
        return null;
    }
}

