/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.unitarou.io.Ios;
import org.unitarou.jface.Computer;
import org.unitarou.jface.FileNameLabelProvider;
import org.unitarou.jface.FolderListener;
import org.unitarou.jface.FolderSelector;
import org.unitarou.jface.FolderTreeContentProvider;
import org.unitarou.jface.ImageResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.Objects;
import org.unitarou.ml.Message;
import org.unitarou.swt.WidgetContainer;

public class FolderTreeViewer
implements WidgetContainer {
    public static final String KEY_TB_ROOTS = FolderTreeViewer.class.getName() + "#keyTiRoots";
    public static final String KEY_M_ROOTS = FolderTreeViewer.class.getName() + "#keyMRoots";
    private static final Log log_s_ = LogFactory.getLog(FolderTreeViewer.class);
    private static final ImageResource IMG_UP_NAVI = new ImageResource(FolderTreeViewer.class, "upNavi.png");
    private static final ImageResource IMG_UP_NAVI_D = new ImageResource(FolderTreeViewer.class, "upNaviD.png");
    private static final ImageResource IMG_DOWN_NAVI = new ImageResource(FolderTreeViewer.class, "downNavi.png");
    private static final ImageResource IMG_DOWN_NAVI_D = new ImageResource(FolderTreeViewer.class, "downNaviD.png");
    private static final ImageResource IMG_DRIVE = new ImageResource(FolderTreeViewer.class, "drive.png");
    private static final Message NT_TT_CHANGEDRIVE = new Message(FolderTreeViewer.class, "ntTtChangedrive");
    private static final Message NT_TT_UPFOLDER = new Message(FolderTreeViewer.class, "ntTtUpfolder");
    private static final Message NT_TT_DOWNFOLDER = new Message(FolderTreeViewer.class, "ntTtDownfolder");
    private static final Message NT_TITLE_FAILURE_CHANGEDRIVE = new Message(FolderTreeViewer.class, "ntTitleFailureChangedrive");
    private static final Message MSG_FAILURE_CHANGEDRIVE = new Message(FolderTreeViewer.class, "msgFailureChangedrive");
    private File root_ = Ios.getCurrentDirectory();
    private Composite frame_;
    private Menu menu_;
    private ToolItem tiUpNavi_ = null;
    private ToolItem tiDownNavi_ = null;
    private final FolderSelector fsRoot_ = new FolderSelector();
    private TreeViewer treeViewer_ = null;
    private final Set<FolderListener> listeners_ = new HashSet<FolderListener>();
    private File selected_ = this.root_;
    private final FolderTreeContentProvider folderTreeContentProvider_ = new FolderTreeContentProvider();

    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.frame_ = new Composite(composite, 0);
        this.frame_.setLayout(new GridLayout(1, false));
        final ToolBar toolBar = new ToolBar(this.frame_, 0x800000);
        toolBar.setData("widgetKey", KEY_TB_ROOTS);
        this.menu_ = this.createRootsMenu(composite.getShell());
        final ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setToolTipText(NT_TT_CHANGEDRIVE.get());
        toolItem.setImage(IMG_DRIVE.get());
        toolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    Rectangle rectangle = toolItem.getBounds();
                    Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                    point = toolBar.toDisplay(point);
                    FolderTreeViewer.this.menu_.setLocation(point.x, point.y);
                    FolderTreeViewer.this.menu_.setVisible(true);
                }
            }
        });
        this.tiUpNavi_ = new ToolItem(toolBar, 8);
        this.tiUpNavi_.setImage(IMG_UP_NAVI.get());
        this.tiUpNavi_.setDisabledImage(IMG_UP_NAVI_D.get());
        this.tiUpNavi_.addSelectionListener(new UpNaviSelectionListener());
        this.tiDownNavi_ = new ToolItem(toolBar, 8);
        this.tiDownNavi_.setImage(IMG_DOWN_NAVI.get());
        this.tiDownNavi_.setDisabledImage(IMG_DOWN_NAVI_D.get());
        this.tiDownNavi_.addSelectionListener(new DownNaviSelectionListener());
        this.tiDownNavi_.setEnabled(false);
        toolBar.pack();
        this.fsRoot_.createContents(this.frame_);
        this.fsRoot_.addSelectionListener(new FolderSelectionListener());
        this.fsRoot_.getControl().setLayoutData(new GridData(4, 1024, true, false));
        this.treeViewer_ = new TreeViewer(this.frame_, 2820);
        this.treeViewer_.setContentProvider(this.folderTreeContentProvider_);
        this.treeViewer_.setLabelProvider(new FileNameLabelProvider());
        this.treeViewer_.getControl().setLayoutData(new GridData(4, 4, true, true));
        this.treeViewer_.addPostSelectionChangedListener(new ItemSeletionListener());
        this.rootFolderIsChanged();
        return this.frame_;
    }

    private Menu createRootsMenu(Shell shell) {
        RootsSelectionListener rootsSelectionListener = new RootsSelectionListener();
        Menu menu = new Menu(shell, 8);
        menu.setData("widgetKey", KEY_M_ROOTS);
        File[] fileArray = File.listRoots();
        for (File file : fileArray = fileArray == null ? new File[]{} : fileArray) {
            MenuItem menuItem = new MenuItem(menu, 16);
            menuItem.setText(file.getPath());
            menuItem.setData(file);
            menuItem.setImage(IMG_DRIVE.get());
            menuItem.addSelectionListener(rootsSelectionListener);
            if (!this.root_.getPath().startsWith(file.getPath())) continue;
            menuItem.setSelection(true);
        }
        return menu;
    }

    private void rootFolderIsChanged() {
        if (this.treeViewer_ != null) {
            this.treeViewer_.setInput(this.root_ == null ? Computer.instance() : this.root_);
        }
        if (this.root_ == null) {
            this.tiUpNavi_.setEnabled(false);
            this.tiUpNavi_.setToolTipText("");
            this.fsRoot_.setPath("");
            return;
        }
        this.tiUpNavi_.setEnabled(true);
        if (this.root_.getParent() != null) {
            this.tiUpNavi_.setToolTipText(NT_TT_UPFOLDER.get((Object)this.root_.getParent()));
        }
        this.fsRoot_.setPath(this.root_.getAbsolutePath());
        String string = FilenameUtils.getPrefix(this.root_.getAbsolutePath());
        for (MenuItem menuItem : this.menu_.getItems()) {
            String string2 = FilenameUtils.getPrefix(((File)menuItem.getData()).getAbsolutePath());
            if (string != null && string.equalsIgnoreCase(string2)) {
                menuItem.setSelection(true);
                continue;
            }
            menuItem.setSelection(false);
        }
    }

    public void close() {
    }

    public Control getControl() {
        return this.frame_;
    }

    public File getRoot() {
        return this.root_;
    }

    public File getSelected() {
        return this.selected_;
    }

    public void setRoot(File file) {
        if (!Ios.isNormalDirectory(file)) {
            this.root_ = null;
        } else {
            this.root_ = file;
            if (this.root_ != null && !Ios.isChild(this.root_, this.selected_)) {
                this.selected_ = this.root_;
            }
        }
        this.rootFolderIsChanged();
    }

    public void setSelected(File file) {
        ArgumentChecker.throwIfNull((Object)file);
        if (!Ios.isNormalDirectory(file)) {
            log_s_.log(LogLevel.INFO, "Invalid directory is assigned(ignore this): {0}", file);
            return;
        }
        File file2 = this.root_;
        this.selected_ = this.findFolder(file);
        if (this.root_ != null) {
            String string = Ios.calcCommonRoot(this.root_, this.selected_);
            this.root_ = string == null ? this.selected_ : new File(string);
        }
        if (!Objects.equalsIncludeNull(file2, this.root_)) {
            this.rootFolderIsChanged();
        }
        this.treeViewer_.setSelection(new StructuredSelection(file));
    }

    private File findFolder(File file) {
        File[] fileArray;
        File[] fileArray2 = file.listFiles();
        if (fileArray2 != null && fileArray2.length != 0) {
            fileArray = fileArray2;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray[i];
                if (file2.isHidden() || !file2.isDirectory()) continue;
                return file;
            }
        }
        if ((fileArray = file.getParentFile()) == null) {
            return file;
        }
        return fileArray;
    }

    public void setIgnoreDrives(File[] fileArray) {
        ArgumentChecker.throwIfNull((Object)fileArray);
        this.folderTreeContentProvider_.setIgnoreDrives(fileArray);
    }

    public void addListener(FolderListener folderListener) {
        if (folderListener == null) {
            return;
        }
        this.listeners_.add(folderListener);
    }

    public void removeListener(FolderListener folderListener) {
        this.listeners_.remove(folderListener);
    }

    private void selectFolderItem(File file) {
        if (file == null || !file.canRead()) {
            this.tiDownNavi_.setEnabled(false);
            return;
        }
        this.selected_ = file;
        boolean bl = false;
        File[] fileArray = this.selected_.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (File file2 : fileArray) {
            if (!file2.isDirectory() || file2.isHidden()) continue;
            bl = true;
            break;
        }
        this.tiDownNavi_.setEnabled(bl);
        if (bl) {
            this.tiDownNavi_.setToolTipText(NT_TT_DOWNFOLDER.get((Object)this.selected_.getName()));
        }
        for (FolderListener folderListener : this.listeners_) {
            folderListener.folderChanged(this.selected_);
        }
    }

    private class ItemSeletionListener
    implements ISelectionChangedListener {
        private ItemSeletionListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
            File file = (File)iStructuredSelection.getFirstElement();
            FolderTreeViewer.this.selectFolderItem(file);
        }
    }

    private class FolderSelectionListener
    implements SelectionListener {
        private FolderSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelectedImpl();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            this.widgetSelectedImpl();
        }

        private void widgetSelectedImpl() {
            String string = FolderTreeViewer.this.fsRoot_.getPath();
            FolderTreeViewer.this.root_ = string.length() == 0 ? null : new File(string);
            if (FolderTreeViewer.this.root_ != null && !Ios.isChild(FolderTreeViewer.this.root_, FolderTreeViewer.this.selected_)) {
                FolderTreeViewer.this.selectFolderItem(FolderTreeViewer.this.root_);
            }
            FolderTreeViewer.this.rootFolderIsChanged();
            if (!Ios.isReadableDirectory(FolderTreeViewer.this.root_)) {
                for (FolderListener folderListener : FolderTreeViewer.this.listeners_) {
                    folderListener.folderChanged(null);
                }
            }
        }
    }

    private class DownNaviSelectionListener
    extends SelectionAdapter {
        private DownNaviSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (FolderTreeViewer.this.selected_ == null) {
                return;
            }
            FolderTreeViewer.this.root_ = FolderTreeViewer.this.selected_;
            FolderTreeViewer.this.rootFolderIsChanged();
            FolderTreeViewer.this.treeViewer_.setSelection(new StructuredSelection(FolderTreeViewer.this.selected_), true);
            File[] fileArray = FolderTreeViewer.this.selected_.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file : fileArray) {
                if (!Ios.isNormalDirectory(file)) continue;
                FolderTreeViewer.this.treeViewer_.setSelection(new StructuredSelection(file), true);
                break;
            }
        }
    }

    private class UpNaviSelectionListener
    extends SelectionAdapter {
        private UpNaviSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            FolderTreeViewer.this.root_ = FolderTreeViewer.this.root_.getParentFile();
            FolderTreeViewer.this.rootFolderIsChanged();
        }
    }

    private class RootsSelectionListener
    extends SelectionAdapter {
        private RootsSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            File file = (File)selectionEvent.widget.getData();
            if (file.canRead()) {
                FolderTreeViewer.this.root_ = file;
                FolderTreeViewer.this.rootFolderIsChanged();
                FolderTreeViewer.this.selectFolderItem(FolderTreeViewer.this.root_);
                return;
            }
            MenuItem menuItem = (MenuItem)selectionEvent.widget;
            menuItem.setSelection(false);
            Menu menu = menuItem.getParent();
            for (MenuItem menuItem2 : menu.getItems()) {
                if (!menuItem2.getData().equals(FolderTreeViewer.this.root_)) continue;
                menuItem2.setSelection(true);
                break;
            }
            MessageDialog.openWarning(FolderTreeViewer.this.frame_.getShell(), NT_TITLE_FAILURE_CHANGEDRIVE.get(), MSG_FAILURE_CHANGEDRIVE.get((Object)file.getPath()));
        }
    }
}

