/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.parser;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.HashSet;
import java.util.Set;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.sgf.parser.BadCharsetException;
import org.unitarou.sgf.parser.SgfParserReader;

final class NioReader
implements SgfParserReader {
    private static final Log log_s_ = LogFactory.getLog(NioReader.class);
    private final ByteBuffer byteBuffer_;
    private final Charset defaultCharset_;
    private final Set<Charset> triedCharsets_;
    private int rgtStartPos_;
    private CharsetDecoder rgtDecoder_;
    private final CharBuffer charBuffer_;
    private int lineNumber_ = 1;
    private boolean isLastCharacterCR_ = false;
    private int markedLineNubmer_ = -1;
    private boolean markedIsLastCharacterCR_;

    public NioReader(ByteBuffer byteBuffer, Charset charset) {
        ArgumentChecker.throwIfNull((Object)byteBuffer, (Object)charset);
        this.byteBuffer_ = byteBuffer.asReadOnlyBuffer();
        this.byteBuffer_.rewind();
        this.defaultCharset_ = charset;
        this.triedCharsets_ = new HashSet<Charset>(2);
        this.charBuffer_ = CharBuffer.allocate(1);
        this.markRootGameTree();
    }

    public void markRootGameTree() {
        this.rgtStartPos_ = this.byteBuffer_.position();
        this.triedCharsets_.clear();
        this.rgtDecoder_ = this.defaultCharset_.newDecoder();
        this.rgtDecoder_.onMalformedInput(CodingErrorAction.REPLACE);
        this.rgtDecoder_.onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public boolean setCharset(Charset charset) {
        ArgumentChecker.throwIfNull((Object)charset);
        if (this.triedCharsets_.contains(charset)) {
            return false;
        }
        this.logChasetChange(charset);
        this.rgtDecoder_ = charset.newDecoder();
        this.rgtDecoder_.onMalformedInput(CodingErrorAction.REPORT);
        this.rgtDecoder_.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.triedCharsets_.add(charset);
        this.byteBuffer_.rewind();
        this.byteBuffer_.position(this.rgtStartPos_);
        return true;
    }

    private void logChasetChange(Charset charset) {
        if (!log_s_.isEnabled(LogLevel.DEBUG)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.rgtDecoder_ != null) {
            stringBuilder.append(this.rgtDecoder_.charset()).append("->");
        }
        stringBuilder.append(charset);
        log_s_.log(LogLevel.DEBUG, stringBuilder.toString());
    }

    public Charset getCharset() {
        return this.rgtDecoder_.charset();
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset_;
    }

    public int read() throws BadCharsetException {
        if (this.byteBuffer_.position() == this.byteBuffer_.limit()) {
            return -1;
        }
        int n = this.byteBuffer_.position();
        this.charBuffer_.clear();
        CoderResult coderResult = this.rgtDecoder_.decode(this.byteBuffer_, this.charBuffer_, false);
        if (n == this.byteBuffer_.position()) {
            log_s_.log(LogLevel.INFO, "{0}: Skip at line {1}", coderResult.toString(), this.lineNumber_);
            this.byteBuffer_.position(n + 1);
        }
        if (coderResult.isMalformed()) {
            log_s_.log(LogLevel.INFO, "{0}: Malformed at line {1}", coderResult.toString(), this.lineNumber_);
            throw new BadCharsetException();
        }
        char c = this.charBuffer_.get(0);
        this.countLineNumber(c);
        return c;
    }

    public void mark(int n) {
        this.byteBuffer_.mark();
        this.markedLineNubmer_ = this.lineNumber_;
        this.markedIsLastCharacterCR_ = this.isLastCharacterCR_;
    }

    public void reset() {
        this.byteBuffer_.reset();
        this.lineNumber_ = this.markedLineNubmer_;
        this.isLastCharacterCR_ = this.markedIsLastCharacterCR_;
    }

    public int getLineNumber() {
        return this.lineNumber_;
    }

    private void countLineNumber(int n) {
        if (n == 13) {
            if (this.isLastCharacterCR_) {
                ++this.lineNumber_;
            } else {
                this.isLastCharacterCR_ = true;
            }
        } else if (n == 10) {
            ++this.lineNumber_;
            this.isLastCharacterCR_ = false;
        } else {
            if (this.isLastCharacterCR_) {
                ++this.lineNumber_;
            }
            this.isLastCharacterCR_ = false;
        }
    }
}

