/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.sgf.type;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.TypeParseException;
import org.unitarou.sgf.type.TypedString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GameType
extends Enum<GameType>
implements TypedString<GameType>,
NameDisplayable {
    public static final /* enum */ GameType GAME = new GameType("1");
    public static final /* enum */ GameType PROBLEM = new GameType("3");
    public static final /* enum */ GameType DRILL = new GameType("4");
    private static final Log log_s_;
    private static final Messages messages_s_;
    private static final Pattern condition_s_;
    private static final int POS = 0;
    private final int value_;
    private final String typeName_;
    private final String displayNameKey_;
    private static final /* synthetic */ GameType[] $VALUES;

    public static final GameType[] values() {
        return (GameType[])$VALUES.clone();
    }

    public static GameType valueOf(String string) {
        return Enum.valueOf(GameType.class, string);
    }

    public static GameType parse(String string) throws TypeParseException {
        ArgumentChecker.throwIfNull((Object)string);
        Matcher matcher = condition_s_.matcher(string);
        if (!matcher.matches()) {
            throw new TypeParseException("Bad argument value = " + string);
        }
        String string2 = matcher.group(0);
        for (GameType gameType : GameType.values()) {
            if (!gameType.typeName_.equals(string2)) continue;
            return gameType;
        }
        assert (false);
        throw new TypeParseException();
    }

    public static GameType parseQuietly(GameType gameType, int n) {
        ArgumentChecker.throwIfNull((Object)gameType);
        for (GameType gameType2 : EnumSet.allOf(GameType.class)) {
            if (gameType2.value_ != n) continue;
            return gameType2;
        }
        return gameType;
    }

    public static GameType parseQuietly(String string, GameType gameType) {
        ArgumentChecker.throwIfNull((Object)string);
        try {
            return GameType.parse(string);
        }
        catch (TypeParseException typeParseException) {
            log_s_.log(LogLevel.DEBUG, typeParseException, "Unknown value for GameType: {0}", string);
            return gameType;
        }
    }

    public static EnumSet<GameType> parseSetQuietly(String string, EnumSet<GameType> enumSet) {
        ArgumentChecker.throwIfNull((Object)string, enumSet);
        EnumSet<GameType> enumSet2 = EnumSet.noneOf(GameType.class);
        for (int i = 0; i < string.length(); ++i) {
            try {
                char c = string.charAt(i);
                enumSet2.add(GameType.parse(String.valueOf(c)));
                continue;
            }
            catch (TypeParseException typeParseException) {
                log_s_.log(LogLevel.DEBUG, typeParseException, "Unknown value for GameType: {0}", string);
            }
        }
        return enumSet2.isEmpty() ? enumSet : enumSet2;
    }

    public static GameType valueOf(int n) {
        for (GameType gameType : GameType.values()) {
            if (gameType.value_ != n) continue;
            return gameType;
        }
        return null;
    }

    private GameType(String string2) {
        ArgumentChecker.throwIfNull((Object)string2);
        this.typeName_ = string2;
        this.displayNameKey_ = Messages.createKey(this.getClass(), this.typeName_);
        this.value_ = Integer.parseInt(string2);
    }

    @Override
    public boolean acceptable(SgfId sgfId) {
        ArgumentChecker.throwIfNull((Object)sgfId);
        return SgfId.GAME_TYPE.equals(sgfId);
    }

    @Override
    public String getString() {
        return this.typeName_;
    }

    public String toString() {
        return this.displayName();
    }

    @Override
    public String displayName() {
        return messages_s_.get(this.displayNameKey_);
    }

    public int getIntValue() {
        return this.value_;
    }

    static {
        $VALUES = new GameType[]{GAME, PROBLEM, DRILL};
        log_s_ = LogFactory.getLog(GameType.class);
        messages_s_ = Messages.createByPackage(GameType.class);
        condition_s_ = Pattern.compile("1|3|4");
    }
}

