/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.model.board;

import java.util.SortedMap;
import java.util.TreeMap;
import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.SgfId;

public class InheritableMarker {
    private final SortedMap<SgfId, String[]> inheritablePropertyMap_ = new TreeMap<SgfId, String[]>();

    public void set(Property property) {
        if (property == null) {
            return;
        }
        SgfId sgfId = property.sgfId();
        if (!sgfId.propertyType().equals(PropertyType.INHERIT)) {
            return;
        }
        this.inheritablePropertyMap_.remove(property.sgfId());
        this.inheritablePropertyMap_.put(sgfId, property.getStrings());
    }

    public void set(InheritableMarker inheritableMarker) {
        if (inheritableMarker == null) {
            throw new NullArgumentException("inheritableDecoration must not be null");
        }
        this.inheritablePropertyMap_.clear();
        this.inheritablePropertyMap_.putAll(inheritableMarker.inheritablePropertyMap_);
    }

    public void clear() {
        this.inheritablePropertyMap_.clear();
    }

    public String[] get(SgfId sgfId) {
        if (sgfId == null) {
            throw new NullArgumentException("type must not be null");
        }
        String[] stringArray = (String[])this.inheritablePropertyMap_.get(sgfId);
        return this.isEmptyValue(stringArray) ? null : stringArray;
    }

    private boolean isEmptyValue(String[] stringArray) {
        return stringArray == null || stringArray.length == 0 || stringArray.length == 1 && stringArray[0].equals("");
    }
}

