/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.sound;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.Context;
import org.unitarou.yukinoshita.context.ContextListener;
import org.unitarou.yukinoshita.context.CurrentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SoundEffect
extends Enum<SoundEffect> {
    public static final /* enum */ SoundEffect MOVE = new SoundEffect("move.wav");
    public static final /* enum */ SoundEffect CORRECT = new SoundEffect("correct.wav");
    public static final /* enum */ SoundEffect ONE_STEP_SHORT = new SoundEffect("oneStepShort.wav");
    public static final /* enum */ SoundEffect MISTAKE = new SoundEffect("mistake.wav");
    private static final Log log_s_;
    private static volatile boolean isMute_s_;
    private static final ContextListener listener_s_;
    private final String resourceName_;
    private final List<File> files_;
    private int index_;
    private Clip clip_;
    private boolean isInitialized_;
    private static final /* synthetic */ SoundEffect[] $VALUES;

    public static final SoundEffect[] values() {
        return (SoundEffect[])$VALUES.clone();
    }

    public static SoundEffect valueOf(String string) {
        return Enum.valueOf(SoundEffect.class, string);
    }

    private static void updateMuteStatus() {
        CurrentContext currentContext = Yukinoshita.context(null);
        SoundEffect.setMute(currentContext.getAttribute(Context.ENABLE_SOUND_EFFECT) == false);
    }

    private static void shutdown() {
        for (SoundEffect soundEffect : SoundEffect.values()) {
            soundEffect.closeClip();
        }
    }

    public static boolean isMute() {
        return isMute_s_;
    }

    public static void setMute(boolean bl) {
        for (SoundEffect soundEffect : SoundEffect.values()) {
            soundEffect.changeMuteMode(bl);
        }
        isMute_s_ = bl;
    }

    private SoundEffect(String string2) {
        assert (string2 != null);
        this.resourceName_ = string2;
        this.files_ = new ArrayList<File>(1);
        this.index_ = -1;
        this.clip_ = null;
        this.isInitialized_ = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void createClip() {
        this.isInitialized_ = true;
        InputStream inputStream = null;
        try {
            inputStream = this.index_ == -1 ? SoundEffect.class.getResourceAsStream(this.resourceName_) : new FileInputStream(this.files_.get(this.index_));
        }
        catch (FileNotFoundException fileNotFoundException) {
            log_s_.log(LogLevel.ERROR, fileNotFoundException.getLocalizedMessage());
        }
        if (inputStream == null) {
            log_s_.log(LogLevel.WARN, "Can''t get inputstream: {0}", this.index_ < 0 ? this.resourceName_ : (Serializable)this.files_.get(this.index_));
            return;
        }
        try {
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
            AudioFormat audioFormat = audioInputStream.getFormat();
            DataLine.Info info = new DataLine.Info(Clip.class, audioFormat);
            if (this.clip_ != null) {
                this.clip_.close();
            }
            this.clip_ = (Clip)AudioSystem.getLine(info);
            this.clip_.open(audioInputStream);
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            log_s_.log(LogLevel.WARN, unsupportedAudioFileException.getLocalizedMessage());
            this.clip_ = null;
        }
        catch (IOException iOException) {
            log_s_.log(LogLevel.WARN, iOException.getLocalizedMessage());
            this.clip_ = null;
        }
        catch (LineUnavailableException lineUnavailableException) {
            log_s_.log(LogLevel.WARN, lineUnavailableException.getLocalizedMessage());
            this.clip_ = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            log_s_.log(LogLevel.WARN, illegalArgumentException.getLocalizedMessage());
            this.clip_ = null;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    private synchronized void closeClip() {
        if (this.clip_ != null && this.clip_.isOpen()) {
            this.clip_.close();
        }
    }

    private synchronized void changeMuteMode(boolean bl) {
        if (this.clip_ == null) {
            return;
        }
        BooleanControl booleanControl = (BooleanControl)this.clip_.getControl(BooleanControl.Type.MUTE);
        if (booleanControl == null) {
            log_s_.log(LogLevel.WARN, "Can''t find Mute control at {0}", new Object[]{this});
            return;
        }
        booleanControl.setValue(bl);
    }

    public synchronized boolean register(File file) throws IOException {
        ArgumentChecker.throwIfNull((Object)file);
        if (!file.canRead()) {
            throw new IOException("Can't read file:" + file);
        }
        if (this.files_.contains(file)) {
            return false;
        }
        this.files_.add(file);
        return true;
    }

    public synchronized void setIndex(int n) {
        if (n < -1 || this.files_.size() <= n) {
            throw new IllegalArgumentException("index is out of range: " + n);
        }
        this.index_ = n;
        this.createClip();
    }

    public synchronized File[] getRegistered() {
        return this.files_.toArray(new File[this.files_.size()]);
    }

    public synchronized void play() {
        if (isMute_s_) {
            return;
        }
        if (!this.isInitialized_) {
            this.createClip();
        }
        if (this.clip_ == null) {
            return;
        }
        if (this.clip_.isRunning()) {
            int n = 100 * this.clip_.getFramePosition() / this.clip_.getFrameLength();
            if (n < 20) {
                return;
            }
            this.clip_.flush();
        }
        this.clip_.setFramePosition(0);
        this.clip_.start();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    static {
        $VALUES = new SoundEffect[]{MOVE, CORRECT, ONE_STEP_SHORT, MISTAKE};
        log_s_ = LogFactory.getLog(SoundEffect.class);
        isMute_s_ = true;
        listener_s_ = new ContextListener(){

            @Override
            public void attributeChanged(Set<String> set) {
                if (set.contains(Context.ENABLE_SOUND_EFFECT.id())) {
                    SoundEffect.updateMuteStatus();
                }
            }
        };
        Context context = Yukinoshita.context();
        context.addListener(listener_s_);
        SoundEffect.updateMuteStatus();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                SoundEffect.shutdown();
            }
        });
    }
}

