/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Collection;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.CollectionFrame;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.jface.dlg.AskSaveDialog;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

public class JFaceCollectionController
extends CollectionController {
    private static final Log log_s_ = LogFactory.getLog(JFaceCollectionController.class);
    private static final Message NT_FILE_SAVE_FAILURE = new Message(JFaceCollectionController.class, "ntFileSaveFailure");

    public JFaceCollectionController(Collection collection, WindowController windowController, CollectionFrame collectionFrame, boolean bl, int n) {
        super(collection, windowController, collectionFrame, bl, n);
    }

    public JFaceCollectionController(Collection collection, WindowController windowController, CollectionFrame collectionFrame, boolean bl, int n, boolean bl2) {
        super(collection, windowController, collectionFrame, bl, n, bl2);
    }

    public boolean doClosing() {
        if (!this.isChanged()) {
            FileManager.instance().close(this.getCollection());
            this.shutdown();
            return true;
        }
        AskSaveDialog askSaveDialog = new AskSaveDialog(null, this);
        int n = askSaveDialog.open();
        switch (n) {
            case 1025: {
                File file = IgoFileDialog.askSaveFile(this.getCollection());
                if (file == null) {
                    return false;
                }
                FileManager.instance().close(this.getCollection());
                this.getCollection().setFile(file);
            }
            case 1024: {
                try {
                    FileManager.instance().save(this.getCollection());
                    FileManager.instance().insertFileHistory(this.getCollection().getFile());
                }
                catch (YukinoshitaException yukinoshitaException) {
                    log_s_.log(LogLevel.ERROR, yukinoshitaException, NT_FILE_SAVE_FAILURE.get());
                    MessageDialog.openError(null, NT_FILE_SAVE_FAILURE.get(), yukinoshitaException.getLocalizedMessage());
                    return false;
                }
            }
            case 1026: {
                FileManager.instance().close(this.getCollection());
                this.getEventBroker().removeView(this);
                this.shutdown();
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }
}

