/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface;

import java.util.HashSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.unitarou.jface.pref.CodecServer;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.yukinoshita.context.ContextValue;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.DefaultContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFaceContext
extends DefaultContext {
    private static final Log log_s_ = LogFactory.getLog(JFaceContext.class);
    private final PreferenceStore preferenceStore_ = new PreferenceStore("./ps.preference");
    private final PropertyChangeListener listener_ = new PropertyChangeListener();

    @Override
    public <T> void setDefault(ContextValue<T> contextValue) {
        super.setDefault(contextValue);
        this.updateDefault(contextValue.id());
    }

    private void updateDefault(String string) {
        Object object = this.getDefault(string);
        if (object == null) {
            return;
        }
        String string2 = this.encode(string, object);
        if (string2 != null) {
            this.preferenceStore_.setDefault(string, string2);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        this.preferenceStore_.removePropertyChangeListener(this.listener_);
        CurrentContext currentContext = this.getCurrent(null);
        for (String string : this.rootKeys()) {
            String string2 = this.encode(string, currentContext.getAttribute(string));
            if (string2 != null) {
                this.preferenceStore_.setValue(string, string2);
            }
            this.updateDefault(string);
        }
        this.preferenceStore_.addPropertyChangeListener(this.listener_);
        return this.preferenceStore_;
    }

    private String encode(String string, Object object) {
        if (object == null) {
            log_s_.log(LogLevel.WARN, "Null value found. key={0}", string);
            return null;
        }
        String string2 = CodecServer.instance().encodeNoCodec(object);
        if (string2 == null) {
            log_s_.log(LogLevel.WARN, "Can''t encode. key={0}, attribute={1}", string, object);
            return null;
        }
        return string2;
    }

    private class PropertyChangeListener
    implements IPropertyChangeListener {
        private PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            CurrentContext currentContext = JFaceContext.this.getCurrent(null);
            String string = propertyChangeEvent.getProperty();
            Object object2 = propertyChangeEvent.getNewValue();
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(string);
            if (CodecServer.instance().isEncodable(object2)) {
                currentContext.setAttribute(string, object2);
                JFaceContext.this.fireAttributeChanged(hashSet);
                return;
            }
            String string2 = object2 != null ? object2.toString() : "";
            Object object3 = currentContext.getAttribute(string);
            if (object3 == null) {
                log_s_.log(LogLevel.WARN, "[BUG] Null value found. key={0}", string);
                return;
            }
            if (object3 instanceof Enum) {
                string2 = object3.getClass().getName() + '@' + string2;
            }
            if ((object = CodecServer.instance().decode(object3, string2)) == null) {
                log_s_.log(LogLevel.WARN, "Can''t decode. key={0}, string={1}", string, string2);
                return;
            }
            currentContext.setAttribute(string, object);
            JFaceContext.this.fireAttributeChanged(hashSet);
        }
    }
}

