/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gm;

import java.io.File;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.unitarou.io.Ios;
import org.unitarou.jface.ColorResource;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Objects;
import org.unitarou.lang.Strings;
import org.unitarou.ml.Message;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.Result;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.Fingerprint;
import org.unitarou.swt.Swts;
import org.unitarou.swt.USashForm;
import org.unitarou.swt.UTable;
import org.unitarou.swt.UTableProvider;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.context.IntContextValue;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.db.FileIndex;
import org.unitarou.yukinoshita.model.db.GameRecord;
import org.unitarou.yukinoshita.view.cmd.OpenFileCommand;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.board.FingerprintPanel;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;
import org.unitarou.yukinoshita.view.monitor.LayoutMonitor;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameRecordPanel
implements YukinoshitaPanel {
    private static final Message FMT_PLAYER = new Message(GameRecordPanel.class, "fmtPlayer");
    private static final ColorResource COL_WINNER = new ColorResource(238, 238, 255);
    private static final IntContextValue LABEL_HEIGHT = new IntContextValue(GameRecordPanel.class, "labelHeight", 0, 25, 120);
    private static final IntContextValue PANEL_HEIGHT = new IntContextValue(GameRecordPanel.class, "panelHeight", 0, 200, 600);
    private final Adapter adapter_ = new Adapter();
    private USashForm frame_;
    private Label lbBlackPlayer_;
    private Label lbWhitePlayer_;
    private final UTable<GameRecord> utGameScore_ = new UTable<GameRecord>(new Provider(), 65540);
    private FingerprintPanel fpPanel_ = new FingerprintPanel();
    private GameRecord selected_ = null;

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void close() {
    }

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = SwtFactory.createUSashForm(composite, 512);
        Composite composite2 = new Composite(this.frame_, 0);
        composite2.setLayout(new FillLayout(512));
        this.lbBlackPlayer_ = new Label(composite2, 16384);
        this.lbWhitePlayer_ = new Label(composite2, 16384);
        final Table table = this.utGameScore_.createContents(this.frame_);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GameRecordPanel.this.update(table.getSelectionIndex());
            }
        });
        table.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                GameRecordPanel.this.openFile(table.getSelectionIndex());
            }
        });
        Swts.defeatMouseWheel(table);
        this.fpPanel_.createContents(this.frame_);
        this.frame_.setWeights(new int[]{-this.adapter_.labelHeight_, 1, -this.adapter_.panelHeight_});
        return this.frame_;
    }

    private void update(int n) {
        if (n < 0 || this.utGameScore_.size() <= n) {
            this.selected_ = null;
            this.fpPanel_.setFingerprint(new Fingerprint(SgfSize.DEFAULT, GameType.GAME));
            return;
        }
        this.selected_ = this.utGameScore_.getRecords().get(n);
        Fingerprint fingerprint = new Fingerprint(SgfSize.create(this.selected_.getWidth(), this.selected_.getHeight()), GameType.valueOf(this.selected_.getGameType()));
        fingerprint.setBytes(this.selected_.getFingerprint());
        this.fpPanel_.setFingerprint(fingerprint);
    }

    private void openFile(int n) {
        if (n < 0 || this.utGameScore_.size() <= n) {
            return;
        }
        GameRecord gameRecord = this.utGameScore_.getRecords().get(n);
        FileIndex fileIndex = DatabaseManager.instance().selectFile(gameRecord.getFileId());
        File file = new File(fileIndex.getPath());
        if (Ios.isNormalFile(file)) {
            OpenFileCommand openFileCommand = new OpenFileCommand(file, gameRecord.getFileOrder());
            this.adapter_.eventBroker_.executeCommand(openFileCommand);
        }
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    public void update(RootGameTree rootGameTree) {
        ArgumentChecker.throwIfNull((Object)rootGameTree);
        String string = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PLAYER_BLACK);
        String string2 = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PLAYER_WHITE);
        List<GameRecord> list = DatabaseManager.instance().selectGameScore(string, string2);
        this.utGameScore_.clear();
        this.utGameScore_.addAll(list);
        this.utGameScore_.packColumns();
        this.utGameScore_.extendColumns();
        this.updatePlayerLabel(list, string, string2);
    }

    private void updatePlayerLabel(List<GameRecord> list, String string, String string2) {
        int n = 0;
        int n2 = 0;
        for (GameRecord gameRecord : list) {
            SgfColor sgfColor = GameRecordPanel.getWinner(gameRecord);
            if (sgfColor == null) continue;
            if (Objects.equalsIncludeNull(gameRecord.getPlayerBlack(), string)) {
                if (sgfColor.equals(SgfColor.BLACK)) {
                    ++n;
                    continue;
                }
                ++n2;
                continue;
            }
            if (sgfColor.equals(SgfColor.WHITE)) {
                ++n;
                continue;
            }
            ++n2;
        }
        this.lbBlackPlayer_.setText(FMT_PLAYER.get(string, list.size(), n, n2));
        this.lbWhitePlayer_.setText(FMT_PLAYER.get(string2, list.size(), n2, n));
    }

    private static SgfColor getWinner(GameRecord gameRecord) {
        Result result = Result.parse(Strings.nullToEmpty(gameRecord.getResult()));
        return result.getArchetype().getWinner();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Provider
    implements UTableProvider<GameRecord> {
        private Provider() {
        }

        @Override
        public int getColumnSize() {
            return 4;
        }

        @Override
        public boolean[] getSotableColums() {
            return new boolean[]{true, true, true, true};
        }

        @Override
        public void setup(TableColumn[] tableColumnArray) {
            tableColumnArray[0].setText(SgfId.DATE.displayName());
            tableColumnArray[1].setText(SgfId.PLAYER_BLACK.displayName());
            tableColumnArray[2].setText(SgfId.PLAYER_WHITE.displayName());
            tableColumnArray[3].setText(SgfId.RESULT.displayName());
        }

        @Override
        public int compareTo(GameRecord gameRecord, GameRecord gameRecord2, int n) {
            switch (n) {
                case 0: {
                    return Objects.compateIncludeNull(gameRecord.getDate(), gameRecord2.getDate());
                }
                case 1: {
                    return Objects.compateIncludeNull(gameRecord.getPlayerBlack(), gameRecord2.getPlayerBlack());
                }
                case 2: {
                    return Objects.compateIncludeNull(gameRecord.getPlayerWhite(), gameRecord2.getPlayerWhite());
                }
                case 3: {
                    return Objects.compateIncludeNull(gameRecord.getResult(), gameRecord2.getResult());
                }
            }
            return 0;
        }

        @Override
        public void set(TableItem tableItem, GameRecord gameRecord) {
            SgfColor sgfColor = GameRecordPanel.getWinner(gameRecord);
            tableItem.setText(0, Strings.nullToEmpty(gameRecord.getDate()));
            this.getPlayerBlack(tableItem, gameRecord, sgfColor);
            this.getPlayerWhite(tableItem, gameRecord, sgfColor);
            tableItem.setText(3, Strings.nullToEmpty(gameRecord.getResult()));
        }

        private void getPlayerBlack(TableItem tableItem, GameRecord gameRecord, SgfColor sgfColor) {
            String string = Strings.nullToEmpty(gameRecord.getPlayerBlack());
            tableItem.setText(1, string);
            if (SgfColor.BLACK.equals(sgfColor)) {
                tableItem.setBackground(1, COL_WINNER.get());
            }
        }

        private void getPlayerWhite(TableItem tableItem, GameRecord gameRecord, SgfColor sgfColor) {
            String string = Strings.nullToEmpty(gameRecord.getPlayerWhite());
            tableItem.setText(2, string);
            if (SgfColor.WHITE.equals(sgfColor)) {
                tableItem.setBackground(2, COL_WINNER.get());
            }
        }
    }

    private class Adapter
    implements EventBrokerMonitor,
    MouseWheelMonitor,
    LayoutMonitor {
        private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
        private int labelHeight_ = GameRecordPanel.access$700().defaultInt();
        private int panelHeight_ = GameRecordPanel.access$800().defaultInt();

        private Adapter() {
        }

        public void setEventBroker(EventBroker eventBroker) {
            ArgumentChecker.throwIfNull((Object)eventBroker);
            this.eventBroker_.removeView(GameRecordPanel.this);
            this.eventBroker_ = eventBroker;
            this.eventBroker_.addView(GameRecordPanel.this);
        }

        public boolean mouseWheelRolled(Point point, int n) {
            Table table = GameRecordPanel.this.utGameScore_.getControl();
            if (!Swts.isMouseOn(table)) {
                return false;
            }
            int n2 = table.getSelectionIndex() + n;
            if (n2 < 0) {
                n2 = 0;
            } else if (GameRecordPanel.this.utGameScore_.size() <= n2) {
                n2 = GameRecordPanel.this.utGameScore_.size() - 1;
            }
            table.setSelection(n2);
            GameRecordPanel.this.update(n2);
            return true;
        }

        public void defaultLayout() {
            if (GameRecordPanel.this.frame_ != null) {
                GameRecordPanel.this.frame_.setWeights(new int[]{-LABEL_HEIGHT.defaultInt(), 1, -PANEL_HEIGHT.defaultInt()});
            }
        }

        public void loadLayout() {
            CurrentContext currentContext = Yukinoshita.context(null);
            this.labelHeight_ = currentContext.getInteger(LABEL_HEIGHT);
            this.panelHeight_ = currentContext.getInteger(PANEL_HEIGHT);
            if (GameRecordPanel.this.frame_ != null) {
                GameRecordPanel.this.frame_.setWeights(new int[]{-this.labelHeight_, 1, -this.panelHeight_});
            }
        }

        public void saveLayout() {
            if (GameRecordPanel.this.frame_ == null) {
                return;
            }
            CurrentContext currentContext = Yukinoshita.context(null);
            this.labelHeight_ = ((GameRecordPanel)GameRecordPanel.this).lbBlackPlayer_.getParent().getSize().y;
            this.panelHeight_ = ((GameRecordPanel)GameRecordPanel.this).fpPanel_.getControl().getSize().y;
            currentContext.setInteger(LABEL_HEIGHT.id(), this.labelHeight_);
            currentContext.setInteger(PANEL_HEIGHT.id(), this.panelHeight_);
        }
    }
}

