/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeDragSourceEffect
extends DragSourceEffect {
    Image dragSourceImage = null;

    public TreeDragSourceEffect(Tree tree) {
        super(tree);
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.image = this.getDragSourceImage(dragSourceEvent);
    }

    Image getDragSourceImage(DragSourceEvent dragSourceEvent) {
        if (this.dragSourceImage != null) {
            this.dragSourceImage.dispose();
        }
        this.dragSourceImage = null;
        Tree tree = (Tree)this.control;
        TreeItem[] treeItemArray = tree.getSelection();
        if (treeItemArray.length == 0) {
            return null;
        }
        int n = OS.SendMessage(tree.handle, 4360, 0, 0);
        if (n != 0) {
            int n2 = Math.min(treeItemArray.length, 10);
            Rectangle rectangle = treeItemArray[0].getBounds(0);
            int n3 = 1;
            while (n3 < n2) {
                rectangle = rectangle.union(treeItemArray[n3].getBounds(0));
                ++n3;
            }
            n3 = OS.GetDC(0);
            int n4 = OS.CreateCompatibleDC(n3);
            int n5 = OS.CreateCompatibleBitmap(n3, rectangle.width, rectangle.height);
            int n6 = OS.SelectObject(n4, n5);
            RECT rECT = new RECT();
            rECT.right = rectangle.width;
            rECT.bottom = rectangle.height;
            int n7 = OS.GetStockObject(0);
            OS.FillRect(n4, rECT, n7);
            int n8 = 0;
            while (n8 < n2) {
                TreeItem treeItem = treeItemArray[n8];
                Rectangle rectangle2 = treeItem.getBounds(0);
                int n9 = OS.SendMessage(tree.handle, 4370, 0, treeItem.handle);
                OS.ImageList_Draw(n9, 0, n4, rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, 4);
                OS.ImageList_Destroy(n9);
                ++n8;
            }
            OS.SelectObject(n4, n6);
            OS.DeleteDC(n4);
            OS.ReleaseDC(0, n3);
            Display display = tree.getDisplay();
            this.dragSourceImage = Image.win32_new(display, 0, n5);
            return this.dragSourceImage;
        }
        return null;
    }
}

