/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_DIGITSUBSTITUTE;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        int[] nArray = new int[1];
        OS.OleInitialize(0);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0, 1, IID_IMLangFontLink2, nArray) == 0) {
            this.mLangFontLink2 = nArray[0];
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void breakRun(StyleItem styleItem) {
        if (styleItem.psla != 0) {
            return;
        }
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n = OS.GetProcessHeap();
        styleItem.psla = OS.HeapAlloc(n, 8, SCRIPT_LOGATTR.sizeof * cArray.length);
        if (styleItem.psla == 0) {
            SWT.error(2);
        }
        OS.ScriptBreak(cArray, cArray.length, styleItem.analysis, styleItem.psla);
    }

    void checkItem(int n, StyleItem styleItem) {
        if (styleItem.fallbackFont != 0) {
            LOGFONT lOGFONT;
            LOGFONT lOGFONT2 = lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            if (OS.GetObject(styleItem.fallbackFont, LOGFONT.sizeof, lOGFONT) == 0) {
                styleItem.free();
                OS.SelectObject(n, this.getItemFont(styleItem));
                this.shape(n, styleItem);
            }
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gC) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        if (this.runs != null) {
            return;
        }
        int n5 = gC != null ? gC.handle : this.device.internal_new_GC(null);
        int n6 = OS.CreateCompatibleDC(n5);
        this.allRuns = this.itemize();
        int n7 = 0;
        while (n7 < this.allRuns.length - 1) {
            object = this.allRuns[n7];
            OS.SelectObject(n6, this.getItemFont((StyleItem)object));
            this.shape(n6, (StyleItem)object);
            ++n7;
        }
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        object = new SCRIPT_PROPERTIES();
        int n8 = this.indent;
        int n9 = 0;
        int n10 = 1;
        int n11 = 0;
        while (n11 < this.allRuns.length - 1) {
            int n12;
            int n13;
            StyleItem styleItem = this.allRuns[n11];
            if (styleItem.length == 1) {
                n4 = this.segmentsText.charAt(styleItem.start);
                switch (n4) {
                    case 9: {
                        styleItem.tab = true;
                        if (this.tabs == null) break;
                        n3 = this.tabs.length;
                        n13 = 0;
                        while (n13 < n3) {
                            if (this.tabs[n13] > n8) {
                                styleItem.width = this.tabs[n13] - n8;
                                break;
                            }
                            ++n13;
                        }
                        if (n13 != n3) break;
                        n2 = this.tabs[n3 - 1];
                        int n14 = n12 = n3 > 1 ? this.tabs[n3 - 1] - this.tabs[n3 - 2] : this.tabs[0];
                        if (n12 <= 0) break;
                        while (n2 <= n8) {
                            n2 += n12;
                        }
                        styleItem.width = n2 - n8;
                        break;
                    }
                    case 10: {
                        styleItem.lineBreak = true;
                        break;
                    }
                    case 13: {
                        styleItem.lineBreak = true;
                        StyleItem styleItem2 = this.allRuns[n11 + 1];
                        if (styleItem2.length == 0 || this.segmentsText.charAt(styleItem2.start) != '\n') break;
                        ++styleItem.length;
                        styleItem2.free();
                        ++n11;
                    }
                }
            }
            if (this.wrapWidth != -1 && n8 + styleItem.width > this.wrapWidth && !styleItem.tab) {
                StyleItem[] styleItemArray;
                n4 = 0;
                int[] nArray = new int[styleItem.length];
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    nArray[0] = styleItem.width;
                } else {
                    OS.ScriptGetLogicalWidths(styleItem.analysis, styleItem.length, styleItem.glyphCount, styleItem.advances, styleItem.clusters, styleItem.visAttrs, nArray);
                }
                n13 = 0;
                n2 = this.wrapWidth - n8;
                while (n13 + nArray[n4] < n2) {
                    n13 += nArray[n4++];
                }
                n12 = n4;
                int n15 = n11;
                while (n11 >= n9) {
                    this.breakRun(styleItem);
                    while (n4 >= 0) {
                        OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n4 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                        if (sCRIPT_LOGATTR.fSoftBreak || sCRIPT_LOGATTR.fWhiteSpace) break;
                        --n4;
                    }
                    if (n4 == 0 && n11 != n9 && !styleItem.tab && sCRIPT_LOGATTR.fSoftBreak && !sCRIPT_LOGATTR.fWhiteSpace) {
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        n = ((SCRIPT_PROPERTIES)object).langid;
                        styleItemArray = this.allRuns[n11 - 1];
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItemArray.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (((SCRIPT_PROPERTIES)object).langid == n || n == 0 || ((SCRIPT_PROPERTIES)object).langid == 0) {
                            this.breakRun((StyleItem)styleItemArray);
                            OS.MoveMemory(sCRIPT_LOGATTR, styleItemArray.psla + (styleItemArray.length - 1) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                            if (!sCRIPT_LOGATTR.fWhiteSpace) {
                                n4 = -1;
                            }
                        }
                    }
                    if (n4 >= 0 || n11 == n9) break;
                    styleItem = this.allRuns[--n11];
                    n4 = styleItem.length - 1;
                }
                if (n4 == 0 && n11 != n9 && !styleItem.tab) {
                    styleItem = this.allRuns[--n11];
                } else if (n4 <= 0 && n11 == n9) {
                    n11 = n15;
                    styleItem = this.allRuns[n11];
                    n4 = Math.max(1, n12);
                }
                this.breakRun(styleItem);
                while (n4 < styleItem.length) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n4 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                    if (!sCRIPT_LOGATTR.fWhiteSpace) break;
                    ++n4;
                }
                if (n4 > 0 && n4 < styleItem.length) {
                    StyleItem styleItem3 = new StyleItem();
                    styleItem3.start = styleItem.start + n4;
                    styleItem3.length = styleItem.length - n4;
                    styleItem3.style = styleItem.style;
                    styleItem3.analysis = styleItem.analysis;
                    styleItem.free();
                    styleItem.length = n4;
                    OS.SelectObject(n6, this.getItemFont(styleItem));
                    this.shape(n6, styleItem);
                    OS.SelectObject(n6, this.getItemFont(styleItem3));
                    this.shape(n6, styleItem3);
                    styleItemArray = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, styleItemArray, 0, n11 + 1);
                    System.arraycopy(this.allRuns, n11 + 1, styleItemArray, n11 + 2, this.allRuns.length - n11 - 1);
                    this.allRuns = styleItemArray;
                    this.allRuns[n11 + 1] = styleItem3;
                }
                if (n11 != this.allRuns.length - 2) {
                    styleItem.lineBreak = true;
                    styleItem.softBreak = true;
                }
            }
            n8 += styleItem.width;
            if (styleItem.lineBreak) {
                n9 = n11 + 1;
                n8 = styleItem.softBreak ? 0 : this.indent;
                ++n10;
            }
            ++n11;
        }
        n8 = 0;
        this.runs = new StyleItem[n10][];
        this.lineOffset = new int[n10 + 1];
        this.lineY = new int[n10 + 1];
        this.lineWidth = new int[n10];
        n11 = 0;
        int n16 = 0;
        n4 = Math.max(0, this.ascent);
        n3 = Math.max(0, this.descent);
        StyleItem[] styleItemArray = new StyleItem[this.allRuns.length];
        n2 = 0;
        while (n2 < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n2];
            styleItemArray[n11++] = styleItem;
            n8 += styleItem.width;
            n4 = Math.max(n4, styleItem.ascent);
            n3 = Math.max(n3, styleItem.descent);
            if (styleItem.lineBreak || n2 == this.allRuns.length - 1) {
                if (n11 == 1 && n2 == this.allRuns.length - 1) {
                    TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.SelectObject(n6, this.getItemFont(styleItem));
                    OS.GetTextMetrics(n6, tEXTMETRIC);
                    styleItem.ascent = tEXTMETRIC.tmAscent;
                    styleItem.descent = tEXTMETRIC.tmDescent;
                    n4 = Math.max(n4, styleItem.ascent);
                    n3 = Math.max(n3, styleItem.descent);
                }
                this.runs[n16] = new StyleItem[n11];
                System.arraycopy(styleItemArray, 0, this.runs[n16], 0, n11);
                if (this.justify && this.wrapWidth != -1 && styleItem.softBreak && n8 > 0) {
                    if (n16 == 0) {
                        n8 += this.indent;
                    } else {
                        StyleItem[] styleItemArray2 = this.runs[n16 - 1];
                        StyleItem styleItem4 = styleItemArray2[styleItemArray2.length - 1];
                        if (styleItem4.lineBreak && !styleItem4.softBreak) {
                            n8 += this.indent;
                        }
                    }
                    int n17 = OS.GetProcessHeap();
                    n = 0;
                    int n18 = 0;
                    while (n18 < this.runs[n16].length) {
                        StyleItem styleItem5 = this.runs[n16][n18];
                        int n19 = styleItem5.width * this.wrapWidth / n8;
                        if (n19 != styleItem5.width) {
                            styleItem5.justify = OS.HeapAlloc(n17, 8, styleItem5.glyphCount * 4);
                            if (styleItem5.justify == 0) {
                                SWT.error(2);
                            }
                            OS.ScriptJustify(styleItem5.visAttrs, styleItem5.advances, styleItem5.glyphCount, n19 - styleItem5.width, 2, styleItem5.justify);
                            styleItem5.width = n19;
                        }
                        n += styleItem5.width;
                        ++n18;
                    }
                    n8 = n;
                }
                this.lineWidth[n16] = n8;
                StyleItem styleItem6 = this.runs[n16][n11 - 1];
                n = styleItem6.start + styleItem6.length;
                this.runs[n16] = this.reorder(this.runs[n16], n2 == this.allRuns.length - 1);
                styleItem6 = this.runs[n16][n11 - 1];
                if (styleItem.softBreak && styleItem != styleItem6) {
                    styleItem.lineBreak = false;
                    styleItem.softBreak = false;
                    styleItem6.lineBreak = true;
                    styleItem6.softBreak = true;
                }
                n8 = this.getLineIndent(n16);
                int n20 = 0;
                while (n20 < this.runs[n16].length) {
                    this.runs[n16][n20].x = n8;
                    n8 += this.runs[n16][n20].width;
                    ++n20;
                }
                this.lineY[++n16] = this.lineY[n16 - 1] + n4 + n3 + this.lineSpacing;
                this.lineOffset[n16] = n;
                n8 = 0;
                n11 = 0;
                n4 = Math.max(0, this.ascent);
                n3 = Math.max(0, this.descent);
            }
            ++n2;
        }
        if (n6 != 0) {
            OS.DeleteDC(n6);
        }
        if (gC == null) {
            this.device.internal_dispose_GC(n5, null);
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.mLangFontLink2 != 0) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0;
        }
        OS.OleUninitialize();
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        this.checkLayout();
        this.computeRuns(gC);
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n13 = this.text.length()) == 0 && n5 == 0) {
            return;
        }
        int n14 = gC.handle;
        Rectangle rectangle = gC.getClipping();
        GCData gCData = gC.data;
        int n15 = gCData.gdipGraphics;
        int n16 = gCData.foreground;
        int n17 = gCData.alpha;
        boolean bl = n15 != 0 && (n17 != 255 || gCData.foregroundPattern != null);
        int n18 = 0;
        float[] fArray = null;
        Rect rect = new Rect();
        if (n15 != 0 && !bl) {
            n12 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (n12 == 0) {
                SWT.error(2);
            }
            Gdip.Graphics_GetTransform(n15, n12);
            n11 = gC.identity();
            Gdip.Matrix_Invert(n11);
            Gdip.Matrix_Multiply(n12, n11, 1);
            Gdip.Matrix_delete(n11);
            if (!Gdip.Matrix_IsIdentity(n12)) {
                fArray = new float[6];
                Gdip.Matrix_GetElements(n12, fArray);
            }
            Gdip.Matrix_delete(n12);
            if ((gCData.style & 0x8000000) != 0 && fArray != null) {
                bl = true;
                fArray = null;
            } else {
                Gdip.Graphics_SetPixelOffsetMode(n15, 3);
                n10 = Gdip.Region_new();
                Gdip.Graphics_GetClip(n15, n10);
                if (!Gdip.Region_IsInfinite(n10, n15)) {
                    n18 = Gdip.Region_GetHRGN(n10, n15);
                }
                Gdip.Region_delete(n10);
                Gdip.Graphics_SetPixelOffsetMode(n15, 4);
                n14 = Gdip.Graphics_GetHDC(n15);
            }
        }
        n12 = 0;
        n11 = 0;
        if (bl) {
            gC.checkGC(1);
            n12 = gC.getFgBrush();
        } else {
            n11 = OS.SaveDC(n14);
            if ((gCData.style & 0x8000000) != 0) {
                OS.SetLayout(n14, OS.GetLayout(n14) | 1);
            }
            if (fArray != null) {
                OS.SetGraphicsMode(n14, 2);
                OS.SetWorldTransform(n14, fArray);
            }
            if (n18 != 0) {
                OS.SelectClipRgn(n14, n18);
                OS.DeleteObject(n18);
            }
        }
        int n19 = n10 = n3 <= n4 && n3 != -1 && n4 != -1 ? 1 : 0;
        if (n10 != 0 || (n5 & 0x100000) != 0) {
            n3 = Math.min(Math.max(0, n3), n13 - 1);
            n4 = Math.min(Math.max(0, n4), n13 - 1);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            n3 = this.translateOffset(n3);
            n4 = this.translateOffset(n4);
        }
        RECT rECT = new RECT();
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        if (n10 != 0 || (n5 & 0x100000) != 0) {
            if (bl) {
                n9 = color2.handle;
                n8 = (n17 & 0xFF) << 24 | n9 >> 16 & 0xFF | n9 & 0xFF00 | (n9 & 0xFF) << 16;
                n7 = Gdip.Color_new(n8);
                n20 = Gdip.SolidBrush_new(n7);
                Gdip.Color_delete(n7);
                n6 = color.handle;
                n8 = (n17 & 0xFF) << 24 | n6 >> 16 & 0xFF | n6 & 0xFF00 | (n6 & 0xFF) << 16;
                n7 = Gdip.Color_new(n8);
                n22 = Gdip.SolidBrush_new(n7);
                n21 = Gdip.Pen_new(n22, 1.0f);
                Gdip.Color_delete(n7);
            } else {
                n20 = OS.CreateSolidBrush(color2.handle);
                n21 = OS.CreatePen(0, 1, color.handle);
            }
        }
        n9 = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        OS.SetBkMode(n14, 1);
        n8 = 0;
        while (n8 < this.runs.length) {
            int n23;
            int n24;
            n7 = n + this.getLineIndent(n8);
            n6 = n2 + this.lineY[n8];
            StyleItem[] styleItemArray = this.runs[n8];
            int n25 = this.lineY[n8 + 1] - this.lineY[n8];
            if (n5 != 0 && (n10 != 0 || (n5 & 0x100000) != 0)) {
                n24 = 0;
                if (n8 == this.runs.length - 1 && (n5 & 0x100000) != 0) {
                    n24 = 1;
                } else {
                    StyleItem styleItem = styleItemArray[styleItemArray.length - 1];
                    if (styleItem.lineBreak && !styleItem.softBreak) {
                        if (n3 <= styleItem.start && styleItem.start <= n4) {
                            n24 = 1;
                        }
                    } else {
                        n23 = styleItem.start + styleItem.length - 1;
                        if (n3 <= n23 && n23 < n4 && (n5 & 0x10000) != 0) {
                            n24 = 1;
                        }
                    }
                }
                if (n24 != 0) {
                    int n26 = (n5 & 0x10000) != 0 ? (OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF) : (n25 - this.lineSpacing) / 3;
                    if (bl) {
                        Gdip.Graphics_FillRectangle(n15, n20, n7 + this.lineWidth[n8], n6, n26, n25 - this.lineSpacing);
                    } else {
                        OS.SelectObject(n14, n20);
                        OS.PatBlt(n14, n7 + this.lineWidth[n8], n6, n26, n25 - this.lineSpacing, 15728673);
                    }
                }
            }
            if (n7 <= rectangle.x + rectangle.width && n7 + this.lineWidth[n8] >= rectangle.x) {
                int n27;
                int n28;
                int n29;
                int n30;
                boolean bl2;
                int n31;
                StyleItem styleItem;
                n24 = Math.max(0, this.ascent);
                int n32 = 0;
                while (n32 < styleItemArray.length) {
                    n24 = Math.max(n24, styleItemArray[n32].ascent);
                    ++n32;
                }
                n32 = n7;
                n23 = 0;
                while (n23 < styleItemArray.length) {
                    styleItem = styleItemArray[n23];
                    if (styleItem.length != 0) {
                        if (n7 > rectangle.x + rectangle.width) break;
                        if (n7 + styleItem.width >= rectangle.x && (!styleItem.lineBreak || styleItem.softBreak)) {
                            n31 = styleItem.start + styleItem.length - 1;
                            boolean bl3 = bl2 = n10 != 0 && n3 <= styleItem.start && n4 >= n31;
                            if (bl2) {
                                if (bl) {
                                    Gdip.Graphics_FillRectangle(n15, n20, n7, n6, styleItem.width, n25 - this.lineSpacing);
                                } else {
                                    OS.SelectObject(n14, n20);
                                    OS.PatBlt(n14, n7, n6, styleItem.width, n25 - this.lineSpacing, 15728673);
                                }
                            } else {
                                int n33;
                                int n34;
                                if (styleItem.style != null && styleItem.style.background != null) {
                                    n30 = styleItem.style.background.handle;
                                    n29 = n6 + (n24 - styleItem.ascent);
                                    if (bl) {
                                        n28 = (n17 & 0xFF) << 24 | n30 >> 16 & 0xFF | n30 & 0xFF00 | (n30 & 0xFF) << 16;
                                        n34 = Gdip.Color_new(n28);
                                        n33 = Gdip.SolidBrush_new(n34);
                                        Gdip.Graphics_FillRectangle(n15, n33, n7, n29, styleItem.width, styleItem.ascent + styleItem.descent);
                                        Gdip.Color_delete(n34);
                                        Gdip.SolidBrush_delete(n33);
                                    } else {
                                        n28 = OS.CreateSolidBrush(n30);
                                        n34 = OS.SelectObject(n14, n28);
                                        OS.PatBlt(n14, n7, n29, styleItem.width, styleItem.ascent + styleItem.descent, 15728673);
                                        OS.SelectObject(n14, n34);
                                        OS.DeleteObject(n28);
                                    }
                                }
                                int n35 = n30 = n10 != 0 && n3 <= n31 && styleItem.start <= n4 ? 1 : 0;
                                if (n30 != 0) {
                                    n29 = Math.max(n3, styleItem.start) - styleItem.start;
                                    n28 = Math.min(n4, n31) - styleItem.start;
                                    n34 = styleItem.length;
                                    n33 = styleItem.glyphCount;
                                    int[] nArray = new int[1];
                                    int n36 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                                    OS.ScriptCPtoX(n29, false, n34, n33, styleItem.clusters, styleItem.visAttrs, n36, styleItem.analysis, nArray);
                                    n27 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                    rECT.left = n7 + n27;
                                    rECT.top = n6;
                                    OS.ScriptCPtoX(n28, true, n34, n33, styleItem.clusters, styleItem.visAttrs, n36, styleItem.analysis, nArray);
                                    n27 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                    rECT.right = n7 + n27;
                                    rECT.bottom = n6 + n25 - this.lineSpacing;
                                    if (bl) {
                                        Gdip.Graphics_FillRectangle(n15, n20, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
                                    } else {
                                        OS.SelectObject(n14, n20);
                                        OS.PatBlt(n14, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
                                    }
                                }
                            }
                        }
                        n7 += styleItem.width;
                    }
                    ++n23;
                }
                n7 = n32;
                n23 = 0;
                while (n23 < styleItemArray.length) {
                    styleItem = styleItemArray[n23];
                    if (styleItem.length != 0) {
                        if (n7 > rectangle.x + rectangle.width) break;
                        if (!(n7 + styleItem.width < rectangle.x || styleItem.tab || styleItem.lineBreak && !styleItem.softBreak || styleItem.style != null && styleItem.style.metrics != null)) {
                            int n37;
                            n31 = styleItem.start + styleItem.length - 1;
                            bl2 = n10 != 0 && n3 <= styleItem.start && n4 >= n31;
                            n30 = n10 != 0 && !bl2 && n3 <= n31 && styleItem.start <= n4 ? 1 : 0;
                            this.checkItem(n14, styleItem);
                            OS.SelectObject(n14, this.getItemFont(styleItem));
                            n29 = n6 + (n24 - styleItem.ascent);
                            if (n30 != 0) {
                                n28 = Math.max(n3, styleItem.start) - styleItem.start;
                                int n38 = Math.min(n4, n31) - styleItem.start;
                                int n39 = styleItem.length;
                                int n40 = styleItem.glyphCount;
                                int[] nArray = new int[1];
                                n27 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                                OS.ScriptCPtoX(n28, false, n39, n40, styleItem.clusters, styleItem.visAttrs, n27, styleItem.analysis, nArray);
                                n37 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                rECT.left = n7 + n37;
                                rECT.top = n6;
                                OS.ScriptCPtoX(n38, true, n39, n40, styleItem.clusters, styleItem.visAttrs, n27, styleItem.analysis, nArray);
                                n37 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                rECT.right = n7 + n37;
                                rECT.bottom = n6 + n25;
                            }
                            if (bl) {
                                int n41;
                                int n42;
                                OS.BeginPath(n14);
                                OS.ScriptTextOut(n14, styleItem.psc, n7, n29, 0, null, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                OS.EndPath(n14);
                                n28 = OS.GetPath(n14, null, null, 0);
                                int[] nArray = new int[n28 * 2];
                                byte[] byArray = new byte[n28];
                                OS.GetPath(n14, nArray, byArray, n28);
                                int n43 = 0;
                                while (n43 < byArray.length) {
                                    int n44 = 0;
                                    n27 = byArray[n43] & 0xFF;
                                    switch (n27 & 0xFFFFFFFE) {
                                        case 6: {
                                            n44 = 0;
                                            break;
                                        }
                                        case 2: {
                                            n44 = 1;
                                            break;
                                        }
                                        case 4: {
                                            n44 = 3;
                                        }
                                    }
                                    if ((n27 & 1) != 0) {
                                        n44 |= 0x80;
                                    }
                                    byArray[n43] = (byte)n44;
                                    ++n43;
                                }
                                n43 = Gdip.GraphicsPath_new(nArray, byArray, n28, 0);
                                if (n43 == 0) {
                                    SWT.error(2);
                                }
                                int n45 = n12;
                                if (bl2) {
                                    n45 = n22;
                                } else if (styleItem.style != null && styleItem.style.foreground != null) {
                                    n27 = styleItem.style.foreground.handle;
                                    n37 = (n17 & 0xFF) << 24 | n27 >> 16 & 0xFF | n27 & 0xFF00 | (n27 & 0xFF) << 16;
                                    n42 = Gdip.Color_new(n37);
                                    n45 = Gdip.SolidBrush_new(n42);
                                    Gdip.Color_delete(n42);
                                }
                                n27 = 0;
                                if (n30 != 0) {
                                    rect.X = rECT.left;
                                    rect.Y = rECT.top;
                                    rect.Width = rECT.right - rECT.left;
                                    rect.Height = rECT.bottom - rECT.top;
                                    n27 = Gdip.Graphics_Save(n15);
                                    Gdip.Graphics_SetClip(n15, rect, 4);
                                }
                                n37 = Gdip.Graphics_GetSmoothingMode(n15);
                                n42 = 0;
                                int n46 = Gdip.Graphics_GetTextRenderingHint(gCData.gdipGraphics);
                                switch (n46) {
                                    case 0: {
                                        n42 = 4;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n42 = 3;
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        n42 = 4;
                                    }
                                }
                                Gdip.Graphics_SetSmoothingMode(n15, n42);
                                int n47 = 0;
                                if ((gCData.style & 0x8000000) != 0) {
                                    n47 = Gdip.Graphics_Save(n15);
                                    Gdip.Graphics_ScaleTransform(n15, -1.0f, 1.0f, 0);
                                    Gdip.Graphics_TranslateTransform(n15, -2 * n7 - styleItem.width, 0.0f, 0);
                                }
                                Gdip.Graphics_FillPath(n15, n45, n43);
                                if ((gCData.style & 0x8000000) != 0) {
                                    Gdip.Graphics_Restore(n15, n47);
                                }
                                Gdip.Graphics_SetSmoothingMode(n15, n37);
                                if (styleItem.style != null && (styleItem.style.underline || styleItem.style.strikeout)) {
                                    int n48;
                                    n41 = n10 != 0 ? n21 : Gdip.Pen_new(n45, 1.0f);
                                    Gdip.Graphics_SetPixelOffsetMode(n15, 3);
                                    if (styleItem.style.underline) {
                                        n48 = n6 + n24 + 1 - styleItem.style.rise;
                                        Gdip.Graphics_DrawLine(n15, n41, n7, n48, n7 + styleItem.width, n48);
                                    }
                                    if (styleItem.style.strikeout) {
                                        n48 = n29 + styleItem.leading + (styleItem.ascent - styleItem.style.rise) / 2;
                                        Gdip.Graphics_DrawLine(n15, n41, n7, n48, n7 + styleItem.width, n48);
                                    }
                                    if (n41 != n21) {
                                        Gdip.Pen_delete(n41);
                                    }
                                    Gdip.Graphics_SetPixelOffsetMode(n15, 4);
                                }
                                if (n30 != 0) {
                                    Gdip.Graphics_Restore(n15, n27);
                                    n27 = Gdip.Graphics_Save(n15);
                                    Gdip.Graphics_SetClip(n15, rect, 1);
                                    Gdip.Graphics_SetSmoothingMode(n15, n42);
                                    Gdip.Graphics_FillPath(n15, n22, n43);
                                    Gdip.Graphics_SetSmoothingMode(n15, n37);
                                    if (styleItem.style != null && (styleItem.style.underline || styleItem.style.strikeout)) {
                                        Gdip.Graphics_SetPixelOffsetMode(n15, 3);
                                        if (styleItem.style.underline) {
                                            n41 = n6 + n24 + 1 - styleItem.style.rise;
                                            Gdip.Graphics_DrawLine(n15, n21, rECT.left, n41, rECT.right, n41);
                                        }
                                        if (styleItem.style.strikeout) {
                                            n41 = n29 + styleItem.leading + (styleItem.ascent - styleItem.style.rise) / 2;
                                            Gdip.Graphics_DrawLine(n15, n21, rECT.left, n41, rECT.right, n41);
                                        }
                                        Gdip.Graphics_SetPixelOffsetMode(n15, 4);
                                    }
                                    Gdip.Graphics_Restore(n15, n27);
                                }
                                Gdip.GraphicsPath_delete(n43);
                                if (n45 != n22 && n45 != n12) {
                                    Gdip.SolidBrush_delete(n45);
                                }
                            } else {
                                n28 = n16;
                                if (bl2) {
                                    n28 = color.handle;
                                } else if (styleItem.style != null && styleItem.style.foreground != null) {
                                    n28 = styleItem.style.foreground.handle;
                                }
                                OS.SetTextColor(n14, n28);
                                OS.ScriptTextOut(n14, styleItem.psc, n7 + n9, n29, 0, null, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                if (styleItem.style != null && (styleItem.style.underline || styleItem.style.strikeout)) {
                                    int n49 = n10 != 0 && n28 == color.handle ? n21 : OS.CreatePen(0, 1, n28);
                                    int n50 = OS.SelectObject(n14, n49);
                                    if (styleItem.style.underline) {
                                        int n51 = n6 + n24 + 1 - styleItem.style.rise;
                                        OS.MoveToEx(n14, n7, n51, 0);
                                        OS.LineTo(n14, n7 + styleItem.width, n51);
                                    }
                                    if (styleItem.style.strikeout) {
                                        int n52 = n29 + styleItem.leading + (styleItem.ascent - styleItem.style.rise) / 2;
                                        OS.MoveToEx(n14, n7, n52, 0);
                                        OS.LineTo(n14, n7 + styleItem.width, n52);
                                    }
                                    OS.SelectObject(n14, n50);
                                    if (n10 == 0 || n28 != color.handle) {
                                        OS.DeleteObject(n49);
                                    }
                                }
                                if (n30 != 0 && n28 != color.handle) {
                                    OS.SetTextColor(n14, color.handle);
                                    OS.ScriptTextOut(n14, styleItem.psc, n7 + n9, n29, 4, rECT, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                    if (styleItem.style != null && (styleItem.style.underline || styleItem.style.strikeout)) {
                                        int n53 = OS.SelectObject(n14, n21);
                                        if (styleItem.style.underline) {
                                            int n54 = n6 + n24 + 1 - styleItem.style.rise;
                                            OS.MoveToEx(n14, rECT.left, n54, 0);
                                            OS.LineTo(n14, rECT.right, n54);
                                        }
                                        if (styleItem.style.strikeout) {
                                            int n55 = n29 + styleItem.leading + (styleItem.ascent - styleItem.style.rise) / 2;
                                            OS.MoveToEx(n14, rECT.left, n55, 0);
                                            OS.LineTo(n14, rECT.right, n55);
                                        }
                                        OS.SelectObject(n14, n53);
                                    }
                                }
                            }
                        }
                        n7 += styleItem.width;
                    }
                    ++n23;
                }
            }
            ++n8;
        }
        if (bl) {
            if (n20 != 0) {
                Gdip.SolidBrush_delete(n20);
            }
            if (n22 != 0) {
                Gdip.SolidBrush_delete(n22);
            }
            if (n21 != 0) {
                Gdip.Pen_delete(n21);
            }
        } else {
            OS.RestoreDC(n14, n11);
            if (n15 != 0) {
                Gdip.Graphics_ReleaseHDC(n15, n14);
            }
            if (n20 != 0) {
                OS.DeleteObject(n20);
            }
            if (n21 != 0) {
                OS.DeleteObject(n21);
            }
        }
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        int n = 0;
        while (n < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n];
            styleItem.free();
            ++n;
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int n = 0;
        if (this.wrapWidth != -1) {
            n = this.wrapWidth;
        } else {
            int n2 = 0;
            while (n2 < this.runs.length) {
                n = Math.max(n, this.lineWidth[n2] + this.getLineIndent(n2));
                ++n2;
            }
        }
        return new Rectangle(0, 0, n, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int n, int n2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n3 - 1);
        n2 = Math.min(Math.max(0, n2), n3 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        boolean bl = (this.orientation & 0x4000000) != 0;
        int n8 = 0;
        while (n8 < this.allRuns.length - 1) {
            StyleItem styleItem = this.allRuns[n8];
            int n9 = styleItem.start + styleItem.length;
            if (n9 > n) {
                int n10;
                Object object;
                int n11;
                if (styleItem.start > n2) break;
                int n12 = styleItem.x;
                int n13 = styleItem.x + styleItem.width;
                if (styleItem.start <= n && n < n9) {
                    n11 = 0;
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n11 = object.width * (n - styleItem.start);
                    } else if (!styleItem.tab) {
                        object = new int[1];
                        n10 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                        OS.ScriptCPtoX(n - styleItem.start, false, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, n10, styleItem.analysis, object);
                        int n14 = n11 = bl ? styleItem.width - object[0] : object[0];
                    }
                    if (styleItem.analysis.fRTL ^ bl) {
                        n13 = styleItem.x + n11;
                    } else {
                        n12 = styleItem.x + n11;
                    }
                }
                if (styleItem.start <= n2 && n2 < n9) {
                    n11 = styleItem.width;
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n11 = object.width * (n2 - styleItem.start + 1);
                    } else if (!styleItem.tab) {
                        object = new int[1];
                        n10 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                        OS.ScriptCPtoX(n2 - styleItem.start, true, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, n10, styleItem.analysis, object);
                        int n15 = n11 = bl ? styleItem.width - object[0] : object[0];
                    }
                    if (styleItem.analysis.fRTL ^ bl) {
                        n12 = styleItem.x + n11;
                    } else {
                        n13 = styleItem.x + n11;
                    }
                }
                n11 = 0;
                while (n11 < this.runs.length && this.lineOffset[n11 + 1] <= styleItem.start) {
                    ++n11;
                }
                n4 = Math.min(n4, n12);
                n5 = Math.max(n5, n13);
                n6 = Math.min(n6, this.lineY[n11]);
                n7 = Math.max(n7, this.lineY[n11 + 1] - this.lineSpacing);
            }
            ++n8;
        }
        return new Rectangle(n4, n6, n5 - n4, n7 - n6);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    int getItemFont(StyleItem styleItem) {
        if (styleItem.fallbackFont != 0) {
            return styleItem.fallbackFont;
        }
        if (styleItem.style != null && styleItem.style.font != null) {
            return styleItem.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont;
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 1;
        while (n3 < this.allRuns.length) {
            if (this.allRuns[n3].start > n) {
                return this.allRuns[n3 - 1].analysis.s.uBidiLevel;
            }
            ++n3;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = this.getLineIndent(n);
        int n3 = this.lineY[n];
        int n4 = this.lineWidth[n];
        int n5 = this.lineY[n + 1] - n3 - this.lineSpacing;
        return new Rectangle(n2, n3, n4, n5);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int n) {
        StyleItem[] styleItemArray;
        int n2 = 0;
        if (n == 0) {
            n2 = this.indent;
        } else {
            StyleItem[] styleItemArray2 = this.runs[n - 1];
            styleItemArray = styleItemArray2[styleItemArray2.length - 1];
            if (styleItemArray.lineBreak && !styleItemArray.softBreak) {
                n2 = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean bl = true;
            if (this.justify) {
                styleItemArray = this.runs[n];
                if (styleItemArray[styleItemArray.length - 1].softBreak) {
                    bl = false;
                }
            }
            if (bl) {
                int n3 = this.lineWidth[n] + n2;
                switch (this.alignment) {
                    case 0x1000000: {
                        n2 += (this.wrapWidth - n3) / 2;
                        break;
                    }
                    case 131072: {
                        n2 += this.wrapWidth - n3;
                    }
                }
            }
        }
        return n2;
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) {
                return n3;
            }
            ++n3;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (n < 0 || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = this.device.internal_new_GC(null);
        int n3 = OS.CreateCompatibleDC(n2);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.SelectObject(n3, this.font != null ? this.font.handle : this.device.systemFont);
        OS.GetTextMetrics(n3, tEXTMETRIC);
        OS.DeleteDC(n3);
        this.device.internal_dispose_GC(n2, null);
        int n4 = Math.max(tEXTMETRIC.tmAscent, this.ascent);
        int n5 = Math.max(tEXTMETRIC.tmDescent, this.descent);
        int n6 = tEXTMETRIC.tmInternalLeading;
        if (this.text.length() != 0) {
            StyleItem[] styleItemArray = this.runs[n];
            int n7 = 0;
            while (n7 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n7];
                if (styleItem.ascent > n4) {
                    n4 = styleItem.ascent;
                    n6 = styleItem.leading;
                }
                n5 = Math.max(n5, styleItem.descent);
                ++n7;
            }
        }
        tEXTMETRIC.tmAscent = n4;
        tEXTMETRIC.tmDescent = n5;
        tEXTMETRIC.tmHeight = n4 + n5;
        tEXTMETRIC.tmInternalLeading = n6;
        tEXTMETRIC.tmAveCharWidth = 0;
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] nArray = new int[this.lineOffset.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.untranslateOffset(this.lineOffset[n]);
            ++n;
        }
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (n < 0 || n > n2) {
            SWT.error(6);
        }
        n2 = this.segmentsText.length();
        n = this.translateOffset(n);
        int n3 = 0;
        while (n3 < this.runs.length) {
            if (this.lineOffset[n3 + 1] > n) break;
            ++n3;
        }
        n3 = Math.min(n3, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n3];
        Point point = null;
        if (n == n2) {
            point = new Point(this.lineWidth[n3], this.lineY[n3]);
        } else {
            int n4 = 0;
            int n5 = 0;
            while (n5 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n5];
                int n6 = styleItem.start + styleItem.length;
                if (styleItem.start <= n && n < n6) {
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        GlyphMetrics glyphMetrics = styleItem.style.metrics;
                        point = new Point(n4 += glyphMetrics.width * (n - styleItem.start + (bl ? 1 : 0)), this.lineY[n3]);
                        break;
                    }
                    if (styleItem.tab) {
                        if (bl || n == n2) {
                            n4 += styleItem.width;
                        }
                        point = new Point(n4, this.lineY[n3]);
                        break;
                    }
                    int n7 = n - styleItem.start;
                    int n8 = styleItem.length;
                    int n9 = styleItem.glyphCount;
                    int[] nArray = new int[1];
                    int n10 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                    OS.ScriptCPtoX(n7, bl, n8, n9, styleItem.clusters, styleItem.visAttrs, n10, styleItem.analysis, nArray);
                    if ((this.orientation & 0x4000000) != 0) {
                        point = new Point(n4 + (styleItem.width - nArray[0]), this.lineY[n3]);
                        break;
                    }
                    point = new Point(n4 + nArray[0], this.lineY[n3]);
                    break;
                }
                n4 += styleItem.width;
                ++n5;
            }
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        point.x += this.getLineIndent(n3);
        return point;
    }

    public int getNextOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.computeRuns(null);
        int n4 = this.text.length();
        if (n < 0 || n > n4) {
            SWT.error(6);
        }
        if (bl && n == n4) {
            return n4;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        n4 = this.segmentsText.length();
        n = this.translateOffset(n);
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        int n6 = bl ? 0 : this.allRuns.length - 1;
        n = this.validadeOffset(n, n3);
        do {
            boolean bl2;
            StyleItem styleItem = this.allRuns[n6];
            if (styleItem.start > n || n >= styleItem.start + styleItem.length) continue;
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (styleItem.tab) {
                return this.untranslateOffset(styleItem.start);
            }
            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl3 = bl2 = sCRIPT_PROPERTIES.fNeedsCaretInfo || sCRIPT_PROPERTIES.fNeedsWordBreaking;
            if (bl2) {
                this.breakRun(styleItem);
            }
            while (styleItem.start <= n && n < styleItem.start + styleItem.length) {
                if (bl2) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (n - styleItem.start) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                }
                switch (n2) {
                    case 2: {
                        if (sCRIPT_PROPERTIES.fNeedsCaretInfo) {
                            if (sCRIPT_LOGATTR.fInvalid || !sCRIPT_LOGATTR.fCharStop) break;
                            return this.untranslateOffset(n);
                        }
                        return this.untranslateOffset(n);
                    }
                    case 4: 
                    case 16: {
                        boolean bl4;
                        boolean bl5;
                        if (!(sCRIPT_PROPERTIES.fNeedsWordBreaking ? !sCRIPT_LOGATTR.fInvalid && sCRIPT_LOGATTR.fWordStop : n > 0 && ((bl5 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n))) != (bl4 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1))) || !bl5) && !Compatibility.isWhitespace(this.segmentsText.charAt(n)))) break;
                        return this.untranslateOffset(n);
                    }
                    case 8: {
                        if (n <= 0) break;
                        boolean bl5 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n));
                        boolean bl4 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1));
                        if (bl5 || !bl4) break;
                        return this.untranslateOffset(n);
                    }
                }
                n = this.validadeOffset(n, n3);
            }
        } while ((n6 += n3) >= 0 && n6 < this.allRuns.length - 1 && n >= 0 && n < n4);
        return bl ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        this.checkLayout();
        this.computeRuns(null);
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        int n3 = this.runs.length;
        int n4 = 0;
        while (n4 < n3) {
            if (this.lineY[n4 + 1] > n2) break;
            ++n4;
        }
        n4 = Math.min(n4, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n4];
        if ((n -= this.getLineIndent(n4)) >= this.lineWidth[n4]) {
            n = this.lineWidth[n4] - 1;
        }
        if (n < 0) {
            n = 0;
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < styleItemArray.length) {
            StyleItem styleItem = styleItemArray[n6];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (n5 + styleItem.width > n) {
                int n7 = n - n5;
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    GlyphMetrics glyphMetrics = styleItem.style.metrics;
                    if (glyphMetrics.width > 0) {
                        if (nArray != null) {
                            nArray[0] = n7 % glyphMetrics.width < glyphMetrics.width / 2 ? 0 : 1;
                        }
                        return this.untranslateOffset(styleItem.start + n7 / glyphMetrics.width);
                    }
                }
                if (styleItem.tab) {
                    if (nArray != null) {
                        nArray[0] = n < n5 + styleItem.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(styleItem.start);
                }
                int n8 = styleItem.length;
                int n9 = styleItem.glyphCount;
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                if ((this.orientation & 0x4000000) != 0) {
                    n7 = styleItem.width - n7;
                }
                int n10 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                OS.ScriptXtoCP(n7, n8, n9, styleItem.clusters, styleItem.visAttrs, n10, styleItem.analysis, nArray2, nArray3);
                if (nArray != null) {
                    nArray[0] = nArray3[0];
                }
                return this.untranslateOffset(styleItem.start + nArray2[0]);
            }
            n5 += styleItem.width;
            ++n6;
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        return this.untranslateOffset(this.lineOffset[n4 + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.styles.length * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length - 1) {
            if (this.styles[n2].style != null) {
                nArray[n++] = this.styles[n2].start;
                nArray[n++] = this.styles[n2 + 1].start - 1;
            }
            ++n2;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int n = this.segments.length;
        if (n <= 1) {
            return this.text;
        }
        int n2 = this.text.length();
        if (n2 == 0) {
            return this.text;
        }
        if (n == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
            return this.text;
        }
        char[] cArray = new char[n2];
        this.text.getChars(0, n2, cArray, 0);
        char[] cArray2 = new char[n2 + n];
        int n3 = 0;
        int n4 = 0;
        int n5 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n3 < n2) {
            if (n4 < n && n3 == this.segments[n4]) {
                cArray2[n3 + n4++] = n5;
                continue;
            }
            cArray2[n3 + n4] = cArray[n3++];
        }
        if (n4 < n) {
            this.segments[n4] = n3;
            cArray2[n3 + n4++] = n5;
        }
        return new String(cArray2, 0, Math.min(n3 + n4, cArray2.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (n < 0 || n >= n2) {
            SWT.error(6);
        }
        int n3 = 1;
        while (n3 < this.styles.length) {
            if (this.styles[n3].start > n) {
                return this.styles[n3 - 1].style;
            }
            ++n3;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        int n = 0;
        int n2 = 0;
        while (n2 < this.styles.length) {
            if (this.styles[n2].style != null) {
                textStyleArray[n++] = this.styles[n2].style;
            }
            ++n2;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        int n;
        int n2;
        this.segmentsText = this.getSegmentsText();
        int n3 = this.segmentsText.length();
        SCRIPT_CONTROL sCRIPT_CONTROL = new SCRIPT_CONTROL();
        SCRIPT_STATE sCRIPT_STATE = new SCRIPT_STATE();
        int n4 = n3 + 1;
        if ((this.orientation & 0x4000000) != 0) {
            sCRIPT_STATE.uBidiLevel = 1;
            sCRIPT_STATE.fArabicNumContext = true;
            SCRIPT_DIGITSUBSTITUTE sCRIPT_DIGITSUBSTITUTE = new SCRIPT_DIGITSUBSTITUTE();
            OS.ScriptRecordDigitSubstitution(1024, sCRIPT_DIGITSUBSTITUTE);
            OS.ScriptApplyDigitSubstitution(sCRIPT_DIGITSUBSTITUTE, sCRIPT_CONTROL, sCRIPT_STATE);
        }
        if ((n2 = OS.HeapAlloc(n = OS.GetProcessHeap(), 8, n4 * SCRIPT_ITEM.sizeof)) == 0) {
            SWT.error(2);
        }
        int[] nArray = new int[1];
        char[] cArray = new char[n3];
        this.segmentsText.getChars(0, n3, cArray, 0);
        OS.ScriptItemize(cArray, n3, n4, sCRIPT_CONTROL, sCRIPT_STATE, n2, nArray);
        StyleItem[] styleItemArray = this.merge(n2, nArray[0]);
        OS.HeapFree(n, 0, n2);
        return styleItemArray;
    }

    StyleItem[] merge(int n, int n2) {
        StyleItem styleItem;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.segmentsText.length();
        int n6 = 0;
        int n7 = 0;
        StyleItem[] styleItemArray = new StyleItem[n2 + this.styles.length];
        SCRIPT_ITEM sCRIPT_ITEM = new SCRIPT_ITEM();
        boolean bl = false;
        while (n4 < n5) {
            styleItem = new StyleItem();
            styleItem.start = n4;
            styleItem.style = this.styles[n7].style;
            styleItemArray[n3++] = styleItem;
            OS.MoveMemory(sCRIPT_ITEM, n + n6 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
            styleItem.analysis = sCRIPT_ITEM.a;
            if (bl) {
                styleItem.analysis.fLinkBefore = true;
                bl = false;
            }
            sCRIPT_ITEM.a = new SCRIPT_ANALYSIS();
            OS.MoveMemory(sCRIPT_ITEM, n + (n6 + 1) * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
            int n8 = sCRIPT_ITEM.iCharPos;
            int n9 = this.translateOffset(this.styles[n7 + 1].start);
            if (n9 <= n8) {
                ++n7;
                n4 = n9;
                if (n4 < n8 && n4 > 0 && n4 < n5) {
                    char c = this.segmentsText.charAt(n4 - 1);
                    char c2 = this.segmentsText.charAt(n4);
                    if (!Compatibility.isWhitespace(c) && !Compatibility.isWhitespace(c2)) {
                        styleItem.analysis.fLinkAfter = true;
                        bl = true;
                    }
                }
            }
            if (n8 <= n9) {
                ++n6;
                n4 = n8;
            }
            styleItem.length = n4 - styleItem.start;
        }
        styleItem = new StyleItem();
        styleItem.start = n5;
        OS.MoveMemory(sCRIPT_ITEM, n + n2 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
        styleItem.analysis = sCRIPT_ITEM.a;
        styleItemArray[n3++] = styleItem;
        if (styleItemArray.length != n3) {
            StyleItem[] styleItemArray2 = new StyleItem[n3];
            System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n3);
            return styleItemArray2;
        }
        return styleItemArray;
    }

    StyleItem[] reorder(StyleItem[] styleItemArray, boolean bl) {
        int n = styleItemArray.length;
        if (n <= 1) {
            return styleItemArray;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)(styleItemArray[n2].analysis.s.uBidiLevel & 0x1F);
            ++n2;
        }
        StyleItem styleItem = styleItemArray[n - 1];
        if (styleItem.lineBreak && !styleItem.softBreak) {
            byArray[n - 1] = 0;
        }
        int[] nArray = new int[n];
        OS.ScriptLayout(n, byArray, null, nArray);
        StyleItem[] styleItemArray2 = new StyleItem[n];
        int n3 = 0;
        while (n3 < n) {
            styleItemArray2[nArray[n3]] = styleItemArray[n3];
            ++n3;
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (bl) {
                --n;
            }
            n3 = 0;
            while (n3 < n / 2) {
                StyleItem styleItem2 = styleItemArray2[n3];
                styleItemArray2[n3] = styleItemArray2[n - n3 - 1];
                styleItemArray2[n - n3 - 1] = styleItem2;
                ++n3;
            }
        }
        return styleItemArray2;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        if (this.alignment == n) {
            return;
        }
        this.freeRuns();
        this.alignment = n;
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.freeRuns();
        this.indent = n;
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        if (this.justify == bl) {
            return;
        }
        this.freeRuns();
        this.justify = bl;
    }

    public void setOrientation(int n) {
        this.checkLayout();
        int n2 = 0x6000000;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        this.freeRuns();
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.segments[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == n) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = n;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        this.checkLayout();
        int n5 = this.text.length();
        if (n5 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n5 - 1);
        n2 = Math.min(Math.max(0, n2), n5 - 1);
        int n6 = -1;
        int n7 = this.styles.length;
        while (n7 - n6 > 1) {
            n4 = (n7 + n6) / 2;
            if (this.styles[n4 + 1].start > n) {
                n7 = n4;
                continue;
            }
            n6 = n4;
        }
        if (n7 >= 0 && n7 < this.styles.length) {
            StyleItem styleItem = this.styles[n7];
            if (styleItem.start == n && this.styles[n7 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n8 = n4 = n7;
        while (n8 < this.styles.length) {
            if (this.styles[n8 + 1].start > n2) break;
            ++n8;
        }
        if (n4 == n8) {
            n3 = this.styles[n4].start;
            int n9 = this.styles[n8 + 1].start - 1;
            if (n3 == n && n9 == n2) {
                this.styles[n4].style = textStyle;
                return;
            }
            if (n3 != n && n9 != n2) {
                StyleItem[] styleItemArray = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                styleItemArray[n4 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n4].style;
                styleItemArray[n4 + 2] = styleItem;
                System.arraycopy(this.styles, n8 + 1, styleItemArray, n8 + 3, this.styles.length - n8 - 1);
                this.styles = styleItemArray;
                return;
            }
        }
        if (n == this.styles[n4].start) {
            --n4;
        }
        if (n2 == this.styles[n8 + 1].start - 1) {
            ++n8;
        }
        n3 = this.styles.length + 1 - (n8 - n4 - 1);
        StyleItem[] styleItemArray = new StyleItem[n3];
        System.arraycopy(this.styles, 0, styleItemArray, 0, n4 + 1);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        styleItemArray[n4 + 1] = styleItem;
        this.styles[n8].start = n2 + 1;
        System.arraycopy(this.styles, n8, styleItemArray, n4 + 2, this.styles.length - n8);
        this.styles = styleItemArray;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n = 0;
            while (n < nArray.length) {
                if (this.tabs[n] != nArray[n]) break;
                ++n;
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
    }

    boolean shape(int n, StyleItem styleItem, char[] cArray, int[] nArray, int n2) {
        int n3 = OS.ScriptShape(n, styleItem.psc, cArray, cArray.length, n2, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
        styleItem.glyphCount = nArray[0];
        if (n3 != -2147220992) {
            SCRIPT_FONTPROPERTIES sCRIPT_FONTPROPERTIES = new SCRIPT_FONTPROPERTIES();
            sCRIPT_FONTPROPERTIES.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(n, styleItem.psc, sCRIPT_FONTPROPERTIES);
            short[] sArray = new short[nArray[0]];
            OS.MoveMemory(sArray, styleItem.glyphs, sArray.length * 2);
            int n4 = 0;
            while (n4 < sArray.length) {
                if (sArray[n4] == sCRIPT_FONTPROPERTIES.wgDefault) break;
                ++n4;
            }
            if (n4 == sArray.length) {
                return true;
            }
        }
        if (styleItem.psc != 0) {
            OS.ScriptFreeCache(styleItem.psc);
            nArray[0] = 0;
            OS.MoveMemory(styleItem.psc, nArray, 4);
        }
        styleItem.glyphCount = 0;
        return false;
    }

    void shape(int n, StyleItem styleItem) {
        Object object;
        int[] nArray;
        int[] nArray2 = new int[1];
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n2 = cArray.length * 3 / 2 + 16;
        int n3 = OS.GetProcessHeap();
        styleItem.glyphs = OS.HeapAlloc(n3, 8, n2 * 2);
        if (styleItem.glyphs == 0) {
            SWT.error(2);
        }
        styleItem.clusters = OS.HeapAlloc(n3, 8, n2 * 2);
        if (styleItem.clusters == 0) {
            SWT.error(2);
        }
        styleItem.visAttrs = OS.HeapAlloc(n3, 8, n2 * 2);
        if (styleItem.visAttrs == 0) {
            SWT.error(2);
        }
        styleItem.psc = OS.HeapAlloc(n3, 8, 4);
        if (styleItem.psc == 0) {
            SWT.error(2);
        }
        if (!this.shape(n, styleItem, cArray, nArray2, n2) && this.mLangFontLink2 != 0) {
            nArray = new int[1];
            object = new int[1];
            OS.VtblCall(4, this.mLangFontLink2, cArray, cArray.length, 0, nArray, object);
            int[] nArray3 = new int[1];
            if (OS.VtblCall(10, this.mLangFontLink2, n, nArray[0], (int)cArray[0], nArray3) == 0) {
                int n4 = OS.SelectObject(n, nArray3[0]);
                if (this.shape(n, styleItem, cArray, nArray2, n2)) {
                    styleItem.fallbackFont = nArray3[0];
                } else {
                    OS.VtblCall(8, this.mLangFontLink2, nArray3[0]);
                    OS.SelectObject(n, n4);
                    SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
                    OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                    if (sCRIPT_PROPERTIES.fPrivateUseArea) {
                        styleItem.analysis.fNoGlyphIndex = true;
                    }
                    OS.ScriptShape(n, styleItem.psc, cArray, cArray.length, n2, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray2);
                    styleItem.glyphCount = nArray2[0];
                }
            }
        }
        nArray = new int[3];
        styleItem.advances = OS.HeapAlloc(n3, 8, styleItem.glyphCount * 4);
        if (styleItem.advances == 0) {
            SWT.error(2);
        }
        styleItem.goffsets = OS.HeapAlloc(n3, 8, styleItem.glyphCount * 8);
        if (styleItem.goffsets == 0) {
            SWT.error(2);
        }
        OS.ScriptPlace(n, styleItem.psc, styleItem.glyphs, styleItem.glyphCount, styleItem.visAttrs, styleItem.analysis, styleItem.advances, styleItem.goffsets, nArray);
        if (styleItem.style != null && styleItem.style.metrics != null) {
            object = styleItem.style.metrics;
            styleItem.width = object.width * Math.max(1, styleItem.glyphCount);
            styleItem.ascent = object.ascent;
            styleItem.descent = object.descent;
            styleItem.leading = 0;
        } else {
            styleItem.width = nArray[0] + nArray[1] + nArray[2];
            object = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n, (TEXTMETRIC)object);
            styleItem.ascent = object.tmAscent;
            styleItem.descent = object.tmDescent;
            styleItem.leading = object.tmInternalLeading;
        }
        if (styleItem.style != null) {
            styleItem.ascent += styleItem.style.rise;
            styleItem.descent -= styleItem.style.rise;
        }
    }

    int validadeOffset(int n, int n2) {
        n += n2;
        if (this.segments != null && this.segments.length > 2) {
            int n3 = 0;
            while (n3 < this.segments.length) {
                if (this.translateOffset(this.segments[n3]) - 1 == n) {
                    n += n2;
                    break;
                }
                ++n3;
            }
        }
        return n;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        if (n2 <= 1) {
            return n;
        }
        int n3 = this.text.length();
        if (n3 == 0) {
            return n;
        }
        if (n2 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
            return n;
        }
        int n4 = 0;
        while (n4 < n2 && n - n4 >= this.segments[n4]) {
            ++n;
            ++n4;
        }
        return n;
    }

    int untranslateOffset(int n) {
        if (this.segments == null) {
            return n;
        }
        int n2 = this.segments.length;
        if (n2 <= 1) {
            return n;
        }
        int n3 = this.text.length();
        if (n3 == 0) {
            return n;
        }
        if (n2 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
            return n;
        }
        int n4 = 0;
        while (n4 < n2 && n > this.segments[n4]) {
            --n;
            ++n4;
        }
        return n;
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        int psc = 0;
        int glyphs;
        int glyphCount;
        int clusters;
        int visAttrs;
        int advances;
        int goffsets;
        int width;
        int ascent;
        int descent;
        int leading;
        int x;
        int justify;
        int psla;
        int fallbackFont;

        StyleItem() {
        }

        void free() {
            int n = OS.GetProcessHeap();
            if (this.psc != 0) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(n, 0, this.psc);
                this.psc = 0;
            }
            if (this.glyphs != 0) {
                OS.HeapFree(n, 0, this.glyphs);
                this.glyphs = 0;
                this.glyphCount = 0;
            }
            if (this.clusters != 0) {
                OS.HeapFree(n, 0, this.clusters);
                this.clusters = 0;
            }
            if (this.visAttrs != 0) {
                OS.HeapFree(n, 0, this.visAttrs);
                this.visAttrs = 0;
            }
            if (this.advances != 0) {
                OS.HeapFree(n, 0, this.advances);
                this.advances = 0;
            }
            if (this.goffsets != 0) {
                OS.HeapFree(n, 0, this.goffsets);
                this.goffsets = 0;
            }
            if (this.justify != 0) {
                OS.HeapFree(n, 0, this.justify);
                this.justify = 0;
            }
            if (this.psla != 0) {
                OS.HeapFree(n, 0, this.psla);
                this.psla = 0;
            }
            if (this.fallbackFont != 0) {
                if (TextLayout.this.mLangFontLink2 != 0) {
                    OS.VtblCall(8, TextLayout.this.mLangFontLink2, this.fallbackFont);
                }
                this.fallbackFont = 0;
            }
            this.x = 0;
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

