/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.GtkTargetPair;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    long dragOverStart;
    Runnable dragOverHeartbeat;
    DNDEvent dragOverEvent;
    int drag_motion_handler;
    int drag_leave_handler;
    int drag_data_received_handler;
    int drag_drop_handler;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final String DROPTARGETID = "DropTarget";
    static final int DRAGOVER_HYSTERESIS = 50;
    static Callback Drag_Motion;
    static Callback Drag_Leave;
    static Callback Drag_Data_Received;
    static Callback Drag_Drop;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Drag_Motion = new Callback(clazz4, "Drag_Motion", 5)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz3 = class$0) == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Drag_Leave = new Callback(clazz3, "Drag_Leave", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Drag_Data_Received = new Callback(clazz2, "Drag_Data_Received", 7)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Drag_Drop = new Callback(clazz, "Drag_Drop", 5)).getAddress() == 0) {
            SWT.error(3);
        }
    }

    public DropTarget(Control control, int n) {
        super(control, DropTarget.checkStyle(n));
        this.control = control;
        if (Drag_Motion == null || Drag_Leave == null || Drag_Data_Received == null || Drag_Drop == null) {
            DND.error(2001);
        }
        if (control.getData(DROPTARGETID) != null) {
            DND.error(2001);
        }
        control.setData(DROPTARGETID, this);
        this.drag_motion_handler = OS.g_signal_connect(control.handle, OS.drag_motion, Drag_Motion.getAddress(), 0);
        this.drag_leave_handler = OS.g_signal_connect(control.handle, OS.drag_leave, Drag_Leave.getAddress(), 0);
        this.drag_data_received_handler = OS.g_signal_connect(control.handle, OS.drag_data_received, Drag_Data_Received.getAddress(), 0);
        this.drag_drop_handler = OS.g_signal_connect(control.handle, OS.drag_drop, Drag_Drop.getAddress(), 0);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (object instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)object;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                Control control = DropTarget.this.control;
                if (control == null || control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long l = System.currentTimeMillis();
                int n = 50;
                if (l < DropTarget.this.dragOverStart) {
                    n = (int)(DropTarget.this.dragOverStart - l);
                } else {
                    DropTarget.this.dragOverEvent.time += 50;
                    int n2 = DropTarget.this.dragOverEvent.operations;
                    TransferData[] transferDataArray = DropTarget.this.dragOverEvent.dataTypes;
                    TransferData[] transferDataArray2 = new TransferData[transferDataArray.length];
                    System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray2.length);
                    DNDEvent dNDEvent = new DNDEvent();
                    dNDEvent.widget = DropTarget.this.dragOverEvent.widget;
                    dNDEvent.x = DropTarget.this.dragOverEvent.x;
                    dNDEvent.y = DropTarget.this.dragOverEvent.y;
                    dNDEvent.time = DropTarget.this.dragOverEvent.time;
                    dNDEvent.feedback = 1;
                    dNDEvent.dataTypes = transferDataArray2;
                    dNDEvent.dataType = DropTarget.this.selectedDataType;
                    dNDEvent.operations = DropTarget.this.dragOverEvent.operations;
                    dNDEvent.detail = DropTarget.this.selectedOperation;
                    if (DropTarget.this.dropEffect != null) {
                        dNDEvent.item = DropTarget.this.dropEffect.getItem(DropTarget.this.dragOverEvent.x, DropTarget.this.dragOverEvent.y);
                    }
                    DropTarget.this.selectedDataType = null;
                    DropTarget.this.selectedOperation = 0;
                    DropTarget.this.notifyListeners(2004, dNDEvent);
                    if (dNDEvent.dataType != null) {
                        int n3 = 0;
                        while (n3 < transferDataArray.length) {
                            if (transferDataArray[n3].type == dNDEvent.dataType.type) {
                                DropTarget.this.selectedDataType = dNDEvent.dataType;
                                break;
                            }
                            ++n3;
                        }
                    }
                    if (DropTarget.this.selectedDataType != null && (dNDEvent.detail & n2) != 0) {
                        DropTarget.this.selectedOperation = dNDEvent.detail;
                    }
                }
                control = DropTarget.this.control;
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().timerExec(n, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    static int Drag_Data_Received(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget == null) {
            return 0;
        }
        dropTarget.drag_data_received(n, n2, n3, n4, n5, n6, n7);
        return 0;
    }

    static int Drag_Drop(int n, int n2, int n3, int n4, int n5) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget == null) {
            return 0;
        }
        return dropTarget.drag_drop(n, n2, n3, n4, n5) ? 1 : 0;
    }

    static int Drag_Leave(int n, int n2, int n3) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget == null) {
            return 0;
        }
        dropTarget.drag_leave(n, n2, n3);
        return 0;
    }

    static int Drag_Motion(int n, int n2, int n3, int n4, int n5) {
        DropTarget dropTarget = DropTarget.FindDropTarget(n);
        if (dropTarget == null) {
            return 0;
        }
        return dropTarget.drag_motion(n, n2, n3, n4, n5) ? 1 : 0;
    }

    static DropTarget FindDropTarget(int n) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData(DROPTARGETID);
    }

    public void addDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dropTargetListener);
        dNDListener.dndWidget = this;
        this.addListener(2002, dNDListener);
        this.addListener(2003, dNDListener);
        this.addListener(2004, dNDListener);
        this.addListener(2005, dNDListener);
        this.addListener(2006, dNDListener);
        this.addListener(2007, dNDListener);
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    void drag_data_received(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        DNDEvent dNDEvent = new DNDEvent();
        if (n5 == 0 || !this.setEventData(n2, n3, n4, n7, dNDEvent)) {
            this.keyOperation = -1;
            return;
        }
        this.keyOperation = -1;
        int n8 = dNDEvent.operations;
        Object object = null;
        TransferData transferData = new TransferData();
        GtkSelectionData gtkSelectionData = new GtkSelectionData();
        OS.memmove(gtkSelectionData, n5, GtkSelectionData.sizeof);
        if (gtkSelectionData.data != 0) {
            transferData.type = gtkSelectionData.type;
            transferData.length = gtkSelectionData.length;
            transferData.pValue = gtkSelectionData.data;
            transferData.format = gtkSelectionData.format;
            int n9 = 0;
            while (n9 < this.transferAgents.length) {
                Transfer transfer = this.transferAgents[n9];
                if (transfer != null && transfer.isSupportedType(transferData)) {
                    object = transfer.nativeToJava(transferData);
                    break;
                }
                ++n9;
            }
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        dNDEvent.detail = this.selectedOperation;
        dNDEvent.dataType = transferData;
        dNDEvent.data = object;
        this.selectedOperation = 0;
        this.notifyListeners(2006, dNDEvent);
        if ((n8 & dNDEvent.detail) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        OS.g_signal_stop_emission_by_name(n, OS.drag_data_received);
        OS.gtk_drag_finish(n2, this.selectedOperation != 0, this.selectedOperation == 2, n7);
    }

    boolean drag_drop(int n, int n2, int n3, int n4, int n5) {
        DNDEvent dNDEvent = new DNDEvent();
        if (!this.setEventData(n2, n3, n4, n5, dNDEvent)) {
            this.keyOperation = -1;
            return false;
        }
        this.keyOperation = -1;
        int n6 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        dNDEvent.dataType = this.selectedDataType;
        dNDEvent.detail = this.selectedOperation;
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2007, dNDEvent);
        if (dNDEvent.dataType != null) {
            int n7 = 0;
            while (n7 < transferDataArray.length) {
                if (transferDataArray[n7].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n7];
                    break;
                }
                ++n7;
            }
        }
        if (this.selectedDataType != null && (dNDEvent.detail & n6) == dNDEvent.detail) {
            this.selectedOperation = dNDEvent.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        OS.gtk_drag_get_data(n, n2, this.selectedDataType.type, n5);
        return true;
    }

    void drag_leave(int n, int n2, int n3) {
        this.updateDragOverHover(0L, null);
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = n3;
        dNDEvent.detail = 0;
        this.notifyListeners(2003, dNDEvent);
    }

    boolean drag_motion(int n, int n2, int n3, int n4, int n5) {
        DNDEvent dNDEvent;
        int n6 = this.keyOperation;
        if (n6 == -1) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(n2, n3, n4, n5, dNDEvent = new DNDEvent())) {
            this.keyOperation = -1;
            OS.gdk_drag_status(n2, 0, n5);
            return false;
        }
        int n7 = dNDEvent.operations;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        if (n6 == -1) {
            dNDEvent.type = 2002;
        } else if (this.keyOperation == n6) {
            dNDEvent.type = 2004;
            dNDEvent.dataType = this.selectedDataType;
            dNDEvent.detail = this.selectedOperation;
        } else {
            dNDEvent.type = 2005;
            dNDEvent.dataType = this.selectedDataType;
        }
        this.updateDragOverHover(50L, dNDEvent);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(dNDEvent.type, dNDEvent);
        if (dNDEvent.detail == 16) {
            int n8 = dNDEvent.detail = (n7 & 2) != 0 ? 2 : 0;
        }
        if (dNDEvent.dataType != null) {
            int n9 = 0;
            while (n9 < transferDataArray.length) {
                if (transferDataArray[n9].type == dNDEvent.dataType.type) {
                    this.selectedDataType = transferDataArray[n9];
                    break;
                }
                ++n9;
            }
        }
        if (this.selectedDataType != null && (n7 & dNDEvent.detail) != 0) {
            this.selectedOperation = dNDEvent.detail;
        }
        switch (this.selectedOperation) {
            case 0: {
                OS.gdk_drag_status(n2, 0, n5);
                break;
            }
            case 1: {
                OS.gdk_drag_status(n2, 2, n5);
                break;
            }
            case 2: {
                OS.gdk_drag_status(n2, 4, n5);
                break;
            }
            case 4: {
                OS.gdk_drag_status(n2, 8, n5);
            }
        }
        if (n6 == -1) {
            this.dragOverHeartbeat.run();
        }
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState() {
        boolean bl;
        int[] nArray = new int[1];
        OS.gdk_window_get_pointer(0, null, null, nArray);
        boolean bl2 = (nArray[0] & 4) != 0;
        boolean bl3 = bl = (nArray[0] & 1) != 0;
        if (bl2 && bl) {
            return 4;
        }
        if (bl2) {
            return 1;
        }
        if (bl) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_motion_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_leave_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_data_received_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_drop_handler);
        if (this.transferAgents.length != 0) {
            OS.gtk_drag_dest_unset(this.control.handle);
        }
        this.transferAgents = null;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.control.setData(DROPTARGETID, null);
        this.control = null;
        this.controlListener = null;
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 2;
        }
        if ((n & 2) == 2) {
            n2 |= 4;
        }
        if ((n & 4) == 4) {
            n2 |= 8;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 2) == 2) {
            n2 |= 1;
        }
        if ((n & 4) == 4) {
            n2 |= 2;
        }
        if ((n & 8) == 8) {
            n2 |= 4;
        }
        return n2;
    }

    public void removeDropListener(DropTargetListener dropTargetListener) {
        if (dropTargetListener == null) {
            DND.error(4);
        }
        this.removeListener(2002, dropTargetListener);
        this.removeListener(2003, dropTargetListener);
        this.removeListener(2004, dropTargetListener);
        this.removeListener(2005, dropTargetListener);
        this.removeListener(2006, dropTargetListener);
        this.removeListener(2007, dropTargetListener);
    }

    public void setTransfer(Transfer[] transferArray) {
        if (transferArray == null) {
            DND.error(4);
        }
        if (this.transferAgents.length != 0) {
            OS.gtk_drag_dest_unset(this.control.handle);
        }
        this.transferAgents = transferArray;
        GtkTargetEntry[] gtkTargetEntryArray = new GtkTargetEntry[]{};
        int n = 0;
        while (n < transferArray.length) {
            Transfer transfer = transferArray[n];
            if (transfer != null) {
                int[] nArray = transfer.getTypeIds();
                String[] stringArray = transfer.getTypeNames();
                int n2 = 0;
                while (n2 < nArray.length) {
                    GtkTargetEntry gtkTargetEntry = new GtkTargetEntry();
                    byte[] byArray = Converter.wcsToMbcs(null, stringArray[n2], true);
                    gtkTargetEntry.target = OS.g_malloc(byArray.length);
                    OS.memmove(gtkTargetEntry.target, byArray, byArray.length);
                    gtkTargetEntry.info = nArray[n2];
                    GtkTargetEntry[] gtkTargetEntryArray2 = new GtkTargetEntry[gtkTargetEntryArray.length + 1];
                    System.arraycopy(gtkTargetEntryArray, 0, gtkTargetEntryArray2, 0, gtkTargetEntryArray.length);
                    gtkTargetEntryArray2[gtkTargetEntryArray.length] = gtkTargetEntry;
                    gtkTargetEntryArray = gtkTargetEntryArray2;
                    ++n2;
                }
            }
            ++n;
        }
        n = OS.g_malloc(gtkTargetEntryArray.length * GtkTargetEntry.sizeof);
        int n3 = 0;
        while (n3 < gtkTargetEntryArray.length) {
            OS.memmove(n + n3 * GtkTargetEntry.sizeof, gtkTargetEntryArray[n3], GtkTargetEntry.sizeof);
            ++n3;
        }
        n3 = this.opToOsOp(this.getStyle());
        OS.gtk_drag_dest_set(this.control.handle, 0, n, gtkTargetEntryArray.length, n3);
        int n4 = 0;
        while (n4 < gtkTargetEntryArray.length) {
            OS.g_free(gtkTargetEntryArray[n4].target);
            ++n4;
        }
    }

    public void setDropTargetEffect(DropTargetEffect dropTargetEffect) {
        this.dropEffect = dropTargetEffect;
    }

    boolean setEventData(int n, int n2, int n3, int n4, DNDEvent dNDEvent) {
        Object object;
        Object object2;
        int n5;
        if (n == 0) {
            return false;
        }
        GdkDragContext gdkDragContext = new GdkDragContext();
        OS.memmove(gdkDragContext, n, GdkDragContext.sizeof);
        if (gdkDragContext.targets == 0) {
            return false;
        }
        int n6 = this.getStyle();
        int n7 = this.osOpToOp(gdkDragContext.actions) & n6;
        if (n7 == 0) {
            return false;
        }
        this.keyOperation = n5 = this.getOperationFromKeyState();
        if (n5 == 16) {
            if ((n6 & 0x10) == 0) {
                n5 = (n7 & 2) != 0 ? 2 : 0;
            }
        } else if ((n5 & n7) == 0) {
            n5 = 0;
        }
        int n8 = OS.g_list_length(gdkDragContext.targets);
        TransferData[] transferDataArray = new TransferData[]{};
        int n9 = 0;
        while (n9 < n8) {
            int n10 = OS.g_list_nth(gdkDragContext.targets, n9);
            object2 = new GtkTargetPair();
            OS.memmove((GtkTargetPair)object2, n10, GtkTargetPair.sizeof);
            object = new TransferData();
            ((TransferData)object).type = ((GtkTargetPair)object2).target;
            int n11 = 0;
            while (n11 < this.transferAgents.length) {
                Transfer transfer = this.transferAgents[n11];
                if (transfer != null && transfer.isSupportedType((TransferData)object)) {
                    TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + 1];
                    System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
                    transferDataArray2[transferDataArray.length] = object;
                    transferDataArray = transferDataArray2;
                    break;
                }
                ++n11;
            }
            ++n9;
        }
        if (transferDataArray.length == 0) {
            return false;
        }
        n9 = OS.GTK_WIDGET_WINDOW(this.control.handle);
        int[] nArray = new int[1];
        object2 = new int[1];
        OS.gdk_window_get_origin(n9, nArray, (int[])object2);
        object = new Point(nArray[0] + n2, (int)(object2[0] + n3));
        dNDEvent.widget = this;
        dNDEvent.x = ((Point)object).x;
        dNDEvent.y = ((Point)object).y;
        dNDEvent.time = n4;
        dNDEvent.feedback = 1;
        dNDEvent.dataTypes = transferDataArray;
        dNDEvent.dataType = transferDataArray[0];
        dNDEvent.operations = n7;
        dNDEvent.detail = n5;
        if (this.dropEffect != null) {
            dNDEvent.item = this.dropEffect.getItem(((Point)object).x, ((Point)object).y);
        }
        return true;
    }

    void updateDragOverHover(long l, DNDEvent dNDEvent) {
        if (l == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + l;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = dNDEvent.x;
        this.dragOverEvent.y = dNDEvent.y;
        TransferData[] transferDataArray = new TransferData[dNDEvent.dataTypes.length];
        System.arraycopy(dNDEvent.dataTypes, 0, transferDataArray, 0, transferDataArray.length);
        this.dragOverEvent.dataTypes = transferDataArray;
        this.dragOverEvent.operations = dNDEvent.operations;
        this.dragOverEvent.time = dNDEvent.time;
    }
}

