/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GtkCombo;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int buttonHandle;
    int entryHandle;
    int listHandle;
    int textRenderer;
    int lastEventTime;
    int visibleCount = 5;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    boolean ignoreSelect;
    boolean lockText;
    static final int INNER_BORDER = 2;
    public static final int LIMIT = 65535;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n < 0 || n > this.items.length) {
            this.error(6);
        }
        String[] stringArray = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, stringArray, 0, n);
        stringArray[n] = string;
        System.arraycopy(this.items, n, stringArray, n + 1, this.items.length - n);
        this.items = stringArray;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_combo_box_insert_text(this.handle, n, byArray);
        } else {
            this.lockText = true;
            this.ignoreSelect = true;
            int n2 = OS.gtk_list_item_new_with_label(byArray);
            int n3 = OS.gtk_bin_get_child(n2);
            this.setForegroundColor(n3, this.getForegroundColor());
            OS.gtk_widget_modify_font(n3, this.getFontDescription());
            OS.gtk_widget_set_direction(n3, OS.gtk_widget_get_direction(this.handle));
            OS.gtk_widget_show(n2);
            int n4 = OS.g_list_append(0, n2);
            OS.gtk_list_insert_items(this.listHandle, n4, n);
            this.lockText = false;
            this.ignoreSelect = false;
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            int n = OS.gtk_editable_get_position(this.entryHandle);
            OS.gtk_editable_select_region(this.entryHandle, n, n);
        }
    }

    void clearText() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            if ((this.style & 8) != 0) {
                int n = OS.gtk_combo_box_get_active(this.handle);
                if (n != -1) {
                    int n2 = OS.gtk_combo_box_get_model(this.handle);
                    int[] nArray = new int[1];
                    int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                    OS.gtk_tree_model_iter_nth_child(n2, n3, 0, n);
                    OS.gtk_tree_model_get(n2, n3, 0, nArray, -1);
                    OS.g_free(n3);
                    if (nArray[0] != 0 && OS.strlen(nArray[0]) > 0) {
                        this.postEvent(24);
                    }
                    OS.g_free(nArray[0]);
                }
            } else {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            OS.gtk_combo_box_set_active(this.handle, -1);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return this.computeNativeSize(this.handle, n, n2, bl);
        }
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.entryHandle);
        int n3 = OS.gtk_entry_get_layout(this.entryHandle);
        OS.pango_layout_get_size(n3, nArray, nArray2);
        int n4 = 2;
        int n5 = 2;
        int n6 = OS.gtk_widget_get_style(this.entryHandle);
        n4 += OS.gtk_style_get_xthickness(n6);
        n5 += OS.gtk_style_get_ythickness(n6);
        int[] nArray3 = new int[1];
        OS.gtk_widget_style_get(this.entryHandle, OS.interior_focus, nArray3, 0);
        if (nArray3[0] == 0) {
            OS.gtk_widget_style_get(this.entryHandle, OS.focus_line_width, nArray3, 0);
            n4 += nArray3[0];
            n5 += nArray3[0];
        }
        int n7 = OS.PANGO_PIXELS(nArray[0]) + n4 * 2;
        int n8 = OS.PANGO_PIXELS(nArray2[0]) + n5 * 2;
        GtkRequisition gtkRequisition = new GtkRequisition();
        OS.gtk_widget_size_request(this.buttonHandle, gtkRequisition);
        GtkRequisition gtkRequisition2 = new GtkRequisition();
        int n9 = OS.gtk_widget_get_parent(this.listHandle);
        OS.gtk_widget_size_request(n9 != 0 ? n9 : this.listHandle, gtkRequisition2);
        n7 = Math.max(gtkRequisition2.width, n7) + gtkRequisition.width + 4;
        n7 = n == -1 ? n7 : n;
        n8 = n2 == -1 ? n8 : n2;
        return new Point(n7, n8);
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_copy_clipboard(this.entryHandle);
        }
    }

    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if ((this.style & 8) != 0) {
                this.handle = OS.gtk_combo_box_new_text();
                if (this.handle == 0) {
                    this.error(2);
                }
            } else {
                this.handle = OS.gtk_combo_box_entry_new_text();
                if (this.handle == 0) {
                    this.error(2);
                }
                this.entryHandle = OS.gtk_bin_get_child(this.handle);
                if (this.entryHandle == 0) {
                    this.error(2);
                }
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            this.textRenderer = OS.gtk_cell_renderer_text_new();
            if (this.textRenderer == 0) {
                this.error(2);
            }
            int n2 = 0;
            if (OS.GTK_VERSION < OS.VERSION(2, 6, 0)) {
                n2 = 1;
            }
            OS.g_object_set(this.textRenderer, OS.ypad, n2, 0);
            boolean bl = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.gtk_cell_layout_clear(this.handle);
            this.display.setWarnings(bl);
            OS.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
            OS.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0);
            OS.gtk_container_forall(this.handle, this.display.allChildrenProc, 0);
            if (this.display.allChildren != 0) {
                int n3 = this.display.allChildren;
                while (n3 != 0) {
                    int n4 = OS.g_list_data(n3);
                    if (OS.GTK_IS_BUTTON(n4)) {
                        this.buttonHandle = n4;
                        break;
                    }
                    n3 = OS.g_list_next(n3);
                }
                OS.g_list_free(this.display.allChildren);
                this.display.allChildren = 0;
            }
        } else {
            int n5;
            this.handle = OS.gtk_combo_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            GtkCombo gtkCombo = new GtkCombo();
            OS.memmove(gtkCombo, this.handle);
            this.entryHandle = gtkCombo.entry;
            this.listHandle = gtkCombo.list;
            int n6 = OS.gtk_container_get_children(this.handle);
            if (n6 != 0) {
                n5 = 0;
                int n7 = OS.g_list_length(n6);
                while (n5 < n7) {
                    int n8 = OS.g_list_nth_data(n6, n5);
                    if (n8 != this.entryHandle && n8 != this.listHandle) {
                        this.buttonHandle = n8;
                        break;
                    }
                    ++n5;
                }
                OS.g_list_free(n6);
            }
            n5 = (this.style & 8) == 0 ? 1 : 0;
            OS.gtk_editable_set_editable(this.entryHandle, n5 != 0);
            OS.gtk_combo_disable_activate(this.handle);
            OS.gtk_combo_set_case_sensitive(this.handle, true);
        }
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_cut_clipboard(this.entryHandle);
        }
    }

    void deregister() {
        int n;
        super.deregister();
        if (this.buttonHandle != 0) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.listHandle != 0) {
            this.display.removeWidget(this.listHandle);
        }
        if ((n = this.imContext()) != 0) {
            this.display.removeWidget(n);
        }
    }

    boolean filterKey(int n, int n2) {
        int n3 = OS.gdk_event_get_time(n2);
        if (n3 != this.lastEventTime) {
            this.lastEventTime = n3;
            int n4 = this.imContext();
            if (n4 != 0) {
                return OS.gtk_im_context_filter_keypress(n4, n2);
            }
        }
        this.gdkEventKey = n2;
        return false;
    }

    void fixIM() {
        int n;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (n = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(n, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    int fontHandle() {
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    int focusHandle() {
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (this.style & 8) != 0 && this.buttonHandle != 0) {
            return this.buttonHandle;
        }
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        if (this.entryHandle != 0 && OS.GTK_WIDGET_HAS_FOCUS(this.entryHandle)) {
            return true;
        }
        return this.listHandle != 0 && OS.GTK_WIDGET_HAS_FOCUS(this.listHandle);
    }

    void hookEvents() {
        int n;
        super.hookEvents();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_connect_closure(this.handle, OS.changed, this.display.closures[6], true);
        }
        if (this.entryHandle != 0) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.closures[6], true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.closures[26], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.closures[13], false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.closures[1], false);
        }
        int n2 = 772;
        int[] nArray = new int[]{this.buttonHandle, this.entryHandle, this.listHandle};
        int n3 = 0;
        while (n3 < nArray.length) {
            n = nArray[n3];
            if (n != 0) {
                OS.gtk_widget_add_events(n, n2);
                OS.g_signal_connect_closure_by_id(n, this.display.signalIds[2], 0, this.display.closures[2], false);
                OS.g_signal_connect_closure_by_id(n, this.display.signalIds[4], 0, this.display.closures[4], false);
                OS.g_signal_connect_closure_by_id(n, this.display.signalIds[33], 0, this.display.closures[33], false);
                OS.g_signal_connect_closure_by_id(n, this.display.signalIds[2], 0, this.display.closures[3], true);
                OS.g_signal_connect_closure_by_id(n, this.display.signalIds[4], 0, this.display.closures[5], true);
                OS.g_signal_connect_closure_by_id(n, this.display.signalIds[33], 0, this.display.closures[34], true);
                if (n != this.focusHandle()) {
                    OS.g_signal_connect_closure_by_id(n, this.display.signalIds[16], 0, this.display.closures[16], false);
                }
            }
            ++n3;
        }
        n3 = this.imContext();
        if (n3 != 0) {
            OS.g_signal_connect_closure(n3, OS.commit, this.display.closures[9], false);
            n = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n4 = 17;
            OS.g_signal_handlers_block_matched(n3, n4, n, 0, 0, 0, this.entryHandle);
        }
    }

    int imContext() {
        return this.entryHandle != 0 ? OS.GTK_ENTRY_IM_CONTEXT(this.entryHandle) : 0;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (OS.gtk_combo_box_get_active(this.handle) == n) {
                this.clearText();
            }
        } else {
            boolean bl;
            this.ignoreSelect = true;
            int n2 = OS.gtk_container_get_children(this.listHandle);
            int n3 = OS.g_list_nth_data(n2, n);
            boolean bl2 = bl = OS.GTK_WIDGET_STATE(n3) == 3;
            if (bl) {
                OS.gtk_list_unselect_all(this.listHandle);
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            OS.g_list_free(n2);
            this.ignoreSelect = false;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_unselect_all(this.listHandle);
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            this.ignoreSelect = false;
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        if (bl && this.entryHandle != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int n3 = OS.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(n3, n * 1024, n2 * 1024, nArray, nArray2);
            int n4 = OS.pango_layout_get_text(n3);
            int n5 = OS.g_utf8_pointer_to_offset(n4, n4 + nArray[0]) + nArray2[0];
            Point point = this.getSelection();
            if (point.x <= n5 && n5 < point.y && super.dragDetect(n, n2, bl, blArray)) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, blArray);
    }

    int enterExitHandle() {
        return this.fixedHandle;
    }

    int eventWindow() {
        return this.paintWindow();
    }

    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.listHandle != 0 ? this.listHandle : this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.items.length];
        System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
        return stringArray;
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int n = 0;
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                int n2 = OS.gtk_combo_box_get_active(this.handle);
                if (n2 != -1) {
                    n = this.getItem(n2).length();
                }
            } else {
                int n3 = OS.gtk_entry_get_text(this.entryHandle);
                if (n3 != 0) {
                    n = OS.g_utf8_strlen(n3, -1);
                }
            }
            return new Point(0, n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.entryHandle != 0) {
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray, nArray2);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        int n;
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            return OS.gtk_combo_box_get_active(this.handle);
        }
        int n2 = 0;
        int n3 = -1;
        int n4 = n = OS.gtk_container_get_children(this.listHandle);
        while (n4 != 0) {
            int n5 = OS.g_list_data(n4);
            if (OS.GTK_WIDGET_STATE(n5) == 3) {
                n3 = n2;
                break;
            }
            ++n2;
            n4 = OS.g_list_next(n4);
        }
        OS.g_list_free(n);
        return n3;
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            int n = OS.gtk_entry_get_text(this.entryHandle);
            if (n == 0) {
                return "";
            }
            int n2 = OS.strlen(n);
            byte[] byArray = new byte[n2];
            OS.memmove(byArray, n, n2);
            return new String(Converter.mbcsToWcs(null, byArray));
        }
        int n = OS.gtk_combo_box_get_active(this.handle);
        return n != -1 ? this.getItem(n) : "";
    }

    String getText(int n, int n2) {
        return this.getText().substring(n, n2 - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_size_request(this.handle, gtkRequisition);
        return OS.GTK_WIDGET_REQUISITION_HEIGHT(this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = this.entryHandle != 0 ? OS.gtk_entry_get_max_length(this.entryHandle) : 0;
        return n == 0 ? LIMIT : n;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    int gtk_activate(int n) {
        this.postEvent(14);
        return 0;
    }

    int gtk_changed(int n) {
        Object object;
        int n2;
        int n3;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (n == this.handle) {
                int n4;
                if (this.entryHandle == 0) {
                    this.sendEvent(24);
                    if (this.isDisposed()) {
                        return 0;
                    }
                }
                if ((n4 = OS.gtk_combo_box_get_active(this.handle)) != -1) {
                    this.postEvent(13);
                }
                return 0;
            }
        } else if (!this.ignoreSelect) {
            n3 = OS.gtk_entry_get_text(this.entryHandle);
            n2 = OS.strlen(n3);
            object = new byte[n2];
            OS.memmove(object, n3, n2);
            String string = new String(Converter.mbcsToWcs(null, object));
            int n5 = 0;
            while (n5 < this.items.length) {
                if (this.items[n5].equals(string)) {
                    this.postEvent(13);
                    break;
                }
                ++n5;
            }
        }
        n3 = 0;
        n2 = OS.gtk_get_current_event();
        if (n2 != 0) {
            object = new GdkEventKey();
            OS.memmove((GdkEventKey)object, n2, GdkEventKey.sizeof);
            switch (object.type) {
                case 8: {
                    n3 = 1;
                }
            }
            OS.gdk_event_free(n2);
        }
        if (n3 != 0) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0;
    }

    int gtk_commit(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable(this.entryHandle)) {
            return 0;
        }
        int n3 = OS.strlen(n2);
        if (n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 9);
        int n4 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n5 = 17;
        OS.g_signal_handlers_unblock_matched(n, n5, n4, 0, 0, 0, this.entryHandle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(n, OS.commit, n2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(n, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(n, n5, n4, 0, 0, 0, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.entryHandle, this.fixStart);
            OS.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0;
    }

    int gtk_delete_text(int n, int n2, int n3) {
        if (this.lockText) {
            OS.gtk_list_unselect_item(this.listHandle, 0);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
            return 0;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        String string = this.verifyText("", n2, n3);
        if (string == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{n3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.entryHandle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.entryHandle, nArray[0]);
        }
        return 0;
    }

    int gtk_focus_out_event(int n, int n2) {
        this.fixIM();
        return super.gtk_focus_out_event(n, n2);
    }

    int gtk_insert_text(int n, int n2, int n3, int n4) {
        String string;
        if (this.lockText) {
            OS.gtk_list_unselect_item(this.listHandle, 0);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
            return 0;
        }
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, n4, 4);
        if (nArray[0] == -1) {
            int n5 = OS.gtk_entry_get_text(this.entryHandle);
            nArray[0] = OS.g_utf8_strlen(n5, -1);
        }
        if ((string = this.verifyText(string2, nArray[0], nArray[0])) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.entryHandle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(n4, nArray, 4);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0;
    }

    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            this.fixIM();
        }
        if (this.gdkEventKey == -1) {
            n3 = 1;
        }
        this.gdkEventKey = 0;
        return n3;
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n < 0 || n >= this.items.length) {
            return -1;
        }
        int n2 = n;
        while (n2 < this.items.length) {
            if (string.equals(this.items[n2])) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    int paintWindow() {
        int n = this.entryHandle != 0 ? this.entryHandle : this.handle;
        OS.gtk_widget_realize(n);
        int n2 = OS.GTK_WIDGET_WINDOW(n);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0) && (this.style & 8) != 0) {
            return n2;
        }
        int n3 = OS.gdk_window_get_children(n2);
        if (n3 != 0) {
            n2 = OS.g_list_data(n3);
        }
        OS.g_list_free(n3);
        return n2;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    int parentingHandle() {
        return this.fixedHandle;
    }

    void register() {
        int n;
        super.register();
        if (this.buttonHandle != 0) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.listHandle != 0) {
            this.display.addWidget(this.listHandle, this);
        }
        if ((n = this.imContext()) != 0) {
            this.display.addWidget(n, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.listHandle = 0;
        this.entryHandle = 0;
        this.buttonHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0;
        this.fixIM();
    }

    public void remove(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
        this.items = stringArray2;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (OS.gtk_combo_box_get_active(this.handle) == n) {
                this.clearText();
            }
            OS.gtk_combo_box_remove_text(this.handle, n);
        } else {
            this.ignoreSelect = true;
            int n2 = OS.gtk_container_get_children(this.listHandle);
            int n3 = OS.g_list_nth_data(n2, n);
            boolean bl = OS.GTK_WIDGET_STATE(n3) == 3;
            int n4 = OS.g_list_append(0, n3);
            OS.gtk_list_remove_items(this.listHandle, n4);
            OS.g_list_free(n4);
            OS.g_list_free(n2);
            if (bl) {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            this.ignoreSelect = false;
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (n < 0 || n > n2 || n2 >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - (n2 - n + 1)];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n2 + 1, stringArray2, n, stringArray.length - n2 - 1);
        this.items = stringArray2;
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            int n3 = OS.gtk_combo_box_get_active(this.handle);
            if (n <= n3 && n3 <= n2) {
                this.clearText();
            }
            int n4 = n2;
            while (n4 >= n) {
                OS.gtk_combo_box_remove_text(this.handle, n4);
                --n4;
            }
        } else {
            boolean bl = false;
            this.ignoreSelect = true;
            int n5 = 0;
            int n6 = OS.gtk_container_get_children(this.listHandle);
            int n7 = n;
            while (n7 <= n2) {
                int n8 = OS.g_list_nth_data(n6, n7);
                bl |= OS.GTK_WIDGET_STATE(n8) == 3;
                n5 = OS.g_list_append(n5, n8);
                ++n7;
            }
            OS.gtk_list_remove_items(this.listHandle, n5);
            OS.g_list_free(n5);
            OS.g_list_free(n6);
            if (bl) {
                OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            }
            this.ignoreSelect = false;
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.items.length;
        this.items = new String[0];
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
            int n2 = n - 1;
            while (n2 >= 0) {
                OS.gtk_combo_box_remove_text(this.handle, n2);
                --n2;
            }
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_clear_items(this.listHandle, 0, -1);
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
            this.ignoreSelect = false;
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_combo_box_set_active(this.handle, n);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        } else {
            this.ignoreSelect = true;
            OS.gtk_list_select_item(this.listHandle, n);
            this.ignoreSelect = false;
        }
    }

    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0) {
                OS.gtk_widget_modify_base(this.entryHandle, 0, gdkColor);
            }
            OS.g_object_set(this.textRenderer, OS.background_gdk, gdkColor, 0);
        } else {
            OS.gtk_widget_modify_base(this.entryHandle, 0, gdkColor);
            if (this.listHandle != 0) {
                OS.gtk_widget_modify_base(this.listHandle, 0, gdkColor);
            }
        }
    }

    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = bl2 ? this.getTextHeight() : n4;
        return super.setBounds(n, n2, n3, n5, bl, bl2);
    }

    void setFontDescription(int n) {
        super.setFontDescription(n);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0) {
                OS.gtk_widget_modify_font(this.entryHandle, n);
            }
            OS.g_object_set(this.textRenderer, OS.font_desc, n, 0);
            if ((this.style & 8) != 0) {
                int n2 = OS.gtk_combo_box_get_active(this.handle);
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                OS.gtk_combo_box_set_active(this.handle, -1);
                OS.gtk_combo_box_set_active(this.handle, n2);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
            }
        } else {
            OS.gtk_widget_modify_font(this.entryHandle, n);
            if (this.listHandle != 0) {
                OS.gtk_widget_modify_font(this.listHandle, n);
                int n3 = OS.gtk_container_get_children(this.listHandle);
                if (n3 != 0) {
                    int n4 = OS.g_list_length(n3);
                    int n5 = n4 - 1;
                    while (n5 >= 0) {
                        int n6 = OS.gtk_bin_get_child(OS.g_list_nth_data(n3, n5));
                        OS.gtk_widget_modify_font(n6, n);
                        --n5;
                    }
                    OS.g_list_free(n3);
                }
            }
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (this.entryHandle != 0) {
                this.setForegroundColor(this.entryHandle, gdkColor);
            }
            OS.g_object_set(this.textRenderer, OS.foreground_gdk, gdkColor, 0);
        } else {
            this.setForegroundColor(this.entryHandle, gdkColor);
            if (this.listHandle != 0) {
                this.setForegroundColor(this.listHandle, gdkColor);
                int n = OS.gtk_container_get_children(this.listHandle);
                if (n != 0) {
                    int n2 = OS.g_list_length(n);
                    int n3 = n2 - 1;
                    while (n3 >= 0) {
                        int n4 = OS.gtk_bin_get_child(OS.g_list_nth_data(n, n3));
                        this.setForegroundColor(n4, gdkColor);
                        --n3;
                    }
                    OS.g_list_free(n);
                }
            }
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n < 0 || n >= this.items.length) {
            this.error(5);
        }
        this.items[n] = string;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.gtk_combo_box_remove_text(this.handle, n);
            OS.gtk_combo_box_insert_text(this.handle, n, byArray);
        } else {
            this.ignoreSelect = true;
            int n2 = OS.gtk_container_get_children(this.listHandle);
            int n3 = OS.g_list_nth_data(n2, n);
            int n4 = OS.gtk_bin_get_child(n3);
            OS.gtk_label_set_text(n4, byArray);
            OS.g_list_free(n2);
            this.ignoreSelect = false;
        }
    }

    public void setItems(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        n = this.items.length;
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            this.clearText();
            int n2 = n - 1;
            while (n2 >= 0) {
                OS.gtk_combo_box_remove_text(this.handle, n2);
                --n2;
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                String string = stringArray[n2];
                byte[] byArray = Converter.wcsToMbcs(null, string, true);
                OS.gtk_combo_box_insert_text(this.handle, n2, byArray);
                ++n2;
            }
        } else {
            this.ignoreSelect = true;
            this.lockText = true;
            OS.gtk_list_clear_items(this.listHandle, 0, -1);
            int n3 = this.getFontDescription();
            GdkColor gdkColor = this.getForegroundColor();
            int n4 = OS.gtk_widget_get_direction(this.handle);
            int n5 = 0;
            while (n5 < stringArray.length) {
                String string = stringArray[n5];
                byte[] byArray = Converter.wcsToMbcs(null, string, true);
                int n6 = OS.gtk_list_item_new_with_label(byArray);
                int n7 = OS.gtk_bin_get_child(n6);
                this.setForegroundColor(n7, gdkColor);
                OS.gtk_widget_modify_font(n7, n3);
                OS.gtk_widget_set_direction(n7, n4);
                OS.gtk_container_add(this.listHandle, n6);
                OS.gtk_widget_show(n6);
                ++n5;
            }
            this.ignoreSelect = false;
            this.lockText = false;
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
    }

    void setListVisible(boolean bl) {
        this.checkWidget();
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            if (bl) {
                OS.gtk_combo_box_popup(this.handle);
            } else {
                OS.gtk_combo_box_popdown(this.handle);
            }
        }
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0) {
            if (this.listHandle != 0) {
                OS.gtk_widget_set_direction(this.listHandle, 2);
            }
            if (this.entryHandle != 0) {
                OS.gtk_widget_set_direction(this.entryHandle, 2);
            }
        }
    }

    public void setOrientation(int n) {
        this.checkWidget();
        int n2 = 0x6000000;
        if ((n & n2) == 0 || (n & n2) == n2) {
            return;
        }
        this.style &= ~n2;
        this.style |= n & n2;
        int n3 = (n & 0x4000000) != 0 ? 2 : 1;
        OS.gtk_widget_set_direction(this.fixedHandle, n3);
        OS.gtk_widget_set_direction(this.handle, n3);
        if (this.entryHandle != 0) {
            OS.gtk_widget_set_direction(this.entryHandle, n3);
        }
        if (this.listHandle != 0) {
            OS.gtk_widget_set_direction(this.listHandle, n3);
            int n4 = OS.gtk_container_get_children(this.listHandle);
            if (n4 != 0) {
                int n5 = OS.g_list_length(n4);
                int n6 = n5 - 1;
                while (n6 >= 0) {
                    int n7 = OS.gtk_bin_get_child(OS.g_list_nth_data(n4, n6));
                    OS.gtk_widget_set_direction(n7, n3);
                    --n6;
                }
                OS.g_list_free(n4);
            }
        }
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0) {
            OS.gtk_editable_set_position(this.entryHandle, point.x);
            OS.gtk_editable_select_region(this.entryHandle, point.x, point.y);
        }
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            n = this.indexOf(string);
            if (n == -1) {
                return;
            }
            if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
                OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
                OS.gtk_combo_box_set_active(this.handle, n);
                OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
                return;
            }
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, OS.g_utf8_strlen(n = OS.gtk_entry_get_text(this.entryHandle), -1))) == null) {
            return;
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
        }
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
        OS.gtk_entry_set_text(this.entryHandle, byArray);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        }
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
        this.sendEvent(24);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0) {
            OS.gtk_entry_set_max_length(this.entryHandle, n);
        }
    }

    void setToolTipText(Shell shell, String string) {
        if (this.entryHandle != 0) {
            shell.setToolTipText(this.entryHandle, string);
        }
        if (this.buttonHandle != 0) {
            shell.setToolTipText(this.buttonHandle, string);
        }
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
    }

    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                int n2 = this.imContext();
                if (n2 == 0) break;
                int[] nArray = new int[1];
                OS.gtk_im_context_get_preedit_string(n2, nArray, null, null);
                if (nArray[0] == 0) break;
                int n3 = OS.strlen(nArray[0]);
                OS.g_free(nArray[0]);
                if (n3 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    String verifyText(String string, int n, int n2) {
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        int n3 = OS.gtk_get_current_event();
        if (n3 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n3, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(n3);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

