/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.util.Provider;

public final class ProviderCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(ProviderCodec.class);

    public boolean isEncodable(Object object) {
        return object instanceof Provider;
    }

    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        return this.encode((Provider)object);
    }

    public String encode(Provider provider) {
        ArgumentChecker.throwIfNull((Object)provider);
        return provider.getClass().getName();
    }

    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        try {
            Class<?> clazz = Class.forName(string);
            if (Provider.class.isAssignableFrom(clazz)) {
                return clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.log(LogLevel.WARN, "[IGNORE] ClassNotFoundException for ''{0}''.", string);
        }
        catch (InstantiationException instantiationException) {
            log_s_.log(LogLevel.WARN, "[IGNORE] InstantiationException for ''{0}''.", string);
        }
        catch (IllegalAccessException illegalAccessException) {
            log_s_.log(LogLevel.WARN, "[IGNORE] IllegalAccessException for ''{0}''.", string);
        }
        return null;
    }
}

