/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.act;

import java.io.File;
import java.util.EnumSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;
import org.unitarou.ml.BasicMessages;
import org.unitarou.util.Adaptable;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.YukinoshitaException;
import org.unitarou.yukinoshita.model.cmd.ModelInfluence;
import org.unitarou.yukinoshita.view.CollectionController;
import org.unitarou.yukinoshita.view.WindowController;
import org.unitarou.yukinoshita.view.WindowControllerListener;
import org.unitarou.yukinoshita.view.cmd.FireMonitorCommand;
import org.unitarou.yukinoshita.view.jface.act.AbstractAction;
import org.unitarou.yukinoshita.view.jface.dlg.IgoFileDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveAsAction
extends AbstractAction
implements Adaptable {
    private static final Log log_s_ = LogFactory.getLog(SaveAsAction.class);
    private final Adapter adapter_ = new Adapter();

    public SaveAsAction(WindowController windowController) {
        super(windowController);
        windowController.addListener(this.adapter_);
        this.setEnabled(false);
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public void run() {
        if (this.controller_ == null) {
            log_s_.log(LogLevel.WARN, "#setController(...) hasn't call yet. #run() call is ignored.");
            return;
        }
        Control control = Display.getCurrent().getFocusControl();
        control.getParent().forceFocus();
        control.forceFocus();
        CollectionController collectionController = this.controller_.getActiveCollectionController();
        File file = IgoFileDialog.askSaveFile(collectionController.getCollection());
        if (file == null) {
            return;
        }
        try {
            EnumSet<FileManager.SaveResult> enumSet = FileManager.instance().saveAs(collectionController.getCollection(), file);
            FileManager.instance().insertFileHistory(file);
            if (enumSet.contains((Object)FileManager.SaveResult.CHANGE_CHARSET)) {
                FireMonitorCommand fireMonitorCommand = new FireMonitorCommand(ModelInfluence.ROOT_GAME_TREE);
                collectionController.getEventBroker().executeCommand(fireMonitorCommand);
            }
            if (enumSet.contains((Object)FileManager.SaveResult.SAVE_OK)) {
                collectionController.clearChangedFlag();
            }
        }
        catch (YukinoshitaException yukinoshitaException) {
            log_s_.log(LogLevel.ERROR, yukinoshitaException, BasicMessages.NT_FILE_SAVE_FAILURE.get());
            MessageDialog.openError(Display.getCurrent().getActiveShell(), BasicMessages.NT_FILE_SAVE_FAILURE.get(), yukinoshitaException.getLocalizedMessage());
        }
    }

    private class Adapter
    implements WindowControllerListener {
        private Adapter() {
        }

        public void changeActive(CollectionController collectionController) {
            SaveAsAction.this.setEnabled(collectionController != null);
        }
    }
}

