/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.ann;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.UEnum;
import org.unitarou.swt.ComboStyle;
import org.unitarou.swt.Swts;
import org.unitarou.swt.UCombo;
import org.unitarou.swt.UComboProvider;
import org.unitarou.swt.UComboProviderFactory;
import org.unitarou.yukinoshita.view.jface.ann.Editor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EnumEditor<T>
extends Editor {
    private final UCombo<T> combo_;

    public static <E extends UEnum> EnumEditor<E> createUEnum(Class<E> clazz, EnumSet<ComboStyle> enumSet) {
        List<E> list = UEnum.getAll(clazz);
        UComboProvider uComboProvider = UComboProviderFactory.createForUEnum();
        return new EnumEditor<E>(list, enumSet, uComboProvider);
    }

    public static <E extends Enum<E>> EnumEditor<E> createEnum(Class<E> clazz, EnumSet<ComboStyle> enumSet) {
        return EnumEditor.createEnum(enumSet, EnumSet.allOf(clazz));
    }

    public static <E extends Enum<E>> EnumEditor<E> createEnum(EnumSet<ComboStyle> enumSet, EnumSet<E> enumSet2) {
        UComboProvider uComboProvider = UComboProviderFactory.createForEnum();
        return new EnumEditor<E>(new ArrayList<E>(enumSet2), enumSet, uComboProvider);
    }

    public static <E extends Enum<E>> EnumEditor<E> createSgfEnum(Class<E> clazz, EnumSet<ComboStyle> enumSet) {
        return EnumEditor.createSgfEnum(enumSet, EnumSet.allOf(clazz));
    }

    public static <E extends Enum<E>> EnumEditor<E> createSgfEnum(EnumSet<ComboStyle> enumSet, EnumSet<E> enumSet2) {
        UComboProvider uComboProvider = UComboProviderFactory.createForSgfEnum();
        return new EnumEditor<E>(new ArrayList<E>(enumSet2), enumSet, uComboProvider);
    }

    public EnumEditor(T[] TArray, EnumSet<ComboStyle> enumSet, UComboProvider<T> uComboProvider) {
        this(Arrays.asList(TArray), enumSet, uComboProvider);
    }

    public EnumEditor(List<T> list, EnumSet<ComboStyle> enumSet, UComboProvider<T> uComboProvider) {
        ArgumentChecker.throwIfNull(list, enumSet, uComboProvider);
        this.combo_ = new UCombo<T>(uComboProvider, enumSet);
        this.combo_.addAll(list);
    }

    public Combo createContents(Composite composite) {
        Combo combo = this.combo_.createContents(composite);
        Listener listener = new Listener();
        combo.addSelectionListener((SelectionListener)listener);
        combo.addFocusListener((FocusListener)listener);
        Swts.defeatMouseWheel((Widget)combo);
        return combo;
    }

    public Combo getControl() {
        return this.combo_.getControl();
    }

    @Override
    public void close() {
    }

    @Override
    String getString() {
        return this.combo_.getId();
    }

    public T getSelected() {
        return this.combo_.getSelected();
    }

    public String getText() {
        return this.combo_.getText();
    }

    public void select(T t) {
        this.combo_.select(t);
    }

    public void setText(String string) {
        this.combo_.setText(string);
    }

    private class Listener
    implements SelectionListener,
    FocusListener {
        private Listener() {
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            EnumEditor.this.fireModifyText((Widget)EnumEditor.this.combo_.getControl());
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            EnumEditor.this.fireModifyText((Widget)EnumEditor.this.combo_.getControl());
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            EnumEditor.this.fireModifyText((Widget)EnumEditor.this.combo_.getControl());
        }
    }
}

