/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.board.eh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.ml.Message;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.cmd.NodeListCommand;
import org.unitarou.yukinoshita.model.cmd.SequentialCommand;
import org.unitarou.yukinoshita.model.cmd.UpdateProperty;
import org.unitarou.yukinoshita.view.jface.board.BlockStatus;
import org.unitarou.yukinoshita.view.jface.board.eh.BlockSituation;
import org.unitarou.yukinoshita.view.jface.board.eh.EventDelegator;
import org.unitarou.yukinoshita.view.jface.resource.CanvasCursor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountEventDelegator
implements EventDelegator {
    private static final Message LB_COUNT_TERRITORY = new Message(CountEventDelegator.class, "lbCountTerritory");
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;
    private NodeView nodeView_ = null;
    private final Set<SgfPoint> tb_ = new HashSet<SgfPoint>();
    private final Set<SgfPoint> tw_ = new HashSet<SgfPoint>();
    private final Set<SgfPoint> b_ = new HashSet<SgfPoint>();
    private final Set<SgfPoint> w_ = new HashSet<SgfPoint>();
    private Point mousePosition_ = null;
    private SgfColor territoryColor_ = SgfColor.BLACK;

    @Override
    public void keyPressed(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
        int n = keyEvent.keyCode | keyEvent.stateMask;
        switch (n) {
            case 131072: 
            case 262144: {
                this.territoryColor_ = this.territoryColor_.opposite();
                this.mousePosition_ = null;
            }
        }
    }

    @Override
    public void keyReleased(NodeView nodeView, EventBroker eventBroker, KeyEvent keyEvent) {
    }

    @Override
    public void resetStatus() {
        this.eventBroker_ = EventBroker.NULL_BROKER;
        this.nodeView_ = null;
        this.tb_.clear();
        this.tw_.clear();
        this.b_.clear();
        this.w_.clear();
        this.mousePosition_ = null;
        this.territoryColor_ = SgfColor.BLACK;
    }

    @Override
    public BlockSituation getBlockSituation(NodeView nodeView, BlockStatus blockStatus, EventBroker eventBroker, MouseEvent mouseEvent) {
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)eventBroker);
        this.eventBroker_ = eventBroker;
        if (!nodeView.equals(this.nodeView_)) {
            this.nodeView_ = nodeView;
            this.updateStatus();
        }
        Point point = null;
        if (mouseEvent != null) {
            point = new Point(mouseEvent.x, mouseEvent.y);
        }
        BlockSituation blockSituation = new BlockSituation();
        if (blockStatus.getPoint() == null || point != null && point.equals((Object)this.mousePosition_)) {
            return blockSituation;
        }
        this.mousePosition_ = point;
        EnumSet<SgfPointType> enumSet = blockStatus.getPointTypes();
        SgfPoint sgfPoint = blockStatus.getPoint();
        if (this.tb_.contains(sgfPoint)) {
            blockSituation.setCursor(CanvasCursor.MARK_TERRITORY_AREA_EMPTY.getCursor());
            HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
            this.findNeighbor(sgfPoint, hashSet, this.tb_);
            blockSituation.setTransientProperty(new Property(SgfId.TERRITORY_BLACK, hashSet));
        } else if (this.tw_.contains(sgfPoint)) {
            blockSituation.setCursor(CanvasCursor.MARK_TERRITORY_AREA_EMPTY.getCursor());
            HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
            this.findNeighbor(sgfPoint, hashSet, this.tw_);
            blockSituation.setTransientProperty(new Property(SgfId.TERRITORY_WHITE, hashSet));
        } else if (enumSet.contains((Object)SgfPointType.BLACK)) {
            blockSituation.setCursor(CanvasCursor.MARK_TERRITORY_AREA_WHITE.getCursor());
            HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
            this.findNeighbor(sgfPoint, hashSet, this.b_);
            blockSituation.setTransientProperty(new Property(SgfId.TERRITORY_WHITE, hashSet));
        } else if (enumSet.contains((Object)SgfPointType.WHITE)) {
            blockSituation.setCursor(CanvasCursor.MARK_TERRITORY_AREA_BLACK.getCursor());
            HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
            this.findNeighbor(sgfPoint, hashSet, this.w_);
            blockSituation.setTransientProperty(new Property(SgfId.TERRITORY_BLACK, hashSet));
        } else if (enumSet.contains((Object)SgfPointType.EMPTY)) {
            HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
            SgfColor sgfColor = this.detectTerritoryType(sgfPoint, hashSet);
            if (SgfColor.BLACK.equals(sgfColor)) {
                blockSituation.setCursor(CanvasCursor.MARK_TERRITORY_AREA_BLACK.getCursor());
                blockSituation.setTransientProperty(new Property(SgfId.TERRITORY_BLACK, hashSet));
            } else if (SgfColor.WHITE.equals(sgfColor)) {
                blockSituation.setCursor(CanvasCursor.MARK_TERRITORY_AREA_WHITE.getCursor());
                blockSituation.setTransientProperty(new Property(SgfId.TERRITORY_WHITE, hashSet));
            } else if (SgfColor.BLACK.equals(this.territoryColor_)) {
                blockSituation.setCursor(CanvasCursor.MARK_TERRITORY_BLACK.getCursor());
                blockSituation.setTransientProperty(new Property(SgfId.TERRITORY_BLACK, sgfPoint.getString()));
            } else if (SgfColor.WHITE.equals(this.territoryColor_)) {
                blockSituation.setCursor(CanvasCursor.MARK_TERRITORY_WHITE.getCursor());
                blockSituation.setTransientProperty(new Property(SgfId.TERRITORY_WHITE, sgfPoint.getString()));
            }
        }
        return blockSituation;
    }

    private void updateStatus() {
        this.tb_.clear();
        this.tb_.addAll(this.getPointSet(SgfId.TERRITORY_BLACK));
        this.tw_.clear();
        this.tw_.addAll(this.getPointSet(SgfId.TERRITORY_WHITE));
        this.b_.clear();
        this.b_.addAll(this.nodeView_.getIgoBoard().position(SgfColor.BLACK));
        this.w_.clear();
        this.w_.addAll(this.nodeView_.getIgoBoard().position(SgfColor.WHITE));
        ArrayList<NodeListCommand> arrayList = new ArrayList<NodeListCommand>(2);
        Point point = this.addCountTerritoryCommands(arrayList, this.nodeView_.getSize().all());
        if (!arrayList.isEmpty()) {
            SequentialCommand sequentialCommand = new SequentialCommand(LB_COUNT_TERRITORY.get(point.x, point.y), arrayList.toArray(new NodeListCommand[arrayList.size()]));
            this.eventBroker_.executeCommand(sequentialCommand);
        }
    }

    private Point addCountTerritoryCommands(List<NodeListCommand> list, Set<SgfPoint> set) {
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        HashSet<SgfPoint> hashSet2 = new HashSet<SgfPoint>();
        this.calcTbTw(hashSet, hashSet2, set);
        this.addUpdateCommand(SgfId.TERRITORY_BLACK, hashSet, list);
        this.addUpdateCommand(SgfId.TERRITORY_WHITE, hashSet2, list);
        return new Point(hashSet.size(), hashSet2.size());
    }

    private void calcTbTw(Set<SgfPoint> set, Set<SgfPoint> set2, Set<SgfPoint> set3) {
        HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
        HashSet<SgfPoint> hashSet2 = new HashSet<SgfPoint>(set3);
        while (!hashSet2.isEmpty()) {
            SgfPoint sgfPoint = (SgfPoint)hashSet2.iterator().next();
            if (this.b_.contains(sgfPoint) || this.w_.contains(sgfPoint) || this.tb_.contains(sgfPoint) || this.tw_.contains(sgfPoint)) {
                hashSet2.remove(sgfPoint);
                continue;
            }
            hashSet.clear();
            SgfColor sgfColor = this.detectTerritoryType(sgfPoint, hashSet);
            hashSet2.removeAll(hashSet);
            if (SgfColor.BLACK.equals(sgfColor)) {
                set.addAll(hashSet);
                this.tb_.addAll(hashSet);
                continue;
            }
            if (!SgfColor.WHITE.equals(sgfColor)) continue;
            set2.addAll(hashSet);
            this.tw_.addAll(hashSet);
        }
    }

    private void addUpdateCommand(SgfId sgfId, Set<SgfPoint> set, List<NodeListCommand> list) {
        if (set.isEmpty()) {
            return;
        }
        list.add(new UpdateProperty(Property.EMPTY_ARRAY, new Property(sgfId, set), null));
    }

    private Set<SgfPoint> getPointSet(SgfId sgfId) {
        Property property = this.nodeView_.getProperty(sgfId);
        if (property == null) {
            return Collections.emptySet();
        }
        return SgfPoint.parseAsSet(this.nodeView_.getSize(), property.getStrings());
    }

    private SgfColor detectTerritoryType(SgfPoint sgfPoint, Set<SgfPoint> set) {
        HashSet<SgfColor> hashSet = new HashSet<SgfColor>();
        set.add(sgfPoint);
        this.checkAllNeighbor(sgfPoint, set, hashSet);
        if (hashSet.size() != 1) {
            return null;
        }
        return (SgfColor)hashSet.iterator().next();
    }

    private void checkAllNeighbor(SgfPoint sgfPoint, Set<SgfPoint> set, Set<SgfColor> set2) {
        for (SgfPoint sgfPoint2 : sgfPoint.neighbors()) {
            if (set.contains(sgfPoint2)) continue;
            if (this.tb_.contains(sgfPoint2)) {
                set2.add(SgfColor.BLACK);
                continue;
            }
            if (this.tw_.contains(sgfPoint2)) {
                set2.add(SgfColor.WHITE);
                continue;
            }
            if (this.b_.contains(sgfPoint2)) {
                set2.add(SgfColor.BLACK);
                continue;
            }
            if (this.w_.contains(sgfPoint2)) {
                set2.add(SgfColor.WHITE);
                continue;
            }
            set.add(sgfPoint2);
            this.checkAllNeighbor(sgfPoint2, set, set2);
        }
    }

    @Override
    public boolean executeEvent(NodeView nodeView, BlockStatus blockStatus, MouseEvent mouseEvent, EventBroker eventBroker) {
        Object object;
        ArgumentChecker.throwIfNull((Object)nodeView, (Object)blockStatus, (Object)mouseEvent, (Object)eventBroker);
        SgfPoint sgfPoint = blockStatus.getPoint();
        if (blockStatus.getPoint() == null) {
            return false;
        }
        if (mouseEvent.button != 1) {
            return false;
        }
        Point point = new Point(0, 0);
        EnumSet<SgfPointType> enumSet = blockStatus.getPointTypes();
        ArrayList<UpdateProperty> arrayList = new ArrayList<UpdateProperty>();
        if (this.tb_.contains(blockStatus.getPoint())) {
            object = new HashSet<SgfPoint>();
            this.findNeighbor(sgfPoint, (Set<SgfPoint>)object, this.tb_);
            this.tb_.removeAll((Collection<?>)object);
            arrayList.add(new UpdateProperty(new Property[]{new Property(SgfId.TERRITORY_BLACK, (Collection<SgfPoint>)object)}, null, null));
            point.x = -object.size();
        } else if (this.tw_.contains(blockStatus.getPoint())) {
            object = new HashSet();
            this.findNeighbor(sgfPoint, (Set<SgfPoint>)object, this.tw_);
            this.tw_.removeAll((Collection<?>)object);
            arrayList.add(new UpdateProperty(new Property[]{new Property(SgfId.TERRITORY_WHITE, (Collection<SgfPoint>)object)}, null, null));
            point.y = -object.size();
        } else if (enumSet.contains((Object)SgfPointType.BLACK)) {
            Object object2;
            object = new HashSet();
            this.findNeighbor(sgfPoint, (Set<SgfPoint>)object, this.b_);
            this.tw_.addAll((Collection<SgfPoint>)object);
            point.y = object.size() * 2;
            HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
            HashSet<SgfColor> hashSet2 = new HashSet<SgfColor>();
            Object object3 = object.iterator();
            while (object3.hasNext()) {
                object2 = (SgfPoint)object3.next();
                this.checkAllNeighbor((SgfPoint)object2, hashSet, hashSet2);
            }
            object3 = new HashSet();
            object2 = new HashSet();
            this.calcTbTw((Set<SgfPoint>)object3, (Set<SgfPoint>)object2, hashSet);
            object.addAll(object2);
            this.tw_.addAll((Collection<SgfPoint>)object2);
            arrayList.add(new UpdateProperty(Property.EMPTY_ARRAY, new Property(SgfId.TERRITORY_WHITE, (Collection<SgfPoint>)object), null));
            point.y += object2.size();
        } else if (enumSet.contains((Object)SgfPointType.WHITE)) {
            Object object4;
            object = new HashSet();
            this.findNeighbor(sgfPoint, (Set<SgfPoint>)object, this.w_);
            this.tb_.addAll((Collection<SgfPoint>)object);
            point.x = object.size() * 2;
            HashSet<SgfPoint> hashSet = new HashSet<SgfPoint>();
            HashSet<SgfColor> hashSet3 = new HashSet<SgfColor>();
            Object object5 = object.iterator();
            while (object5.hasNext()) {
                object4 = (SgfPoint)object5.next();
                this.checkAllNeighbor((SgfPoint)object4, hashSet, hashSet3);
            }
            object5 = new HashSet();
            object4 = new HashSet();
            this.calcTbTw((Set<SgfPoint>)object5, (Set<SgfPoint>)object4, hashSet);
            object.addAll(object5);
            this.tb_.addAll((Collection<SgfPoint>)object5);
            arrayList.add(new UpdateProperty(Property.EMPTY_ARRAY, new Property(SgfId.TERRITORY_BLACK, (Collection<SgfPoint>)object), null));
            point.x += object5.size();
        } else if (enumSet.contains((Object)SgfPointType.EMPTY)) {
            object = new HashSet();
            SgfPoint sgfPoint2 = blockStatus.getPoint();
            SgfColor sgfColor = this.detectTerritoryType(sgfPoint2, (Set<SgfPoint>)object);
            if (SgfColor.BLACK.equals(sgfColor)) {
                this.tb_.addAll((Collection<SgfPoint>)object);
                arrayList.add(new UpdateProperty(Property.EMPTY_ARRAY, new Property(SgfId.TERRITORY_BLACK, (Collection<SgfPoint>)object), null));
                point.x = object.size();
            } else if (SgfColor.WHITE.equals(sgfColor)) {
                this.tw_.addAll((Collection<SgfPoint>)object);
                arrayList.add(new UpdateProperty(Property.EMPTY_ARRAY, new Property(SgfId.TERRITORY_WHITE, (Collection<SgfPoint>)object), null));
                point.y = object.size();
            } else if (SgfColor.BLACK.equals(this.territoryColor_)) {
                this.tb_.add(sgfPoint2);
                arrayList.add(new UpdateProperty(Property.EMPTY_ARRAY, new Property(SgfId.TERRITORY_BLACK, sgfPoint2.getString()), null));
                point.x = 1;
            } else if (SgfColor.WHITE.equals(this.territoryColor_)) {
                this.tw_.add(sgfPoint2);
                arrayList.add(new UpdateProperty(Property.EMPTY_ARRAY, new Property(SgfId.TERRITORY_WHITE, sgfPoint2.getString()), null));
                point.y = 1;
            }
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        object = new SequentialCommand(LB_COUNT_TERRITORY.get(point.x, point.y), arrayList.toArray(new NodeListCommand[arrayList.size()]));
        this.eventBroker_.executeCommand((NodeListCommand)object);
        return true;
    }

    private void findNeighbor(SgfPoint sgfPoint, Set<SgfPoint> set, Set<SgfPoint> set2) {
        set.add(sgfPoint);
        for (SgfPoint sgfPoint2 : sgfPoint.neighbors()) {
            if (set.contains(sgfPoint2) || !set2.contains(sgfPoint2)) continue;
            this.findNeighbor(sgfPoint2, set, set2);
        }
    }
}

