/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.db;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.unitarou.io.Ios;
import org.unitarou.ml.Message;
import org.unitarou.sgf.io.SgfIos;
import org.unitarou.sgf.parser.SgfLog;
import org.unitarou.util.PeriodPredictor;
import org.unitarou.util.StopWatch;
import org.unitarou.util.Times;
import org.unitarou.yukinoshita.Application;
import org.unitarou.yukinoshita.DatabaseManager;
import org.unitarou.yukinoshita.FileManager;
import org.unitarou.yukinoshita.Yukinoshita;
import org.unitarou.yukinoshita.context.CurrentContext;
import org.unitarou.yukinoshita.model.db.Database;
import org.unitarou.yukinoshita.model.db.DatabaseStatistics;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.db.UpdateDatabaseDialog;
import org.unitarou.yukinoshita.view.jface.db.UpdateMode;
import org.unitarou.yukinoshita.view.jface.util.SwtFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseStatusPanel
implements YukinoshitaPanel {
    private static final Message LB_DB_STATUS = new Message(DatabaseStatusPanel.class, "lbDbStatus");
    private static final Message LB_FILE_COUNTS = new Message(DatabaseStatusPanel.class, "lbFileCounts");
    private static final Message LB_GAME_COUNTS = new Message(DatabaseStatusPanel.class, "lbGameCounts");
    private static final Message LB_PROBLEM_COUNTS = new Message(DatabaseStatusPanel.class, "lbProblemCounts");
    private static final Message LN_UPDATE_DB = new Message(DatabaseStatusPanel.class, "lnUpdateDatabase");
    private static final Message LB_UPDATE_DATABASE = new Message(DatabaseStatusPanel.class, "lbUpdateDatabase");
    private static final Message NT_INITIALIZE_TABLES = new Message(DatabaseStatusPanel.class, "ntInitializeTables");
    private static final Message NT_LIST_FILES = new Message(DatabaseStatusPanel.class, "ntListFiles");
    private static final Message NT_DELETE_NOT_FOUND_RECORD = new Message(DatabaseStatusPanel.class, "ntDeleteNotFoundRecord");
    private static final Message NT_INSERT_RECORD = new Message(DatabaseStatusPanel.class, "ntInsertRecord");
    private static final Message NT_INSERT_RECORD_TIME_LEFT = new Message(DatabaseStatusPanel.class, "ntInsertRecordTimeLeft");
    private static final Message NT_TARGET_DIR = new Message(DatabaseStatusPanel.class, "ntTargetDir");
    private static final Message LB_FINISH_UPDATE_DATABASE = new Message(DatabaseStatusPanel.class, "lbFinishUpdateDatabase");
    private static final Message MSG_FINISH_UPDATE_DATABASE = new Message(DatabaseStatusPanel.class, "msgFinishUpdateDatabase");
    private Group frame_ = null;
    private Label lbFileCounts_ = null;
    private Label lbGameCounts_ = null;
    private Label lbProblemCounts_ = null;

    @Override
    public Control createContents(Composite composite) {
        this.frame_ = SwtFactory.createGroup(composite, 0);
        this.frame_.setText(LB_DB_STATUS.get());
        this.frame_.setLayout((Layout)new GridLayout(1, false));
        this.lbFileCounts_ = new Label((Composite)this.frame_, 0);
        this.lbFileCounts_.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.lbGameCounts_ = new Label((Composite)this.frame_, 0);
        this.lbGameCounts_.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.lbProblemCounts_ = new Label((Composite)this.frame_, 0);
        this.lbProblemCounts_.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        Link link = new Link((Composite)this.frame_, 0);
        link.setText(LN_UPDATE_DB.get());
        link.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DatabaseStatusPanel.this.updateDatabase();
            }
        });
        this.updateStatistics();
        return this.frame_;
    }

    public void updateStatistics() {
        if (this.frame_ == null) {
            return;
        }
        DatabaseStatistics databaseStatistics = DatabaseManager.instance().getDatabaseStatistics();
        this.lbFileCounts_.setText(LB_FILE_COUNTS.get((Object)databaseStatistics.getFileCount()));
        this.lbGameCounts_.setText(LB_GAME_COUNTS.get((Object)databaseStatistics.getGameCount()));
        this.lbProblemCounts_.setText(LB_PROBLEM_COUNTS.get((Object)databaseStatistics.getProblemCount()));
        this.frame_.layout();
    }

    private void updateDatabase() {
        UpdateDatabaseDialog updateDatabaseDialog = new UpdateDatabaseDialog(this.frame_.getShell());
        if (0 != updateDatabaseDialog.open()) {
            return;
        }
        UpdateMode updateMode = updateDatabaseDialog.getUpdateMode();
        CurrentContext currentContext = Yukinoshita.context(null);
        currentContext.setAttribute(Database.FORCE_DB_UPDATE, updateMode == UpdateMode.ALL_FILES);
        this.updateDatabaseImpl(updateDatabaseDialog.getPaths(), updateMode);
        this.updateStatistics();
    }

    private void updateDatabaseImpl(File[] fileArray, UpdateMode updateMode) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        progressMonitorDialog.create();
        progressMonitorDialog.getShell().setText(LB_UPDATE_DATABASE.get());
        try {
            Runnable runnable = new Runnable(fileArray, updateMode);
            progressMonitorDialog.run(true, true, runnable);
            progressMonitorDialog.close();
            Yukinoshita.application().openMessageDialog(Application.MessageLevel.INFORMATION, LB_FINISH_UPDATE_DATABASE.get(), MSG_FINISH_UPDATE_DATABASE.get(Integer.toString(runnable.nOfFiles_), Integer.toString(runnable.TOTAL_KB), Times.formatMSS(runnable.elapsedNano_)));
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public Control getControl() {
        return this.frame_;
    }

    @Override
    public void close() {
    }

    @Override
    public Object getAdapter(Class<?> clazz) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Runnable
    implements IRunnableWithProgress {
        private static final int SIZE_KB = 150;
        private final File[] paths_;
        private final UpdateMode mode_;
        private long elapsedNano_;
        private int nOfFiles_;
        private int TOTAL_KB;
        private final Map<File, List<SgfLog.SgfMessage>> errorMessageMap_;

        private Runnable(File[] fileArray, UpdateMode updateMode) {
            this.paths_ = fileArray;
            this.mode_ = updateMode;
            this.elapsedNano_ = 0L;
            this.errorMessageMap_ = new HashMap<File, List<SgfLog.SgfMessage>>();
        }

        @Override
        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
            StopWatch stopWatch = new StopWatch();
            if (this.mode_ == UpdateMode.REBUILD) {
                iProgressMonitor.beginTask(NT_INITIALIZE_TABLES.get(), -1);
                DatabaseManager.instance().deleteAllFileIndices();
            }
            iProgressMonitor.beginTask(NT_LIST_FILES.get(), -1);
            ArrayList<File> arrayList = new ArrayList<File>();
            for (File serializable : this.paths_) {
                this.findSgfFiles(iProgressMonitor, serializable, arrayList);
            }
            iProgressMonitor.beginTask(NT_DELETE_NOT_FOUND_RECORD.get(), -1);
            DatabaseManager.instance().deleteNotFoundFileIndex();
            iProgressMonitor.beginTask(NT_INSERT_RECORD.get(), arrayList.size());
            PeriodPredictor periodPredictor = new PeriodPredictor();
            periodPredictor.start();
            int n = 0;
            this.nOfFiles_ = arrayList.size();
            this.TOTAL_KB = this.calcFileSizeKb(arrayList);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Object object;
                if (iProgressMonitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ArrayList<File> arrayList2 = new ArrayList<File>(75);
                long l = 0L;
                int n2 = 0;
                while (l < 153600L && iterator.hasNext()) {
                    object = (File)iterator.next();
                    arrayList2.add((File)object);
                    l += ((File)object).length();
                    n = (int)((long)n + ((File)object).length());
                    ++n2;
                }
                iProgressMonitor.subTask(((File)arrayList2.get(0)).getAbsolutePath());
                object = FileManager.instance().refreshIndex(arrayList2);
                this.errorMessageMap_.putAll((Map<File, List<SgfLog.SgfMessage>>)object);
                periodPredictor.lap();
                iProgressMonitor.setTaskName(NT_INSERT_RECORD_TIME_LEFT.get(String.valueOf(arrayList.size()), Times.formatMSS(periodPredictor.passing()), this.getEstimated(periodPredictor, this.TOTAL_KB - n / 1024)));
                iProgressMonitor.worked(n2);
            }
            this.elapsedNano_ = stopWatch.stop();
            iProgressMonitor.done();
        }

        private int calcFileSizeKb(List<File> list) {
            long l = 0L;
            for (File file : list) {
                l += file.length();
            }
            return (int)(l / 1024L);
        }

        private String getEstimated(PeriodPredictor periodPredictor, int n) {
            return Times.formatMSS(periodPredictor.average() * (long)(n / 150));
        }

        private void findSgfFiles(IProgressMonitor iProgressMonitor, File file, List<File> list) throws InterruptedException {
            File[] fileArray;
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            iProgressMonitor.subTask(NT_TARGET_DIR.get((Object)file.getAbsolutePath()));
            File[] fileArray2 = fileArray = file.listFiles(SgfIos.SGF_FILE_FILTER);
            int n = fileArray2.length;
            for (int i = 0; i < n; ++i) {
                File file2 = fileArray2[i];
                list.add(file2);
            }
            for (File file3 : fileArray2 = file.listFiles(Ios.NORMAL_DIR_FILETER)) {
                this.findSgfFiles(iProgressMonitor, file3, list);
            }
        }
    }
}

