/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.yukinoshita.view.jface.gi;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Text;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Objects;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.PropertyType;
import org.unitarou.sgf.type.GameType;
import org.unitarou.swt.Swts;
import org.unitarou.yukinoshita.events.EventBroker;
import org.unitarou.yukinoshita.events.EventBrokerMonitor;
import org.unitarou.yukinoshita.model.NodeList;
import org.unitarou.yukinoshita.model.NodeView;
import org.unitarou.yukinoshita.model.RgtProxy;
import org.unitarou.yukinoshita.view.jface.YukinoshitaPanel;
import org.unitarou.yukinoshita.view.jface.gi.GiLine;
import org.unitarou.yukinoshita.view.monitor.GameInfoNodeMonitor;
import org.unitarou.yukinoshita.view.monitor.GameMonitor;
import org.unitarou.yukinoshita.view.monitor.MouseWheelMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameInfoSheet
implements YukinoshitaPanel,
EventBrokerMonitor {
    private GameType gameType_ = GameType.GAME;
    private ScrolledComposite scFrame_ = null;
    private Composite frame_ = null;
    private final List<GiLine> giLines_ = new ArrayList<GiLine>();
    private final Adapter adapter_ = new Adapter();
    private EventBroker eventBroker_ = EventBroker.NULL_BROKER;

    @Override
    public Object getAdapter(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isAssignableFrom(this.adapter_.getClass())) {
            return this.adapter_;
        }
        return null;
    }

    @Override
    public Control createContents(Composite composite) {
        ArgumentChecker.throwIfNull((Object)composite);
        this.scFrame_ = new ScrolledComposite(composite, 512);
        this.scFrame_.setExpandHorizontal(true);
        this.scFrame_.setExpandVertical(true);
        this.frame_ = new Composite((Composite)this.scFrame_, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 4;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        this.frame_.setLayout((Layout)gridLayout);
        for (GiLine giLine : this.giLines_) {
            Text text = giLine.createContents(this.frame_);
            GridData gridData = new GridData(4, 4, false, false);
            text.setLayoutData((Object)gridData);
        }
        this.scFrame_.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                GameInfoSheet.this.resized();
            }
        });
        this.scFrame_.setContent((Control)this.frame_);
        return this.scFrame_;
    }

    private void resized() {
        Point point = Geometry.getSize(this.scFrame_.getClientArea());
        point = this.frame_.computeSize(point.x, -1);
        this.scFrame_.setMinSize(point);
        for (GiLine giLine : this.giLines_) {
            GridData gridData = (GridData)giLine.getControl().getLayoutData();
            gridData.widthHint = point.x;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public Control getControl() {
        return this.scFrame_;
    }

    public GameType getGameType() {
        return this.gameType_;
    }

    public void setGameTypeId(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        this.gameType_ = GameType.parseQuietly(string, GameType.GAME);
    }

    public void addLine(GiLine giLine) {
        ArgumentChecker.throwIfNull((Object)giLine);
        this.giLines_.add(giLine);
    }

    public void setLabel(Properties properties) {
        ArgumentChecker.throwIfNull((Object)properties);
        for (GiLine giLine : this.giLines_) {
            giLine.setLabel(properties);
        }
    }

    @Override
    public void setEventBroker(EventBroker eventBroker) {
        ArgumentChecker.throwIfNull((Object)eventBroker);
        this.eventBroker_.removeView(this);
        this.eventBroker_ = eventBroker;
        this.eventBroker_.addView(this);
    }

    public void update(Node node) {
        ArgumentChecker.throwIfNull((Object)node);
        for (GiLine giLine : this.giLines_) {
            giLine.currentChanged(node);
        }
        this.frame_.pack();
        this.resized();
    }

    private class Adapter
    implements MouseWheelMonitor,
    GameMonitor,
    GameInfoNodeMonitor {
        private Adapter() {
        }

        public boolean mouseWheelRolled(Point point, int n) {
            boolean bl = Swts.isMouseOn((Control)GameInfoSheet.this.frame_);
            for (GiLine giLine : GameInfoSheet.this.giLines_) {
                bl |= Swts.isMouseOn((Control)giLine.getControl());
            }
            if (!bl) {
                return false;
            }
            ScrollBar scrollBar = GameInfoSheet.this.scFrame_.getVerticalBar();
            if (scrollBar == null) {
                return true;
            }
            int n2 = scrollBar.getSelection();
            n2 = Objects.preventOverRange(n2 + n * 10, scrollBar.getMinimum(), scrollBar.getMaximum());
            if (scrollBar.getSelection() != n2) {
                scrollBar.setSelection(n2);
                GameInfoSheet.this.scFrame_.setOrigin(0, n2);
            }
            return true;
        }

        public void update(RgtProxy rgtProxy) {
            ArgumentChecker.throwIfNull((Object)rgtProxy);
            if (GameInfoSheet.this.scFrame_ == null) {
                return;
            }
            NodeList nodeList = rgtProxy.getNodeList();
            for (int i = rgtProxy.getCurrentNodeIndex(); 0 <= i; --i) {
                NodeView nodeView = nodeList.getNodeView(i);
                if (!nodeView.containsPropertyType(PropertyType.GAME_INFO)) continue;
                this.gameInfoChanged(nodeView);
                Point point = GameInfoSheet.this.scFrame_.getOrigin();
                if (point.x != 0 || point.y != 0) {
                    GameInfoSheet.this.scFrame_.setOrigin(0, 0);
                }
                return;
            }
            this.gameInfoChanged(nodeList.getNodeView(0));
        }

        public void gameInfoChanged(NodeView nodeView) {
            ArgumentChecker.throwIfNull((Object)nodeView);
            if (GameInfoSheet.this.scFrame_ == null) {
                return;
            }
            GameInfoSheet.this.update(nodeView.copyNode());
        }
    }
}

