/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    static final int INSET = 3;
    static final int ListProc;
    static final TCHAR ListClass;

    static {
        ListClass = new TCHAR(0, "LISTBOX", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ListClass, wNDCLASS);
        ListProc = wNDCLASS.lpfnWndProc;
    }

    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n));
    }

    public void add(String string) {
        TCHAR tCHAR;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.SendMessage(this.handle, 384, 0, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -1) {
            this.error(14);
        }
        if (n == -2) {
            this.error(14);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void add(String string, int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == -1) {
            this.error(6);
        }
        if ((n2 = OS.SendMessage(this.handle, 385, n, tCHAR = new TCHAR(this.getCodePage(), string, true))) == -2) {
            this.error(14);
        }
        if (n2 == -1) {
            int n3 = OS.SendMessage(this.handle, 395, 0, 0);
            if (n >= 0 && n <= n3) {
                this.error(14);
            } else {
                this.error(6);
            }
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, true);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        boolean bl = false;
        switch (n2) {
            case 276: 
            case 277: {
                boolean bl2 = bl = this.findImageControl() != null && this.drawCount == 0 && OS.IsWindowVisible(this.handle);
                if (!bl) break;
                OS.DefWindowProc(this.handle, 11, 0, 0);
            }
        }
        int n5 = OS.CallWindowProc(ListProc, n, n2, n3, n4);
        switch (n2) {
            case 276: 
            case 277: {
                if (!bl) break;
                OS.DefWindowProc(this.handle, 11, 1, 0);
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return n5;
    }

    static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int n3;
        int n4;
        this.checkWidget();
        int n5 = 0;
        int n6 = 0;
        if (n == -1) {
            if ((this.style & 0x100) != 0) {
                n5 = OS.SendMessage(this.handle, 403, 0, 0);
                n5 -= 3;
            } else {
                n4 = OS.SendMessage(this.handle, 395, 0, 0);
                int n7 = 0;
                int n8 = OS.GetDC(this.handle);
                n3 = OS.SendMessage(this.handle, 49, 0, 0);
                if (n3 != 0) {
                    n7 = OS.SelectObject(n8, n3);
                }
                RECT rECT = new RECT();
                int n9 = 3104;
                int n10 = this.getCodePage();
                TCHAR tCHAR = new TCHAR(n10, 65);
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = OS.SendMessage(this.handle, 394, n11, 0);
                    if (n12 != -1) {
                        int n13;
                        if (n12 + 1 > tCHAR.length()) {
                            tCHAR = new TCHAR(n10, n12 + 1);
                        }
                        if ((n13 = OS.SendMessage(this.handle, 393, n11, tCHAR)) != -1) {
                            OS.DrawText(n8, tCHAR, n12, rECT, n9);
                            n5 = Math.max(n5, rECT.right - rECT.left);
                        }
                    }
                    ++n11;
                }
                if (n3 != 0) {
                    OS.SelectObject(n8, n7);
                }
                OS.ReleaseDC(this.handle, n8);
            }
        }
        if (n2 == -1) {
            n4 = OS.SendMessage(this.handle, 395, 0, 0);
            n3 = OS.SendMessage(this.handle, 417, 0, 0);
            n6 = n4 * n3;
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n6 == 0) {
            n6 = 64;
        }
        if (n != -1) {
            n5 = n;
        }
        if (n2 != -1) {
            n6 = n2;
        }
        n4 = this.getBorderWidth();
        n5 += n4 * 2 + 3;
        n6 += n4 * 2;
        if ((this.style & 0x200) != 0) {
            n5 += OS.GetSystemMetrics(2);
        }
        if ((this.style & 0x100) != 0) {
            n6 += OS.GetSystemMetrics(3);
        }
        return new Point(n5, n6);
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n = OS.SendMessage(this.handle, 392, 0, 0);
            if (n == -1) {
                return;
            }
            int n2 = 0;
            while (n2 < nArray.length) {
                if (n == nArray[n2]) {
                    OS.SendMessage(this.handle, 390, -1, 0);
                    return;
                }
                ++n2;
            }
            return;
        }
        int n = 0;
        while (n < nArray.length) {
            int n3 = nArray[n];
            if (n3 != -1) {
                OS.SendMessage(this.handle, 389, 0, n3);
            }
            ++n;
        }
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n == -1) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n2 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n2 == -1) {
                return;
            }
            if (n2 == n) {
                OS.SendMessage(this.handle, 390, -1, 0);
            }
            return;
        }
        OS.SendMessage(this.handle, 389, 0, n);
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if ((this.style & 4) != 0) {
            int n3 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n3 == -1) {
                return;
            }
            if (n <= n3 && n3 <= n2) {
                OS.SendMessage(this.handle, 390, -1, 0);
            }
            return;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n < 0 && n2 < 0) {
            return;
        }
        if (n >= n4 && n2 >= n4) {
            return;
        }
        n = Math.min(n4 - 1, Math.max(0, n));
        n2 = Math.min(n4 - 1, Math.max(0, n2));
        OS.SendMessage(this.handle, 387, n2, n);
    }

    public void deselectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            OS.SendMessage(this.handle, 390, -1, 0);
        } else {
            OS.SendMessage(this.handle, 389, 0, -1);
        }
    }

    public int getFocusIndex() {
        int n;
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 415, 0, 0);
        if (n2 == 0 && (n = OS.SendMessage(this.handle, 395, 0, 0)) == 0) {
            return -1;
        }
        return n2;
    }

    public String getItem(int n) {
        TCHAR tCHAR;
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 394, n, 0);
        if (n3 != -1 && (n2 = OS.SendMessage(this.handle, 393, n, tCHAR = new TCHAR(this.getCodePage(), n3 + 1))) != -1) {
            return tCHAR.toString(0, n3);
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n >= 0 && n < n4) {
            this.error(8);
        }
        this.error(6);
        return "";
    }

    public int getItemCount() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 395, 0, 0);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getItemHeight() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 417, 0, 0);
        if (n == -1) {
            this.error(11);
        }
        return n;
    }

    public String[] getItems() {
        this.checkWidget();
        int n = this.getItemCount();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = this.getSelectionIndices();
        String[] stringArray = new String[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = this.getItem(nArray[n]);
            ++n;
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n = OS.SendMessage(this.handle, 392, 0, 0);
            if (n == -1) {
                return 0;
            }
            return 1;
        }
        int n = OS.SendMessage(this.handle, 400, 0, 0);
        if (n == -1) {
            this.error(36);
        }
        return n;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return OS.SendMessage(this.handle, 392, 0, 0);
        }
        int n = OS.SendMessage(this.handle, 400, 0, 0);
        if (n == -1) {
            this.error(9);
        }
        if (n == 0) {
            return -1;
        }
        int n2 = OS.SendMessage(this.handle, 415, 0, 0);
        int n3 = OS.SendMessage(this.handle, 391, n2, 0);
        if (n3 == -1) {
            this.error(9);
        }
        if (n3 != 0) {
            return n2;
        }
        int[] nArray = new int[1];
        n3 = OS.SendMessage(this.handle, 401, 1, nArray);
        if (n3 != 1) {
            this.error(9);
        }
        return nArray[0];
    }

    public int[] getSelectionIndices() {
        int[] nArray;
        int n;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int n2 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n2 == -1) {
                return new int[0];
            }
            return new int[]{n2};
        }
        int n3 = OS.SendMessage(this.handle, 400, 0, 0);
        if (n3 == -1) {
            this.error(9);
        }
        if ((n = OS.SendMessage(this.handle, 401, n3, nArray = new int[n3])) != n3) {
            this.error(9);
        }
        return nArray;
    }

    public int getTopIndex() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 398, 0, 0);
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int n2 = this.getItemCount();
            int n3 = n;
            while (n3 < n2) {
                if (string.equals(this.getItem(n3))) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
        int n4 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n < 0 || n >= n4) {
            return -1;
        }
        int n5 = n - 1;
        TCHAR tCHAR = new TCHAR(this.getCodePage(), string, true);
        do {
            int n6;
            if ((n5 = OS.SendMessage(this.handle, 418, n6 = n5, tCHAR)) != -1 && n5 > n6) continue;
            return -1;
        } while (!string.equals(this.getItem(n5)));
        return n5;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 391, n, 0);
        return n2 != 0 && n2 != -1;
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        this.sort(nArray2);
        int n = nArray2[nArray2.length - 1];
        int n2 = nArray2[0];
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        int n4 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n5 = OS.GetDC(this.handle);
            n7 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n7 != 0) {
                n6 = OS.SelectObject(n5, n7);
            }
        }
        int n9 = this.getCodePage();
        int n10 = 0;
        int n11 = 0;
        int n12 = -1;
        while (n10 < nArray2.length) {
            int n13 = nArray2[n10];
            if (n13 != n12) {
                int n14;
                int n15;
                TCHAR tCHAR = null;
                if ((this.style & 0x100) != 0 && ((n15 = OS.SendMessage(this.handle, 394, n13, 0)) == -1 || (n14 = OS.SendMessage(this.handle, 393, n13, tCHAR = new TCHAR(n9, n15 + 1))) == -1) || (n15 = OS.SendMessage(this.handle, 386, n13, 0)) == -1) break;
                if ((this.style & 0x100) != 0) {
                    n14 = 3104;
                    OS.DrawText(n5, tCHAR, -1, rECT, n14);
                    n8 = Math.max(n8, rECT.right - rECT.left);
                }
                if (n13 < n4) {
                    ++n11;
                }
                n12 = n13;
            }
            ++n10;
        }
        if ((this.style & 0x100) != 0) {
            if (n7 != 0) {
                OS.SelectObject(n5, n6);
            }
            OS.ReleaseDC(this.handle, n5);
            this.setScrollWidth(n8, false);
        }
        if (n11 > 0) {
            OS.SendMessage(this.handle, 407, n4 -= n11, 0);
        }
        if (n10 < nArray2.length) {
            this.error(15);
        }
    }

    public void remove(int n) {
        int n2;
        int n3;
        int n4;
        this.checkWidget();
        TCHAR tCHAR = null;
        if ((this.style & 0x100) != 0) {
            n4 = OS.SendMessage(this.handle, 394, n, 0);
            if (n4 == -1) {
                n3 = OS.SendMessage(this.handle, 395, 0, 0);
                if (n >= 0 && n < n3) {
                    this.error(15);
                }
                this.error(6);
            }
            if ((n3 = OS.SendMessage(this.handle, 393, n, tCHAR = new TCHAR(this.getCodePage(), n4 + 1))) == -1) {
                n2 = OS.SendMessage(this.handle, 395, 0, 0);
                if (n >= 0 && n < n2) {
                    this.error(15);
                }
                this.error(6);
            }
        }
        n4 = OS.SendMessage(this.handle, 398, 0, 0);
        n3 = OS.SendMessage(this.handle, 386, n, 0);
        if (n3 == -1) {
            n2 = OS.SendMessage(this.handle, 395, 0, 0);
            if (n >= 0 && n < n2) {
                this.error(15);
            }
            this.error(6);
        }
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth(tCHAR, false);
        }
        if (n < n4) {
            OS.SendMessage(this.handle, 407, n4 - 1, 0);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n < 0 || n > n2 || n2 >= n3) {
            this.error(6);
        }
        if (n == 0 && n2 == n3 - 1) {
            this.removeAll();
            return;
        }
        int n4 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n5 = OS.GetDC(this.handle);
            n7 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n7 != 0) {
                n6 = OS.SelectObject(n5, n7);
            }
        }
        int n9 = this.getCodePage();
        int n10 = n;
        int n11 = 3104;
        while (n10 <= n2) {
            int n12;
            int n13;
            TCHAR tCHAR = null;
            if ((this.style & 0x100) != 0 && ((n13 = OS.SendMessage(this.handle, 394, n, 0)) == -1 || (n12 = OS.SendMessage(this.handle, 393, n, tCHAR = new TCHAR(n9, n13 + 1))) == -1) || (n13 = OS.SendMessage(this.handle, 386, n, 0)) == -1) break;
            if ((this.style & 0x100) != 0) {
                OS.DrawText(n5, tCHAR, -1, rECT, n11);
                n8 = Math.max(n8, rECT.right - rECT.left);
            }
            ++n10;
        }
        if ((this.style & 0x100) != 0) {
            if (n7 != 0) {
                OS.SelectObject(n5, n6);
            }
            OS.ReleaseDC(this.handle, n5);
            this.setScrollWidth(n8, false);
        }
        if (n2 < n4) {
            OS.SendMessage(this.handle, 407, n4 -= n2 - n + 1, 0);
        }
        if (n10 <= n2) {
            this.error(15);
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        OS.SendMessage(this.handle, 388, 0, 0);
        if ((this.style & 0x100) != 0) {
            OS.SendMessage(this.handle, 404, 0, 0);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.select(nArray, false);
    }

    void select(int[] nArray, boolean bl) {
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (n2 != -1) {
                this.select(n2, false);
            }
            ++n;
        }
        if (bl) {
            this.showSelection();
        }
    }

    public void select(int n) {
        this.checkWidget();
        this.select(n, false);
    }

    void select(int n, boolean bl) {
        boolean bl2;
        if (n < 0) {
            return;
        }
        int n2 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n >= n2) {
            return;
        }
        if (bl) {
            if ((this.style & 4) != 0) {
                OS.SendMessage(this.handle, 390, n, 0);
            } else {
                OS.SendMessage(this.handle, 389, 1, n);
            }
            return;
        }
        int n3 = OS.SendMessage(this.handle, 398, 0, 0);
        RECT rECT = new RECT();
        RECT rECT2 = null;
        OS.SendMessage(this.handle, 408, n, rECT);
        boolean bl3 = bl2 = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (bl2) {
            OS.UpdateWindow(this.handle);
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        int n4 = -1;
        if ((this.style & 4) != 0) {
            int n5 = OS.SendMessage(this.handle, 392, 0, 0);
            if (n5 != -1) {
                rECT2 = new RECT();
                OS.SendMessage(this.handle, 408, n5, rECT2);
            }
            OS.SendMessage(this.handle, 390, n, 0);
        } else {
            n4 = OS.SendMessage(this.handle, 415, 0, 0);
            OS.SendMessage(this.handle, 389, 1, n);
        }
        if ((this.style & 2) != 0 && n4 != -1) {
            OS.SendMessage(this.handle, 414, n4, 0);
        }
        OS.SendMessage(this.handle, 407, n3, 0);
        if (bl2) {
            OS.SendMessage(this.handle, 11, 1, 0);
            OS.ValidateRect(this.handle, null);
            OS.InvalidateRect(this.handle, rECT, true);
            if (rECT2 != null) {
                OS.InvalidateRect(this.handle, rECT2, true);
            }
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if ((this.style & 4) != 0) {
            this.select(n, false);
        } else {
            this.select(n, n2, false);
        }
    }

    void select(int n, int n2, boolean bl) {
        if (n == n2) {
            this.select(n, bl);
            return;
        }
        OS.SendMessage(this.handle, 387, n, n2);
        if (bl) {
            this.showSelection();
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        OS.SendMessage(this.handle, 389, 1, -1);
    }

    void setFocusIndex(int n) {
        int n2 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n < 0 || n >= n2) {
            return;
        }
        OS.SendMessage(this.handle, 414, n, 0);
    }

    public void setFont(Font font) {
        this.checkWidget();
        super.setFont(font);
        if ((this.style & 0x100) != 0) {
            this.setScrollWidth();
        }
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = this.getTopIndex();
        boolean bl = this.isSelected(n);
        this.remove(n);
        this.add(string, n);
        if (bl) {
            this.select(n, false);
        }
        this.setTopIndex(n2);
    }

    public void setItems(String[] stringArray) {
        boolean bl;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                this.error(5);
            }
            ++n;
        }
        n = OS.GetWindowLongPtr(this.handle, -4);
        OS.SetWindowLongPtr(this.handle, -4, ListProc);
        boolean bl2 = bl = this.drawCount == 0 && OS.IsWindowVisible(this.handle);
        if (bl) {
            OS.SendMessage(this.handle, 11, 0, 0);
        }
        RECT rECT = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            rECT = new RECT();
            n2 = OS.GetDC(this.handle);
            n4 = OS.SendMessage(this.handle, 49, 0, 0);
            if (n4 != 0) {
                n3 = OS.SelectObject(n2, n4);
            }
            OS.SendMessage(this.handle, 404, 0, 0);
        }
        int n6 = stringArray.length;
        OS.SendMessage(this.handle, 388, 0, 0);
        OS.SendMessage(this.handle, 424, n6, n6 * 32);
        int n7 = 0;
        int n8 = this.getCodePage();
        while (n7 < n6) {
            String string = stringArray[n7];
            TCHAR tCHAR = new TCHAR(n8, string, true);
            int n9 = OS.SendMessage(this.handle, 384, 0, tCHAR);
            if (n9 == -1 || n9 == -2) break;
            if ((this.style & 0x100) != 0) {
                int n10 = 3104;
                OS.DrawText(n2, tCHAR, -1, rECT, n10);
                n5 = Math.max(n5, rECT.right - rECT.left);
            }
            ++n7;
        }
        if ((this.style & 0x100) != 0) {
            if (n4 != 0) {
                OS.SelectObject(n2, n3);
            }
            OS.ReleaseDC(this.handle, n2);
            OS.SendMessage(this.handle, 404, n5 + 3, 0);
        }
        if (bl) {
            OS.SendMessage(this.handle, 11, 1, 0);
        }
        OS.SetWindowLongPtr(this.handle, -4, n);
        if (n7 < stringArray.length) {
            this.error(14);
        }
    }

    void setScrollWidth() {
        int n = 0;
        RECT rECT = new RECT();
        int n2 = 0;
        int n3 = OS.GetDC(this.handle);
        int n4 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n4 != 0) {
            n2 = OS.SelectObject(n3, n4);
        }
        int n5 = this.getCodePage();
        int n6 = OS.SendMessage(this.handle, 395, 0, 0);
        int n7 = 3104;
        int n8 = 0;
        while (n8 < n6) {
            TCHAR tCHAR;
            int n9;
            int n10 = OS.SendMessage(this.handle, 394, n8, 0);
            if (n10 != -1 && (n9 = OS.SendMessage(this.handle, 393, n8, tCHAR = new TCHAR(n5, n10 + 1))) != -1) {
                OS.DrawText(n3, tCHAR, -1, rECT, n7);
                n = Math.max(n, rECT.right - rECT.left);
            }
            ++n8;
        }
        if (n4 != 0) {
            OS.SelectObject(n3, n2);
        }
        OS.ReleaseDC(this.handle, n3);
        OS.SendMessage(this.handle, 404, n + 3, 0);
    }

    void setScrollWidth(TCHAR tCHAR, boolean bl) {
        RECT rECT = new RECT();
        int n = 0;
        int n2 = OS.GetDC(this.handle);
        int n3 = OS.SendMessage(this.handle, 49, 0, 0);
        if (n3 != 0) {
            n = OS.SelectObject(n2, n3);
        }
        int n4 = 3104;
        OS.DrawText(n2, tCHAR, -1, rECT, n4);
        if (n3 != 0) {
            OS.SelectObject(n2, n);
        }
        OS.ReleaseDC(this.handle, n2);
        this.setScrollWidth(rECT.right - rECT.left, bl);
    }

    void setScrollWidth(int n, boolean bl) {
        n += 3;
        int n2 = OS.SendMessage(this.handle, 403, 0, 0);
        if (bl) {
            if (n <= n2) {
                return;
            }
            OS.SendMessage(this.handle, 404, n, 0);
        } else {
            if (n < n2) {
                return;
            }
            this.setScrollWidth();
        }
    }

    public void setSelection(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray, true);
        if ((this.style & 2) != 0 && (n = nArray[0]) >= 0) {
            this.setFocusIndex(n);
        }
    }

    public void setSelection(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n = stringArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        int n2 = -1;
        int n3 = n - 1;
        while (n3 >= 0) {
            String string = stringArray[n3];
            int n4 = 0;
            if (string != null) {
                int n5 = -1;
                while ((n4 = this.indexOf(string, n4)) != -1) {
                    if (n5 == -1) {
                        n5 = n4;
                    }
                    this.select(n4, false);
                    if ((this.style & 4) != 0 && this.isSelected(n4)) {
                        this.showSelection();
                        return;
                    }
                    ++n4;
                }
                if (n5 != -1) {
                    n2 = n5;
                }
            }
            --n3;
        }
        if ((this.style & 2) != 0 && n2 >= 0) {
            this.setFocusIndex(n2);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.select(n, true);
        if ((this.style & 2) != 0 && n >= 0) {
            this.setFocusIndex(n);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        this.deselectAll();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if ((this.style & 4) != 0) {
            this.select(n, true);
        } else {
            this.select(n, n2, true);
            this.setFocusIndex(n);
        }
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        int n2 = OS.SendMessage(this.handle, 407, n, 0);
        if (n2 == -1) {
            int n3 = OS.SendMessage(this.handle, 395, 0, 0);
            n = Math.min(n3 - 1, Math.max(0, n));
            OS.SendMessage(this.handle, 407, n, 0);
        }
    }

    public void showSelection() {
        int n;
        int n2;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            n2 = OS.SendMessage(this.handle, 392, 0, 0);
        } else {
            int[] nArray = new int[1];
            n = OS.SendMessage(this.handle, 401, 1, nArray);
            n2 = nArray[0];
            if (n != 1) {
                n2 = -1;
            }
        }
        if (n2 == -1) {
            return;
        }
        int n3 = OS.SendMessage(this.handle, 395, 0, 0);
        if (n3 == 0) {
            return;
        }
        n = OS.SendMessage(this.handle, 417, 0, 0);
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        int n4 = OS.SendMessage(this.handle, 398, 0, 0);
        int n5 = Math.max(rECT.bottom / n, 1);
        int n6 = Math.min(n4 + n5, n3) - 1;
        if (n4 <= n2 && n2 <= n6) {
            return;
        }
        int n7 = Math.min(Math.max(n2 - n5 / 2, 0), n3 - 1);
        OS.SendMessage(this.handle, 407, n7, 0);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 1 | 0x100;
        if ((this.style & 4) != 0) {
            return n;
        }
        if ((this.style & 2) != 0) {
            if ((this.style & 0x40) != 0) {
                return n | 8;
            }
            return n | 0x800;
        }
        return n;
    }

    TCHAR windowClass() {
        return ListClass;
    }

    int windowProc() {
        return ListProc;
    }

    LRESULT WM_CHAR(int n, int n2) {
        int n3;
        LRESULT lRESULT = super.WM_CHAR(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetKeyState(17) < 0 && OS.GetKeyState(16) >= 0 && ((n3 = OS.GetWindowLong(this.handle, -16)) & 0x800) != 0) {
            switch (n) {
                case 32: {
                    int n4 = OS.SendMessage(this.handle, 415, 0, 0);
                    int n5 = OS.SendMessage(this.handle, 391, n4, 0);
                    if (n5 == -1) break;
                    OS.SendMessage(this.handle, 389, n5 != 0 ? 0 : 1, n4);
                    OS.SendMessage(this.handle, 61852, n4, 0);
                    this.postEvent(13);
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        RECT rECT;
        int n3;
        int n4;
        int n5;
        int n6;
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetKeyState(17) < 0 && OS.GetKeyState(16) >= 0 && ((n6 = OS.GetWindowLong(this.handle, -16)) & 0x800) != 0) {
            n5 = -1;
            switch (n) {
                case 32: {
                    return LRESULT.ZERO;
                }
                case 38: 
                case 40: {
                    n4 = OS.SendMessage(this.handle, 415, 0, 0);
                    n5 = Math.max(0, n4 + (n == 38 ? -1 : 1));
                    break;
                }
                case 33: {
                    n4 = OS.SendMessage(this.handle, 415, 0, 0);
                    n3 = OS.SendMessage(this.handle, 398, 0, 0);
                    if (n4 != n3) {
                        n5 = n3;
                        break;
                    }
                    this.forceResize();
                    rECT = new RECT();
                    OS.GetClientRect(this.handle, rECT);
                    int n7 = OS.SendMessage(this.handle, 417, 0, 0);
                    int n8 = Math.max(2, rECT.bottom / n7);
                    n5 = Math.max(0, n3 - (n8 - 1));
                    break;
                }
                case 34: {
                    n4 = OS.SendMessage(this.handle, 415, 0, 0);
                    n3 = OS.SendMessage(this.handle, 398, 0, 0);
                    this.forceResize();
                    rECT = new RECT();
                    OS.GetClientRect(this.handle, rECT);
                    int n9 = OS.SendMessage(this.handle, 417, 0, 0);
                    int n10 = Math.max(2, rECT.bottom / n9);
                    int n11 = n3 + n10 - 1;
                    n5 = n4 != n11 ? n11 : n11 + n10 - 1;
                    int n12 = OS.SendMessage(this.handle, 395, 0, 0);
                    if (n12 == -1) break;
                    n5 = Math.min(n12 - 1, n5);
                    break;
                }
                case 36: {
                    n5 = 0;
                    break;
                }
                case 35: {
                    n4 = OS.SendMessage(this.handle, 395, 0, 0);
                    if (n4 == -1) break;
                    n5 = n4 - 1;
                }
            }
            if (n5 != -1) {
                OS.SendMessage(this.handle, 295, 3, 0);
                OS.SendMessage(this.handle, 414, n5, 0);
                return LRESULT.ZERO;
            }
        }
        if (((n6 = OS.SendMessage(this.handle, 297, 0, 0)) & 1) != 0) {
            n5 = OS.SendMessage(this.handle, 415, 0, 0);
            n4 = this.callWindowProc(this.handle, 256, n, n2);
            n3 = OS.SendMessage(this.handle, 415, 0, 0);
            if (n5 != n3) {
                OS.SendMessage(this.handle, 295, 3, 0);
                rECT = new RECT();
                OS.SendMessage(this.handle, 408, n3, rECT);
                OS.InvalidateRect(this.handle, rECT, true);
            }
            return new LRESULT(n4);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        int n3 = OS.SendMessage(this.handle, 398, 0, 0);
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (!this.isDisposed()) {
            int n4;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 4;
            if (OS.GetScrollInfo(this.handle, 0, sCROLLINFO) && sCROLLINFO.nPos != 0) {
                OS.InvalidateRect(this.handle, null, true);
            }
            if (n3 != (n4 = OS.SendMessage(this.handle, 398, 0, 0))) {
                OS.InvalidateRect(this.handle, null, true);
            }
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(int n, int n2) {
        int n3 = OS.HIWORD(n);
        switch (n3) {
            case 1: {
                this.postEvent(13);
                break;
            }
            case 2: {
                this.postEvent(14);
            }
        }
        return super.wmCommandChild(n, n2);
    }
}

