/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.io;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.unitarou.io.Ios;
import org.unitarou.lang.IntComparator;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;

public class FileMappedIntArray
implements Closeable {
    private static final Log log_s_;
    private static final String TEMP_FILE_PREFIX = "org_unitarou_lang_io_IntFileMapList";
    private static final String TEMP_FILE_POSTFIX = ".bia";
    private static final Pattern TEMP_PATTERN;
    private final File mapFile_;
    private final File tmpFile_;
    private final RandomAccessFile raf_;
    private final FileChannel fc_;
    private MappedByteBuffer mappedByteBuffer_;
    private IntBuffer buffer_;

    public FileMappedIntArray(long l, File file) {
        try {
            this.tmpFile_ = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_POSTFIX);
            this.tmpFile_.deleteOnExit();
            this.mapFile_ = file;
            if (file.canRead()) {
                FileUtils.copyFile(this.mapFile_, this.tmpFile_);
            }
            this.raf_ = new RandomAccessFile(this.tmpFile_, "rw");
            this.fc_ = this.raf_.getChannel();
            this.fc_.lock();
            this.fc_.truncate(l);
            this.allocate(l);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public FileMappedIntArray(File file) {
        this(file.length(), file);
        this.buffer_.position(this.buffer_.limit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel = null;
        try {
            randomAccessFile = new RandomAccessFile(this.mapFile_, "rw");
            fileChannel = randomAccessFile.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, this.buffer_.position() * 4);
            IntBuffer intBuffer = mappedByteBuffer.asIntBuffer();
            this.buffer_.flip();
            intBuffer.put(this.buffer_);
        }
        catch (Throwable throwable) {
            Ios.closeQuietly(fileChannel, randomAccessFile);
            throw throwable;
        }
        Ios.closeQuietly(fileChannel, randomAccessFile);
        Ios.closeQuietly(this.fc_, this.raf_);
        this.tmpFile_.deleteOnExit();
    }

    private void allocate(long l) {
        if (Integer.MAX_VALUE < l) {
            throw new RuntimeException("Array overflow. " + l);
        }
        try {
            int n = this.buffer_ != null ? this.buffer_.position() : 0;
            this.mappedByteBuffer_ = this.fc_.map(FileChannel.MapMode.READ_WRITE, 0L, l);
            this.buffer_ = this.mappedByteBuffer_.asIntBuffer();
            this.buffer_.position(n);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Allocation failure", iOException);
        }
    }

    public void add(int n) {
        this.ensureCapacity(this.buffer_.position() + 1);
        this.buffer_.put(n);
    }

    public void ensureCapacity(int n) {
        int n2 = this.buffer_.capacity();
        if (n <= this.buffer_.capacity()) {
            return;
        }
        int n3 = n2 * 3 / 2 + 1;
        if (n3 < n) {
            n3 = n;
        }
        this.allocate(n3 * 4);
    }

    public int get(int n) {
        return this.buffer_.get(n);
    }

    public int getCapacity() {
        return this.buffer_.capacity();
    }

    public int size() {
        return this.buffer_.position();
    }

    public void load() {
        this.mappedByteBuffer_.load();
    }

    public void sort(IntComparator intComparator) {
        this.heapSort(intComparator);
    }

    private void heapSort(IntComparator intComparator) {
        int n = this.buffer_.limit();
        this.buildheap(n, intComparator);
        while (n > 1) {
            this.exchange(0, --n);
            this.downheap(0, n, intComparator);
        }
    }

    private void buildheap(int n, IntComparator intComparator) {
        for (int i = n / 2 - 1; i >= 0; --i) {
            this.downheap(i, n, intComparator);
        }
    }

    private void downheap(int n, int n2, IntComparator intComparator) {
        int n3 = 2 * n + 1;
        while (n3 < n2) {
            int n4;
            if (n3 + 1 < n2 && (n4 = intComparator.compare(this.buffer_.get(n3), this.buffer_.get(n3 + 1))) < 0) {
                ++n3;
            }
            if ((n4 = intComparator.compare(this.buffer_.get(n3), this.buffer_.get(n))) <= 0) {
                return;
            }
            this.exchange(n, n3);
            n = n3;
            n3 = 2 * n + 1;
        }
    }

    private void exchange(int n, int n2) {
        int n3 = this.buffer_.get(n);
        this.buffer_.put(n, this.buffer_.get(n2));
        this.buffer_.put(n2, n3);
    }

    static {
        File[] fileArray;
        log_s_ = LogFactory.getLog(FileMappedIntArray.class);
        TEMP_PATTERN = Pattern.compile("org_unitarou_lang_io_IntFileMapList\\d+\\.bia");
        String string = System.getProperty("java.io.tmpdir");
        File file = new File(string);
        for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return TEMP_PATTERN.matcher(string).matches();
            }
        })) {
            String string2 = file2.delete() ? "OK" : "Failure";
            log_s_.log(LogLevel.DEBUG, "Try to delete {0} ...{1}", file2, string2);
        }
    }
}

