/*
 * Decompiled with CFR 0.152.
 */
package org.unitarou.jface.pref;

import org.unitarou.jface.pref.PreferenceCodec;
import org.unitarou.lang.ArgumentChecker;
import org.unitarou.lang.Log;
import org.unitarou.lang.LogFactory;
import org.unitarou.lang.LogLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EnumCodec
implements PreferenceCodec {
    private static final Log log_s_ = LogFactory.getLog(EnumCodec.class);

    @Override
    public boolean isEncodable(Object object) {
        return object instanceof Enum;
    }

    @Override
    public String encode(Object object) {
        ArgumentChecker.throwIfNull(object);
        if (!this.isEncodable(object)) {
            throw new IllegalArgumentException();
        }
        return this.encode((Enum)object);
    }

    public String encode(Enum<?> enum_) {
        ArgumentChecker.throwIfNull(enum_);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(enum_.getDeclaringClass().getName()).append('@').append(enum_.name());
        return stringBuilder.toString();
    }

    @Override
    public Object decode(String string) {
        ArgumentChecker.throwIfNull((Object)string);
        int n = string.indexOf(64);
        if (n == -1) {
            log_s_.log(LogLevel.WARN, "[IGNORE] Unknown type value: {0}", string);
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = ++n < string.length() ? string.substring(n) : "";
        try {
            Class<?> clazz = Class.forName(string2);
            ?[] objArray = clazz.getEnumConstants();
            if (objArray == null) {
                log_s_.log(LogLevel.WARN, "[IGNORE] Unknown type value: {0}", string);
                return null;
            }
            for (Object obj : objArray) {
                if (!((Enum)obj).name().equals(string3)) continue;
                return obj;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            log_s_.log(LogLevel.WARN, "[IGNORE] {0}@{1}", string, classNotFoundException.getLocalizedMessage());
        }
        return null;
    }
}

